/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.locator;

import java.net.FileNameMap;
import java.net.URLConnection;
import org.apache.commons.io.FilenameUtils;
import org.pentaho.metaverse.api.IDocument;
import org.pentaho.metaverse.api.INamespace;
import org.pentaho.metaverse.impl.DocumentEvent;
import org.pentaho.metaverse.locator.BaseLocator;
import org.pentaho.metaverse.messages.Messages;
import org.pentaho.metaverse.util.MetaverseUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LocatorRunner<T>
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(LocatorRunner.class);
    private static FileNameMap fileNameMap = URLConnection.getFileNameMap();
    protected T root;
    protected BaseLocator locator;
    protected boolean stopping;
    protected boolean running;

    public void setRoot(T root) {
        this.root = root;
    }

    public void setLocator(BaseLocator repoLocator) {
        this.locator = repoLocator;
    }

    @Override
    public void run() {
        this.running = true;
        this.locate(this.root);
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void stop() {
        this.stopping = true;
    }

    protected abstract void locate(T var1);

    public void processFile(INamespace namespace, String name, String id, Object file) {
        String mimeType;
        if (this.stopping) {
            return;
        }
        String extension = FilenameUtils.getExtension((String)name);
        if ("".equals(extension)) {
            return;
        }
        try {
            mimeType = fileNameMap.getContentTypeFor(name);
        }
        catch (Exception e) {
            mimeType = null;
        }
        try {
            IDocument metaverseDocument = MetaverseUtil.createDocument(namespace, this.locator.getContents(file), id, name, extension, mimeType);
            DocumentEvent event = new DocumentEvent();
            event.setEventType("add");
            event.setDocument(metaverseDocument);
            this.locator.notifyListeners(event);
        }
        catch (Exception e) {
            LOG.error(Messages.getString("ERROR.NoContentForFile", name), (Throwable)e);
        }
    }
}

