/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.locator;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.repository.StringObjectId;
import org.pentaho.di.repository.filerep.KettleFileRepository;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.www.CarteSingleton;
import org.pentaho.di.www.SlaveServerConfig;
import org.pentaho.di.www.TransformationMap;
import org.pentaho.metaverse.api.IDocumentListener;
import org.pentaho.metaverse.api.IMetaverseBuilder;
import org.pentaho.metaverse.impl.DocumentController;
import org.pentaho.metaverse.impl.MetaverseBuilder;
import org.pentaho.metaverse.locator.RepositoryLocator;
import org.pentaho.metaverse.messages.Messages;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DIRepositoryLocator
extends RepositoryLocator {
    public static final String LOCATOR_TYPE = "DIRepo";
    private static final Logger LOG = LoggerFactory.getLogger(DIRepositoryLocator.class);
    private static final long serialVersionUID = 1324202912891938340L;
    protected Repository repository;
    protected IUnifiedRepository unifiedRepository;

    public DIRepositoryLocator() {
        this.setRepositoryId("DI_REPO");
        this.setLocatorType(LOCATOR_TYPE);
        this.setMetaverseBuilder((IMetaverseBuilder)MetaverseBuilder.getInstance());
        this.addDocumentListener(DocumentController.getInstance());
    }

    public DIRepositoryLocator(List<IDocumentListener> documentListeners) {
        super(documentListeners);
        this.setLocatorType(LOCATOR_TYPE);
    }

    public void setUnifiedRepository(IUnifiedRepository unifiedRepository) {
        this.unifiedRepository = unifiedRepository;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    protected Repository getRepository() throws Exception {
        if (this.repository == null) {
            TransformationMap transformationMap = CarteSingleton.getInstance().getTransformationMap();
            SlaveServerConfig slaveServerConfig = transformationMap.getSlaveServerConfig();
            this.repository = slaveServerConfig.getRepository();
        }
        if (this.repository == null) {
            LOG.error(Messages.getErrorString("ERROR.RepositoryNotFoundInConfiguration"));
        }
        return this.repository;
    }

    @Override
    protected IUnifiedRepository getUnifiedRepository(IPentahoSession session) throws Exception {
        if (this.unifiedRepository == null) {
            this.getRepository();
            Object pur = null;
            Class[] parameters = new Class[]{};
            if (this.repository != null) {
                Class<?> repositoryClass = this.repository.getClass();
                try {
                    Method m = repositoryClass.getMethod("getPur", parameters);
                    pur = m.invoke((Object)this.repository, new Object[0]);
                }
                catch (Exception e) {
                    LOG.warn(Messages.getString("WARNING.NoUnifiedRepositoryFound", this.repository.getClass().getName()));
                }
            }
            if (pur != null) {
                this.unifiedRepository = (IUnifiedRepository)pur;
            }
        }
        return this.unifiedRepository;
    }

    @Override
    protected Object getContents(RepositoryFile file) throws Exception {
        TransMeta object = null;
        Repository repo = this.getRepository();
        StringObjectId objectId = repo instanceof KettleFileRepository ? new StringObjectId(file.getPath()) : new StringObjectId(file.getId().toString());
        String extension = FilenameUtils.getExtension((String)file.getName());
        if ("ktr".equals(extension)) {
            object = repo.loadTransformation((ObjectId)objectId, null);
        } else if ("kjb".equals(extension)) {
            object = repo.loadJob((ObjectId)objectId, null);
        }
        return object;
    }

    public URI getRootUri() {
        Repository repo = null;
        URI uri = null;
        try {
            repo = this.getRepository();
        }
        catch (Exception e) {
            LOG.warn(Messages.getString("WARNING.RepositoryNotFoundNoRootURI"));
        }
        if (repo != null) {
            Method m;
            RepositoryMeta repositoryMeta = repo.getRepositoryMeta();
            Object repositoryLocation = null;
            String location = null;
            Class[] parameters = new Class[]{};
            if (repositoryMeta != null) {
                Class<?> repositoryMetaClass = repositoryMeta.getClass();
                try {
                    m = repositoryMetaClass.getMethod("getRepositoryLocation", parameters);
                    repositoryLocation = m.invoke((Object)repositoryMeta, new Object[0]);
                }
                catch (Exception e) {
                    LOG.warn(Messages.getString("WARNING.RepositoryUnknownMethodNoRootURI", repo.getClass().getName()));
                }
            }
            if (repositoryLocation != null) {
                Class<?> repositoryLocationClass = repositoryLocation.getClass();
                try {
                    m = repositoryLocationClass.getMethod("getUrl", parameters);
                    location = (String)m.invoke(repositoryLocation, new Object[0]);
                }
                catch (Exception e) {
                    LOG.warn(Messages.getString("WARNING.ExceptionFindingLocationNoRootURI"));
                }
            }
            if (location != null) {
                uri = URI.create(location);
            }
        }
        return uri;
    }
}

