/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.impl;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.metaverse.api.IGraphWriter;
import org.pentaho.metaverse.api.ILineageWriter;
import org.pentaho.metaverse.api.IMetaverseBuilder;
import org.pentaho.metaverse.api.model.IExecutionProfile;
import org.pentaho.metaverse.api.model.LineageHolder;
import org.pentaho.metaverse.graph.GraphCatalogWriter;
import org.pentaho.metaverse.graph.GraphMLWriter;
import org.pentaho.metaverse.graph.GraphSONWriter;
import org.pentaho.metaverse.impl.MetaverseConfig;
import org.pentaho.metaverse.impl.model.ExecutionProfileUtil;
import org.pentaho.metaverse.messages.Messages;
import org.pentaho.metaverse.util.MetaverseUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VfsLineageWriter
implements ILineageWriter {
    public static final String DEFAULT_OUTPUT_FOLDER = "tmp://dir";
    private static final Logger log = LoggerFactory.getLogger(VfsLineageWriter.class);
    private static final String UNKNOWN_ARTIFACT = "unknown_artifact";
    private static final int MAX_NAME_LEN = 150;
    private IGraphWriter graphWriter = new GraphMLWriter();
    private GraphCatalogWriter catalogWriter = new GraphCatalogWriter("", "", "", "", "", "");
    private String outputFolder = "tmp://dir";
    private String outputStrategy = "none";
    protected static SimpleDateFormat dateFolderFormat = new SimpleDateFormat("YYYYMMdd");

    public GraphCatalogWriter getCatalogWriter() {
        return this.catalogWriter;
    }

    public void setCatalogWriter(GraphCatalogWriter catalogWriter) {
        this.catalogWriter = catalogWriter;
    }

    public VfsLineageWriter() {
        this.setOutputStrategy(MetaverseConfig.getInstance().getExecutionGenerationStrategy());
    }

    public void outputExecutionProfile(LineageHolder holder) throws IOException {
        IExecutionProfile profile;
        if (holder != null && (profile = holder.getExecutionProfile()) != null) {
            try (OutputStream fis = this.getProfileOutputStream(holder);){
                if (fis != null) {
                    ExecutionProfileUtil.outputExecutionProfile(fis, profile);
                } else {
                    log.debug(Messages.getString("DEBUG.noProfileOutputStream"));
                }
            }
        }
    }

    public void outputLineageGraph(LineageHolder holder) throws IOException {
        IMetaverseBuilder builder;
        if (holder != null && (builder = holder.getMetaverseBuilder()) != null) {
            MetaverseUtil.delay();
            if (this.catalogWriter.clientConfigured()) {
                this.catalogWriter.outputGraph(builder.getGraph(), null);
            }
            try (OutputStream fos = this.getGraphOutputStream(holder);){
                if (fos != null) {
                    this.graphWriter.outputGraph(builder.getGraph(), fos);
                } else {
                    log.debug(Messages.getString("DEBUG.noGraphOutputStream"));
                }
            }
            MetaverseUtil.delay();
        }
    }

    public IGraphWriter getGraphWriter() {
        return this.graphWriter;
    }

    public void setGraphWriter(IGraphWriter graphWriter) {
        this.graphWriter = graphWriter;
    }

    public String getOutputFolder() {
        return this.outputFolder;
    }

    public static boolean isVFSPrefix(String prefix) {
        for (VFS_Prefixes vfs_prefix : VFS_Prefixes.values()) {
            if (!vfs_prefix.name().equalsIgnoreCase(prefix)) continue;
            return true;
        }
        return false;
    }

    public void setOutputFolder(String outputFolder) {
        int seperatorIndex = outputFolder.indexOf(":");
        if (seperatorIndex > -1) {
            String prefix = outputFolder.substring(0, outputFolder.indexOf(":"));
            if (VfsLineageWriter.isVFSPrefix(prefix)) {
                this.outputFolder = outputFolder;
            } else {
                File localFile = new File(outputFolder);
                try {
                    this.outputFolder = "file://" + localFile.getCanonicalPath();
                }
                catch (IOException e) {
                    log.error(Messages.getString("ERROR.CantUseOutputFile", outputFolder), (Throwable)e);
                }
            }
        } else {
            File localFile = new File(outputFolder);
            try {
                this.outputFolder = "file://" + localFile.getCanonicalPath();
            }
            catch (IOException e) {
                log.error(Messages.getString("ERROR.CantUseOutputFile", outputFolder), (Throwable)e);
            }
        }
    }

    protected OutputStream createOutputStream(LineageHolder holder, String extension) {
        if (holder != null) {
            try {
                IExecutionProfile profile = holder.getExecutionProfile();
                String timestampString = Long.toString(profile.getExecutionData().getStartTime().getTime());
                FileObject destFolder = this.getOutputDirectoryAsFile(holder);
                String name = this.cleanseName(Const.NVL((String)profile.getName(), (String)"unknown"));
                FileObject file = destFolder.resolveFile(timestampString + "_" + name + extension);
                FileContent content = file.getContent();
                return content.getOutputStream();
            }
            catch (Exception e) {
                log.error(Messages.getErrorString("ERROR.CantCreateOutputStream"), (Throwable)e);
                return null;
            }
        }
        return null;
    }

    protected FileObject getOutputDirectoryAsFile(LineageHolder holder) {
        try {
            FileObject dateRootFolder = this.getDateFolder(holder);
            dateRootFolder.createFolder();
            String id = this.getNameForHolder(dateRootFolder, holder);
            try {
                FileObject folder = dateRootFolder.resolveFile(id);
                folder.createFolder();
                if (folder.isFile()) {
                    throw new IllegalStateException(Messages.getErrorString("ERROR.OutputFolderWrongType", folder.getName().getPath()));
                }
                return folder;
            }
            catch (Exception e) {
                log.error(Messages.getErrorString("ERROR.CouldNotCreateFile"), (Throwable)e);
                return null;
            }
        }
        catch (Exception e) {
            log.error(Messages.getErrorString("ERROR.CouldNotCreateFile"), (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    private String getNameForHolder(FileObject root, LineageHolder holder) {
        String name;
        String string = name = holder.getId() == null ? UNKNOWN_ARTIFACT : holder.getId();
        if (name.startsWith(File.separator)) {
            name = name.substring(1);
        } else if (Const.isWindows() && name.charAt(1) == ':') {
            name = name.replaceFirst(Pattern.quote(":"), "");
        }
        name = this.cleanseName(name);
        try {
            root.resolveFile(name);
        }
        catch (FileSystemException e) {
            return UNKNOWN_ARTIFACT;
        }
        return name;
    }

    private String cleanseName(String name) {
        return name.replace(":", "-").substring(0, Math.min(name.length(), 150));
    }

    protected FileObject getDateFolder(LineageHolder holder) throws KettleFileException, FileSystemException {
        String dir = "";
        if (holder != null && holder.getExecutionProfile() != null) {
            IExecutionProfile profile = holder.getExecutionProfile();
            dir = dir + dateFolderFormat.format(profile.getExecutionData().getStartTime());
        } else {
            dir = dir + dateFolderFormat.format(new Date());
        }
        FileObject lineageRootFolder = KettleVFS.getFileObject((String)this.getOutputFolder());
        FileObject dateFolder = lineageRootFolder.resolveFile(dir);
        return dateFolder;
    }

    protected OutputStream getProfileOutputStream(LineageHolder holder) {
        return this.createOutputStream(holder, ".execution.js");
    }

    protected OutputStream getGraphOutputStream(LineageHolder holder) {
        String ext = this.graphWriter instanceof GraphMLWriter ? ".graphml" : (this.graphWriter instanceof GraphSONWriter ? ".graphson" : ".txt");
        return this.createOutputStream(holder, ext);
    }

    public String getOutputStrategy() {
        return this.outputStrategy;
    }

    public void setOutputStrategy(String strategy) {
        this.outputStrategy = strategy;
    }

    public void cleanOutput(LineageHolder holder) {
        String folderName = "unknown";
        try {
            FileObject folder = this.getOutputDirectoryAsFile(holder);
            folderName = folder.getName().getPath();
            folder.deleteAll();
        }
        catch (IOException ioe) {
            log.error(Messages.getErrorString("ERROR.CouldNotDeleteFile", folderName), (Throwable)ioe);
        }
    }

    private static enum VFS_Prefixes {
        BZIP2,
        FILE,
        FTP,
        FTPS,
        GZIP,
        HDFS,
        HTTP,
        HTTPS,
        JAR,
        RAM,
        RES,
        SFTP,
        TAR,
        TEMP,
        WEBDAV,
        ZIP;

    }
}

