/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.impl;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.VertexQuery;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.pentaho.dictionary.DictionaryConst;
import org.pentaho.dictionary.DictionaryHelper;
import org.pentaho.metaverse.api.IHasProperties;
import org.pentaho.metaverse.api.ILogicalIdGenerator;
import org.pentaho.metaverse.api.IMetaverseNode;

public class MetaverseNode
implements IMetaverseNode {
    protected Vertex v;
    private String logicalId;
    protected ILogicalIdGenerator logicalIdGenerator = DictionaryConst.LOGICAL_ID_GENERATOR_DEFAULT;
    private boolean dirty = false;

    private MetaverseNode() {
    }

    public MetaverseNode(Vertex v) {
        this();
        this.v = v;
    }

    public String getName() {
        return (String)this.v.getProperty("name");
    }

    public String getStringID() {
        return this.v.getId() == null ? null : this.v.getId().toString();
    }

    public String getType() {
        return (String)this.v.getProperty("type");
    }

    public void setName(String name) {
        this.dirty = true;
        this.v.setProperty("name", (Object)name);
    }

    public void setType(String type) {
        this.dirty = true;
        this.v.setProperty("type", (Object)type);
        String category = DictionaryHelper.getCategoryForType((String)type);
        this.v.setProperty("category", (Object)category);
    }

    public Set<String> getPropertyKeys() {
        return this.v.getPropertyKeys();
    }

    public Map<String, Object> getProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        Set<String> keys = this.getPropertyKeys();
        if (keys != null) {
            for (String key : keys) {
                props.put(key, this.v.getProperty(key));
            }
        }
        return props;
    }

    public void setProperties(Map<String, Object> properties) {
        if (properties != null) {
            this.dirty = true;
            for (Map.Entry<String, Object> property : properties.entrySet()) {
                this.v.setProperty(property.getKey(), property.getValue());
            }
        }
    }

    public void removeProperties(Set<String> keys) {
        if (keys != null) {
            this.dirty = true;
            for (String key : keys) {
                this.v.removeProperty(key);
            }
        }
    }

    public void clearProperties() {
        Set<String> keys = this.getPropertyKeys();
        if (keys != null) {
            this.dirty = true;
            for (String key : keys) {
                this.removeProperty(key);
            }
        }
    }

    public boolean containsKey(String key) {
        return this.getProperty(key) != null;
    }

    public Object getProperty(String key) {
        return this.v.getProperty(key);
    }

    public void setProperty(String key, Object value) {
        this.dirty = true;
        this.v.setProperty(key, value);
    }

    public Object removeProperty(String key) {
        this.dirty = true;
        return this.v.removeProperty(key);
    }

    public Edge addEdge(String arg0, Vertex arg1) {
        return this.v.addEdge(arg0, arg1);
    }

    public Iterable<Edge> getEdges(Direction arg0, String ... arg1) {
        return this.v.getEdges(arg0, arg1);
    }

    public Object getId() {
        return this.v.getId();
    }

    public Iterable<Vertex> getVertices(Direction arg0, String ... arg1) {
        return this.v.getVertices(arg0, arg1);
    }

    public VertexQuery query() {
        return this.v.query();
    }

    public void remove() {
        this.v.remove();
    }

    public String getLogicalId() {
        if (this.logicalIdGenerator == null) {
            return this.getStringID();
        }
        if (this.logicalId == null || this.isDirty()) {
            this.logicalId = this.logicalIdGenerator.generateId((IHasProperties)this);
        }
        return this.logicalId == null ? this.getStringID() : this.logicalId;
    }

    public void setLogicalIdGenerator(ILogicalIdGenerator idGenerator) {
        this.logicalId = null;
        this.logicalIdGenerator = idGenerator;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }
}

