/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.graph;

import com.tinkerpop.blueprints.Graph;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LineageGraphCompletionService
implements CompletionService<Graph> {
    private static final LineageGraphCompletionService INSTANCE = new LineageGraphCompletionService();
    private ExecutorCompletionService<Graph> executionCompletionService;
    private Executor executor = Executors.newCachedThreadPool();
    private static final Logger log = LoggerFactory.getLogger(LineageGraphCompletionService.class);
    private Queue<Future<Graph>> queue = new ConcurrentLinkedQueue<Future<Graph>>();

    public static LineageGraphCompletionService getInstance() {
        return INSTANCE;
    }

    private LineageGraphCompletionService() {
        this.executionCompletionService = new ExecutorCompletionService(this.executor);
    }

    @Override
    public Future<Graph> submit(Callable<Graph> task) {
        log.debug("Submitting Callable task --> " + task.toString());
        Future<Graph> f = this.executionCompletionService.submit(task);
        this.queue.add(f);
        return f;
    }

    @Override
    public Future<Graph> submit(Runnable task, Graph result) {
        log.debug("Submitting Runnable task --> " + result);
        Future<Graph> f = this.executionCompletionService.submit(task, result);
        this.queue.add(f);
        return f;
    }

    @Override
    public Future<Graph> take() throws InterruptedException {
        Future<Graph> result = this.executionCompletionService.take();
        this.queue.remove(result);
        return result;
    }

    @Override
    public Future<Graph> poll() {
        Future<Graph> result = this.executionCompletionService.poll();
        this.queue.remove(result);
        return result;
    }

    @Override
    public Future<Graph> poll(long timeout, TimeUnit unit) throws InterruptedException {
        Future<Graph> result = this.executionCompletionService.poll(timeout, unit);
        this.queue.remove(result);
        return result;
    }

    public void waitTillEmpty() throws InterruptedException, ExecutionException {
        while (this.queue.size() > 0) {
            Future<Graph> result = this.poll(200L, TimeUnit.MILLISECONDS);
            if (result == null || result.isCancelled()) continue;
            try {
                Graph graph = result.get();
                log.debug("Process Finished --> " + graph);
            }
            catch (ExecutionException e) {
                log.warn(e.getMessage(), (Throwable)e);
            }
        }
    }
}

