/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.graph;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.gremlin.Tokens;
import com.tinkerpop.gremlin.java.GremlinPipeline;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.pentaho.metaverse.api.ICatalogLineageClient;
import org.pentaho.metaverse.api.ICatalogLineageClientProvider;
import org.pentaho.metaverse.api.model.catalog.FieldLevelRelationship;
import org.pentaho.metaverse.api.model.catalog.LineageDataResource;
import org.pentaho.metaverse.graph.BaseGraphWriter;

public class GraphCatalogWriter
extends BaseGraphWriter {
    private static final Logger log = LogManager.getLogger(GraphCatalogWriter.class);
    private ICatalogLineageClient lineageClient;
    private ICatalogLineageClientProvider catalogLineageClientProvider;
    private String catalogUrl;
    private String catalogUsername;
    private String catalogPassword;
    private String catalogTokenUrl;
    private String catalogClientId;
    private String catalogClientSecret;

    public GraphCatalogWriter(String catalogUrl, String catalogUsername, String catalogPassword, String catalogTokenUrl, String catalogClientId, String catalogClientSecret) {
        this.catalogUrl = catalogUrl;
        this.catalogUsername = catalogUsername;
        this.catalogPassword = catalogPassword;
        this.catalogTokenUrl = catalogTokenUrl;
        this.catalogClientId = catalogClientId;
        this.catalogClientSecret = catalogClientSecret;
    }

    private void createCatalogClient(String catalogUrl, String catalogUsername, String catalogPassword, String catalogTokenUrl, String catalogClientId, String catalogClientSecret) {
        if (null != this.getCatalogLineageClientProvider()) {
            try {
                this.lineageClient = this.catalogLineageClientProvider.getCatalogLineageClient(catalogUrl, catalogUsername, catalogPassword, catalogTokenUrl, catalogClientId, catalogClientSecret);
            }
            catch (Exception e) {
                log.debug((Object)e);
            }
        }
    }

    public boolean clientConfigured() {
        if (null == this.lineageClient) {
            this.createCatalogClient(this.catalogUrl, this.catalogUsername, this.catalogPassword, this.catalogTokenUrl, this.catalogClientId, this.catalogClientSecret);
        }
        return null != this.lineageClient && this.lineageClient.urlConfigured();
    }

    @Override
    public void outputGraphImpl(Graph graph, OutputStream out) throws IOException {
        if (!this.clientConfigured()) {
            log.info("Could not get a catalog client; no catalog lineage processing.");
        }
        log.info("Stating lineage processing.");
        ArrayList<LineageDataResource> inputSources = new ArrayList<LineageDataResource>();
        ArrayList<LineageDataResource> outputTargets = new ArrayList<LineageDataResource>();
        GremlinPipeline inputNodesPipe = new GremlinPipeline((Object)graph).V().has("type", (Object)"Transformation Step").in(new String[]{"isreadby"}).cast(Vertex.class);
        List inputVertexes = inputNodesPipe.toList();
        inputVertexes.forEach(vertex -> this.processInputs(graph, inputSources, (Vertex)vertex));
        GremlinPipeline outputNodesPipe = new GremlinPipeline((Object)graph).V().has("type", (Object)"Transformation Step").out(new String[]{"writesto"}).cast(Vertex.class);
        List outputVertexes = outputNodesPipe.toList();
        outputVertexes.forEach(vertex -> this.processOutputs(graph, outputTargets, (Vertex)vertex));
        this.linkTargetFieldsToSources(outputTargets, inputSources, graph);
        try {
            this.lineageClient.processLineage(inputSources, outputTargets);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        log.info("Lineage processing done.");
    }

    private void processOutputs(Graph graph, ArrayList<LineageDataResource> outputTargets, Vertex vertex) {
        String tableName;
        String resourceType;
        String pathProperty = (String)vertex.getProperty("path");
        if (this.propertyPopulated(pathProperty)) {
            LineageDataResource dataResource = this.getLineageDataResourceFromFileVertex(graph, vertex, pathProperty);
            outputTargets.add(dataResource);
        }
        if (this.propertyPopulated(resourceType = (String)vertex.getProperty("type")) && resourceType.equals("Database Table") && this.propertyPopulated(tableName = (String)vertex.getProperty("table"))) {
            LineageDataResource dataResource = this.getLineageDataResourceFromTableVertex(graph, vertex, tableName);
            outputTargets.add(dataResource);
        }
    }

    private LineageDataResource getLineageDataResourceFromTableVertex(Graph graph, Vertex vertex, String tableName) {
        LineageDataResource dataResource = new LineageDataResource(tableName);
        dataResource.setVertexId(vertex.getId());
        this.findDbConnectionProperties(vertex, dataResource, "writesto");
        dataResource.setFields(this.getTableFields(tableName, graph));
        dataResource.setDbSchema((String)vertex.getProperty("schema"));
        return dataResource;
    }

    private void processInputs(Graph graph, ArrayList<LineageDataResource> inputSources, Vertex vertex) {
        String queryString;
        String pathProperty = (String)vertex.getProperty("path");
        if (this.propertyPopulated(pathProperty)) {
            LineageDataResource dataResource = this.getLineageDataResourceFromFileVertex(graph, vertex, pathProperty);
            inputSources.add(dataResource);
        }
        if (this.propertyPopulated(queryString = (String)vertex.getProperty("query"))) {
            LineageDataResource dataResource = this.getLineageDataResourceFromQueryVertex(graph, vertex, queryString);
            inputSources.add(dataResource);
        }
    }

    private LineageDataResource getLineageDataResourceFromQueryVertex(Graph graph, Vertex vertex, String queryString) {
        LineageDataResource dataResource = new LineageDataResource(queryString);
        dataResource.setVertexId(vertex.getId());
        this.findDbConnectionProperties(vertex, dataResource, "isreadby");
        dataResource.setFields(this.getQueryFields(queryString, graph));
        return dataResource;
    }

    private LineageDataResource getLineageDataResourceFromFileVertex(Graph graph, Vertex vertex, String path) {
        LineageDataResource dataResource = new LineageDataResource(this.getSourceName(path));
        String fileScheme = (String)vertex.getProperty("fileScheme");
        if (null != fileScheme) {
            switch (fileScheme) {
                case "hdfs": {
                    dataResource.parseHdfsPath(path);
                    break;
                }
                case "s3": 
                case "s3a": 
                case "s3n": {
                    dataResource.parseS3PvfsPath(path);
                    break;
                }
                default: {
                    dataResource.setPath(path);
                    log.debug(String.format("No file scheme found with path {0}", path));
                }
            }
        }
        dataResource.setVertexId(vertex.getId());
        dataResource.setFields(this.getDatasourceFields(path, graph));
        return dataResource;
    }

    private void findDbConnectionProperties(Vertex vertex, LineageDataResource dataResource, String readOrWrite) {
        Direction stepNodeDirection = readOrWrite.equals("isreadby") ? Direction.IN : Direction.OUT;
        Direction stepEdgeDirection = readOrWrite.equals("isreadby") ? Direction.OUT : Direction.IN;
        for (Edge queryEdge : vertex.getEdges(stepEdgeDirection, new String[0])) {
            if (!queryEdge.getLabel().equals(readOrWrite) || !this.hasPropertyValue(queryEdge.getVertex(stepNodeDirection), "type", "Transformation Step")) continue;
            Vertex tableStep = queryEdge.getVertex(stepNodeDirection);
            for (Edge tableEdge : tableStep.getEdges(Direction.IN, new String[0])) {
                if (!tableEdge.getLabel().equals("dependencyof") || !this.hasPropertyValue(tableEdge.getVertex(Direction.OUT), "type", "Database Connection")) continue;
                Vertex dbNode = tableEdge.getVertex(Direction.OUT);
                dataResource.setDbHost((String)dbNode.getProperty("hostName"));
                dataResource.setDbName((String)dbNode.getProperty("databaseName"));
                dataResource.setDbPort((String)dbNode.getProperty("port"));
            }
        }
    }

    private String getSourceName(String fullName) {
        String sourceName = null;
        sourceName = fullName.contains("/") ? fullName.substring(fullName.lastIndexOf("/") + 1) : (fullName.contains("\\") ? fullName.substring(fullName.lastIndexOf("\\") + 1) : fullName);
        return sourceName;
    }

    private List<String> getDatasourceFields(String sourceName, Graph graph) {
        GremlinPipeline inputFieldsPipe = new GremlinPipeline((Object)graph).V().has("path", Tokens.T.eq, (Object)sourceName).out(new String[]{"contains"}).cast(Vertex.class);
        List inputFieldVertexes = inputFieldsPipe.toList();
        ArrayList<String> fields = new ArrayList<String>();
        inputFieldVertexes.forEach(fieldVertex -> fields.add((String)fieldVertex.getProperty("name")));
        return fields;
    }

    private List<String> getQueryFields(String sourceName, Graph graph) {
        GremlinPipeline inputFieldsPipe = new GremlinPipeline((Object)graph).V().has("query", Tokens.T.eq, (Object)sourceName).out(new String[]{"contains"}).cast(Vertex.class);
        List inputFieldVertexes = inputFieldsPipe.toList();
        ArrayList<String> fields = new ArrayList<String>();
        inputFieldVertexes.forEach(fieldVertex -> fields.add((String)fieldVertex.getProperty("name")));
        return fields;
    }

    private List<String> getTableFields(String sourceName, Graph graph) {
        GremlinPipeline inputFieldsPipe = new GremlinPipeline((Object)graph).V().has("table", Tokens.T.eq, (Object)sourceName).out(new String[]{"contains"}).cast(Vertex.class);
        List inputFieldVertexes = inputFieldsPipe.toList();
        ArrayList<String> fields = new ArrayList<String>();
        inputFieldVertexes.forEach(fieldVertex -> fields.add((String)fieldVertex.getProperty("name")));
        return fields;
    }

    private void linkTargetFieldsToSources(List<LineageDataResource> outputTargets, List<LineageDataResource> inputSources, Graph graph) {
        for (LineageDataResource outputTarget : outputTargets) {
            GremlinPipeline fileFieldsPipe = new GremlinPipeline((Object)graph).V().has("path", Tokens.T.eq, (Object)outputTarget.getPath()).out(new String[]{"contains"}).cast(Vertex.class);
            GremlinPipeline tableFieldsPipe = new GremlinPipeline((Object)graph).V().has("table", Tokens.T.eq, (Object)outputTarget.getName()).out(new String[]{"contains"}).cast(Vertex.class);
            List allVertexes = fileFieldsPipe.toList();
            allVertexes.addAll(tableFieldsPipe.toList());
            allVertexes.forEach(vertex -> {
                String outputTargetResourceField = (String)vertex.getProperty("name");
                List<List<Vertex>> paths = this.findOrigins((Vertex)vertex, null);
                paths.forEach(path -> inputSources.forEach(inputSource -> {
                    if (((Vertex)path.get(0)).getId().equals(inputSource.getVertexId())) {
                        String inputSourceField = (String)((Vertex)path.get(1)).getProperty("name");
                        log.info("Field path found: " + path);
                        FieldLevelRelationship fieldRelationship = new FieldLevelRelationship();
                        fieldRelationship.setInputSourceResource(inputSource);
                        fieldRelationship.setInputSourceResourceField(inputSourceField);
                        fieldRelationship.setOutputTargetResource(outputTarget);
                        fieldRelationship.setOutputTargetResourceField(outputTargetResourceField);
                        inputSource.addFieldLevelRelationship(fieldRelationship);
                        outputTarget.addFieldLevelRelationship(fieldRelationship);
                    }
                }));
            });
        }
    }

    private List<List<Vertex>> findOrigins(Vertex vertex, Map<Vertex, Object> seenVertices) {
        ArrayList<List<Vertex>> paths = new ArrayList<List<Vertex>>();
        if (null == seenVertices) {
            seenVertices = new HashMap<Vertex, Object>();
        }
        seenVertices.put(vertex, "");
        for (Edge edge : vertex.getEdges(Direction.IN, new String[0])) {
            Vertex nextVertex;
            if (!edge.getLabel().equals("populates") && !edge.getLabel().equals("derives") && !edge.getLabel().equals("contains") || null != seenVertices.get(nextVertex = edge.getVertex(Direction.OUT))) continue;
            List<List<Vertex>> newPaths = this.findOrigins(nextVertex, seenVertices);
            newPaths.forEach(path -> path.add(vertex));
            paths.addAll(newPaths);
        }
        if (paths.isEmpty()) {
            ArrayList<Vertex> thisVertex = new ArrayList<Vertex>();
            thisVertex.add(vertex);
            paths.add(thisVertex);
        }
        return paths;
    }

    private boolean propertyPopulated(String propertyVal) {
        return null != propertyVal && !"".equals(propertyVal);
    }

    private boolean hasPropertyValue(Vertex v, String propertyName, String propertyVal) {
        String vertexPropertyValue = (String)v.getProperty(propertyName);
        return this.propertyPopulated(vertexPropertyValue) && vertexPropertyValue.equals(propertyVal);
    }

    public ICatalogLineageClientProvider getCatalogLineageClientProvider() {
        return this.catalogLineageClientProvider;
    }

    public void setCatalogLineageClientProvider(ICatalogLineageClientProvider catalogLineageClientProvider) {
        this.catalogLineageClientProvider = catalogLineageClientProvider;
    }
}

