/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.analyzer.kettle.jobentry.transjob;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleMissingPluginsException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.trans.JobEntryTrans;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.dictionary.DictionaryConst;
import org.pentaho.metaverse.analyzer.kettle.TransformationAnalyzer;
import org.pentaho.metaverse.api.IComponentDescriptor;
import org.pentaho.metaverse.api.IDocument;
import org.pentaho.metaverse.api.IMetaverseBuilder;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.INamespace;
import org.pentaho.metaverse.api.MetaverseAnalyzerException;
import org.pentaho.metaverse.api.MetaverseComponentDescriptor;
import org.pentaho.metaverse.api.analyzer.kettle.KettleAnalyzerUtil;
import org.pentaho.metaverse.api.analyzer.kettle.jobentry.IClonableJobEntryAnalyzer;
import org.pentaho.metaverse.api.analyzer.kettle.jobentry.JobEntryAnalyzer;
import org.pentaho.metaverse.api.analyzer.kettle.step.IStepAnalyzerProvider;
import org.pentaho.metaverse.api.messages.Messages;
import org.pentaho.metaverse.impl.MetaverseConfig;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransJobEntryAnalyzer
extends JobEntryAnalyzer<JobEntryTrans> {
    private Logger log = LoggerFactory.getLogger(TransJobEntryAnalyzer.class);

    public Set<Class<? extends JobEntryInterface>> getSupportedEntries() {
        HashSet<Class<? extends JobEntryInterface>> supportedEntries = new HashSet<Class<? extends JobEntryInterface>>();
        supportedEntries.add(JobEntryTrans.class);
        return supportedEntries;
    }

    protected void customAnalyze(JobEntryTrans entry, IMetaverseNode rootNode) throws MetaverseAnalyzerException {
        IDocument subTransDocument;
        TransMeta subTransMeta = null;
        JobMeta parentJobMeta = entry.getParentJob().getJobMeta();
        parentJobMeta.activateParameters();
        Repository repo = parentJobMeta.getRepository();
        String transPath = null;
        MetaverseAnalyzerException exception = null;
        switch (entry.getSpecificationMethod()) {
            case FILENAME: {
                try {
                    transPath = parentJobMeta.environmentSubstitute(entry.getFilename());
                    String normalized = KettleAnalyzerUtil.normalizeFilePath((String)transPath);
                    subTransMeta = this.getSubTransMeta(normalized);
                    entry.copyVariablesFrom((VariableSpace)subTransMeta);
                    transPath = normalized;
                }
                catch (Exception e) {
                    exception = new MetaverseAnalyzerException(Messages.getString((String)"ERROR.SubTransNotFoundInParentJob", (String)transPath, (String)parentJobMeta.toString()), (Throwable)e);
                }
                break;
            }
            case REPOSITORY_BY_NAME: {
                if (repo != null) {
                    String dir = parentJobMeta.environmentSubstitute(entry.getDirectory());
                    String file = parentJobMeta.environmentSubstitute(entry.getTransname());
                    try {
                        RepositoryDirectoryInterface rdi = repo.findDirectory(dir);
                        subTransMeta = repo.loadTransformation(file, rdi, null, true, null);
                        transPath = subTransMeta.getPathAndName() + "." + subTransMeta.getDefaultExtension();
                    }
                    catch (KettleException e) {
                        exception = new MetaverseAnalyzerException(Messages.getString((String)"ERROR.SubTransNotFoundInParentJob", (String)file, (String)parentJobMeta.toString()), (Throwable)e);
                    }
                    break;
                }
                exception = new MetaverseAnalyzerException(Messages.getString((String)"ERROR.MissingConnectionForJobSubTrans", (String)parentJobMeta.toString()));
                break;
            }
            case REPOSITORY_BY_REFERENCE: {
                if (repo != null) {
                    try {
                        subTransMeta = repo.loadTransformation(entry.getTransObjectId(), null);
                        transPath = subTransMeta.getPathAndName() + "." + subTransMeta.getDefaultExtension();
                    }
                    catch (KettleException e) {
                        exception = new MetaverseAnalyzerException(Messages.getString((String)"ERROR.SubTransNotFoundInParentJob", (String)(entry.getTransObjectId() == null ? "N/A" : entry.getTransObjectId().toString()), (String)parentJobMeta.toString()), (Throwable)e);
                    }
                    break;
                }
                exception = new MetaverseAnalyzerException(Messages.getString((String)"ERROR.MissingConnectionForJobSubTrans", (String)parentJobMeta.toString()));
            }
        }
        rootNode.setProperty("path", transPath);
        if (exception != null) {
            throw exception;
        }
        subTransMeta.copyVariablesFrom((VariableSpace)parentJobMeta);
        subTransMeta.setFilename(transPath);
        MetaverseComponentDescriptor ds = new MetaverseComponentDescriptor(subTransMeta.getName(), "Transformation", this.descriptor.getNamespace().getParentNamespace());
        IMetaverseNode transformationNode = this.createNodeFromDescriptor((IComponentDescriptor)ds);
        transformationNode.setProperty("namespace", (Object)ds.getNamespaceId());
        transformationNode.setProperty("path", (Object)transPath);
        transformationNode.setLogicalIdGenerator(DictionaryConst.LOGICAL_ID_GENERATOR_DOCUMENT);
        this.metaverseBuilder.addLink(rootNode, "executes", transformationNode);
        if (MetaverseConfig.consolidateSubGraphs() && (subTransDocument = KettleAnalyzerUtil.buildDocument((IMetaverseBuilder)this.getMetaverseBuilder(), (AbstractMeta)subTransMeta, (String)transPath, (INamespace)this.getDocumentDescriptor().getNamespace())) != null) {
            MetaverseComponentDescriptor subtransDocumentDescriptor = new MetaverseComponentDescriptor(subTransDocument.getStringID(), "Transformation", this.getDocumentDescriptor().getNamespace(), this.getDescriptor().getContext());
            TransformationAnalyzer transformationAnalyzer = new TransformationAnalyzer();
            transformationAnalyzer.setStepAnalyzerProvider((IStepAnalyzerProvider)PentahoSystem.get(IStepAnalyzerProvider.class));
            transformationAnalyzer.setMetaverseBuilder(this.getMetaverseBuilder());
            transformationAnalyzer.analyze((IComponentDescriptor)subtransDocumentDescriptor, (AbstractMeta)subTransMeta, transformationNode, transPath);
        }
    }

    protected TransMeta getSubTransMeta(String filePath) throws FileNotFoundException, KettleXMLException, KettleMissingPluginsException {
        FileInputStream fis = new FileInputStream(filePath);
        return new TransMeta((InputStream)fis, null, true, null, null);
    }

    protected IClonableJobEntryAnalyzer newInstance() {
        return new TransJobEntryAnalyzer();
    }
}

