/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.analyzer.kettle.extensionpoints.trans;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.KettleClientEnvironment;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.extension.ExtensionPoint;
import org.pentaho.di.core.extension.ExtensionPointHandler;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.parameters.UnknownParamException;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransListener;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.metaverse.analyzer.kettle.TransformationAnalyzer;
import org.pentaho.metaverse.analyzer.kettle.extensionpoints.BaseRuntimeExtensionPoint;
import org.pentaho.metaverse.analyzer.kettle.extensionpoints.trans.TransExtensionPointUtil;
import org.pentaho.metaverse.analyzer.kettle.extensionpoints.trans.TransLineageHolderMap;
import org.pentaho.metaverse.api.IDocument;
import org.pentaho.metaverse.api.IDocumentAnalyzer;
import org.pentaho.metaverse.api.IMetaverseBuilder;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.INamespace;
import org.pentaho.metaverse.api.Namespace;
import org.pentaho.metaverse.api.analyzer.kettle.KettleAnalyzerUtil;
import org.pentaho.metaverse.api.model.IExecutionData;
import org.pentaho.metaverse.api.model.IExecutionProfile;
import org.pentaho.metaverse.api.model.LineageHolder;
import org.pentaho.metaverse.api.model.kettle.MetaverseExtensionPoint;
import org.pentaho.metaverse.graph.GraphCatalogWriter;
import org.pentaho.metaverse.graph.GraphMLWriter;
import org.pentaho.metaverse.impl.MetaverseCompletionService;
import org.pentaho.metaverse.impl.MetaverseConfig;
import org.pentaho.metaverse.impl.VfsLineageWriter;
import org.pentaho.metaverse.impl.model.ExecutionProfile;
import org.pentaho.metaverse.impl.model.ParamInfo;
import org.pentaho.metaverse.messages.Messages;
import org.pentaho.metaverse.util.MetaverseUtil;

@ExtensionPoint(description="Transformation Runtime metadata extractor", extensionPointId="TransformationStartThreads", id="transRuntimeMetaverse")
public class TransformationRuntimeExtensionPoint
extends BaseRuntimeExtensionPoint
implements TransListener {
    private static final Logger log = LogManager.getLogger(TransformationRuntimeExtensionPoint.class);

    public TransformationRuntimeExtensionPoint() {
        this.setDocumentAnalyzer((IDocumentAnalyzer)new TransformationAnalyzer());
        VfsLineageWriter lineageWriter = new VfsLineageWriter();
        lineageWriter.setGraphWriter(new GraphMLWriter());
        lineageWriter.setCatalogWriter(new GraphCatalogWriter("", "", "", "", "", ""));
        lineageWriter.setOutputFolder(MetaverseConfig.getInstance().getExecutionOutputFolder());
        this.setLineageWriter(lineageWriter);
        this.setRuntimeEnabled(MetaverseConfig.isLineageExecutionEnabled());
    }

    public void callExtensionPoint(LogChannelInterface logChannelInterface, Object o) throws KettleException {
        if (o != null && o instanceof Trans) {
            Trans trans = (Trans)o;
            if (trans.isPreview() || !this.isRuntimeEnabled()) {
                return;
            }
            trans.addTransListener((TransListener)this);
            this.createExecutionProfile(logChannelInterface, trans);
            this.setConsoleLog(logChannelInterface);
        }
    }

    @Override
    protected LineageHolder getLineageHolder(Object o) {
        if (o instanceof Trans) {
            Trans trans = (Trans)o;
            return TransLineageHolderMap.getInstance().getLineageHolder(trans);
        }
        return null;
    }

    public void transStarted(Trans trans) throws KettleException {
    }

    protected void runAnalyzers(Trans trans) throws KettleException {
        if (trans == null || trans.isPreview() || !this.isRuntimeEnabled()) {
            return;
        }
        IMetaverseBuilder builder = TransLineageHolderMap.getInstance().getMetaverseBuilder(trans);
        LineageHolder holder = TransLineageHolderMap.getInstance().getLineageHolder(trans);
        IDocumentAnalyzer documentAnalyzer = this.getDocumentAnalyzer();
        if (documentAnalyzer != null) {
            documentAnalyzer.setMetaverseBuilder(builder);
            String clientName = TransformationRuntimeExtensionPoint.getExecutionEngineInfo().getName();
            Namespace namespace = new Namespace(clientName);
            IMetaverseNode designNode = builder.getMetaverseObjectFactory().createNodeObject(clientName, clientName, "Locator");
            builder.addNode(designNode);
            String id = TransExtensionPointUtil.getFilename(trans.getTransMeta());
            IDocument metaverseDocument = KettleAnalyzerUtil.buildDocument((IMetaverseBuilder)builder, (AbstractMeta)trans.getTransMeta(), (String)id, (INamespace)namespace);
            Runnable analyzerRunner = MetaverseUtil.getAnalyzerRunner(documentAnalyzer, metaverseDocument);
            holder.setLineageTask(MetaverseCompletionService.getInstance().submit(analyzerRunner, metaverseDocument.getStringID()));
        }
        holder.setMetaverseBuilder(builder);
    }

    protected void populateExecutionProfile(IExecutionProfile executionProfile, Trans trans) {
        TransMeta transMeta = trans.getTransMeta();
        String filename = trans.getFilename();
        if (filename == null) {
            filename = transMeta.getPathAndName();
        }
        String filePath = null;
        if (trans.getRepository() == null) {
            try {
                filePath = KettleAnalyzerUtil.normalizeFilePath((String)filename);
            }
            catch (Exception e) {
                log.warn("Couldn't normalize file path: " + filename, (Throwable)e);
                filePath = filename;
            }
        } else {
            filePath = filename;
        }
        executionProfile.setPath(filePath);
        executionProfile.setName(transMeta.getName());
        executionProfile.setType("Transformation");
        executionProfile.setDescription(transMeta.getDescription());
        executionProfile.setExecutionEngine(TransformationRuntimeExtensionPoint.getExecutionEngineInfo());
        IExecutionData executionData = executionProfile.getExecutionData();
        executionData.setEndTime((Date)new Timestamp(new Date().getTime()));
        KettleClientEnvironment.ClientType clientType = KettleClientEnvironment.getInstance().getClient();
        executionData.setClientExecutor(clientType == null ? "DI Server" : clientType.name());
        executionData.setExecutorUser(trans.getExecutingUser());
        executionData.setExecutorServer(trans.getExecutingServer());
        Result result = trans.getResult();
        if (result != null) {
            executionData.setFailureCount(result.getNrErrors());
        }
        List vars = transMeta.getUsedVariables();
        Map variableMap = executionData.getVariables();
        for (String var : vars) {
            String[] value = trans.getVariable(var);
            if (var == null || value == null) continue;
            variableMap.put(var, value);
        }
        String[] params = trans.listParameters();
        List paramList = executionData.getParameters();
        if (params != null) {
            for (String param : params) {
                try {
                    ParamInfo paramInfo = new ParamInfo(param, trans.getParameterDescription(param), trans.getParameterDefault(param));
                    paramList.add(paramInfo);
                }
                catch (UnknownParamException e) {
                    log.error("Couldn't find transformation parameter: " + param, (Throwable)e);
                }
            }
        }
        String[] args = trans.getArguments();
        List argList = executionData.getArguments();
        if (args != null) {
            argList.addAll(Arrays.asList(args));
        }
    }

    public void transActive(Trans trans) {
    }

    public void transFinished(Trans trans) throws KettleException {
        if (trans == null) {
            return;
        }
        if (trans.isPreview()) {
            return;
        }
        log.warn(Messages.getString("INFO.TransformationAnalyzeStarting", trans.getName()));
        this.logMinimal(Messages.getString("INFO.TransformationAnalyzeStarting", trans.getName()));
        if (this.shouldCreateGraph(trans)) {
            this.runAnalyzers(trans);
        }
        if (this.allowedAsync()) {
            this.createLineGraphAsync(trans);
        } else {
            this.createLineGraph(trans);
        }
    }

    protected void createLineGraphAsync(final Trans trans) {
        Thread lineageWorker = new Thread(new Runnable(){

            @Override
            public void run() {
                TransformationRuntimeExtensionPoint.this.createLineGraph(trans);
            }
        });
        lineageWorker.start();
    }

    private void removeSensitiveDataFromHolder(LineageHolder holder) {
        if (holder.getExecutionProfile() == null) {
            return;
        }
        Map map = holder.getExecutionProfile().getExecutionData().getExternalResources();
        map.entrySet().stream().forEach(list -> {
            if (list == null) {
                return;
            }
            ((List)list.getValue()).forEach(resourceInfo -> resourceInfo.cleanupSensitiveData());
        });
    }

    protected void createLineGraph(Trans trans) {
        log.info(Messages.getString("INFO.WrittingGraphForTransformation", trans.getName()));
        try {
            IExecutionProfile executionProfile;
            LineageHolder holder = TransLineageHolderMap.getInstance().getLineageHolder(trans);
            Future lineageTask = holder.getLineageTask();
            if (lineageTask != null) {
                try {
                    lineageTask.get();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ExecutionException e) {
                    log.warn(Messages.getString("ERROR.CouldNotWriteLineageGraph", trans.getName(), Const.NVL((String)e.getLocalizedMessage(), (String)"Unspecified")));
                    log.debug(Messages.getString("ERROR.ErrorDuringAnalysisStackTrace"), (Throwable)e);
                }
            }
            if ((executionProfile = holder.getExecutionProfile()) == null) {
                executionProfile = new ExecutionProfile();
            }
            this.populateExecutionProfile(executionProfile, trans);
            this.removeSensitiveDataFromHolder(holder);
            try {
                if (this.lineageWriter != null && !"none".equals(this.lineageWriter.getOutputStrategy())) {
                    if ("latest".equals(this.lineageWriter.getOutputStrategy())) {
                        this.lineageWriter.cleanOutput(holder);
                    }
                    this.lineageWriter.outputExecutionProfile(holder);
                }
            }
            catch (IOException e) {
                log.warn(Messages.getString("ERROR.CouldNotWriteExecutionProfile", trans.getName(), Const.NVL((String)e.getLocalizedMessage(), (String)"Unspecified")));
                log.debug(Messages.getString("ERROR.ErrorDuringAnalysisStackTrace"), (Throwable)e);
            }
            try {
                if (this.shouldCreateGraph(trans)) {
                    this.addRuntimeLineageInfo(holder);
                    if (this.lineageWriter != null && !"none".equals(this.lineageWriter.getOutputStrategy())) {
                        this.lineageWriter.outputLineageGraph(holder);
                        ExtensionPointHandler.callExtensionPoint((LogChannelInterface)trans.getLogChannel(), (String)MetaverseExtensionPoint.TransLineageWriteEnd.id, (Object)trans);
                    }
                }
            }
            catch (IOException e) {
                log.warn(Messages.getString("ERROR.CouldNotWriteExecutionProfile", trans.getName(), Const.NVL((String)e.getLocalizedMessage(), (String)"Unspecified")));
                log.debug(Messages.getString("ERROR.ErrorDuringAnalysisStackTrace"), (Throwable)e);
            }
        }
        catch (Throwable t) {
            log.warn(Messages.getString("ERROR.ErrorDuringAnalysis", trans.getName(), Const.NVL((String)t.getLocalizedMessage(), (String)"Unspecified")));
            log.debug(Messages.getString("ERROR.ErrorDuringAnalysisStackTrace"), t);
        }
        TransLineageHolderMap.getInstance().removeLineageHolder(trans);
        log.warn(Messages.getString("INFO.TransformationAnalyzeFinished", trans.getName()));
        this.logMinimal(Messages.getString("INFO.TransformationAnalyzeFinished", trans.getName()));
    }
}

