/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.vfs.ui;

import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.vfs2.AllFileSelector;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.pentaho.vfs.messages.Messages;
import org.pentaho.vfs.ui.ConstProxy;
import org.pentaho.vfs.ui.TextInputDialog;
import org.pentaho.vfs.ui.VfsBrowserListener;

public class VfsBrowser
extends Composite {
    private Image imgFolderOpen;
    private Image imgFolder;
    private Image imgFile;
    public Tree fileSystemTree = null;
    protected FileObject rootFileObject = null;
    protected FileObject selectedFileObject = null;
    protected List eventListenerList = new ArrayList();
    protected boolean showFoldersOnly = false;
    protected boolean allowDoubleClickOpenFolder = false;
    protected String fileFilter = null;
    protected HashMap fileObjectChildrenMap = new HashMap();

    public VfsBrowser(final Composite parent, int style, FileObject rootFileObject, String fileFilter, boolean showFoldersOnly, final boolean allowDoubleClickOpenFolder) {
        super(parent, style);
        this.showFoldersOnly = showFoldersOnly;
        this.allowDoubleClickOpenFolder = allowDoubleClickOpenFolder;
        this.setFilter(fileFilter);
        this.setLayout((Layout)new FillLayout());
        this.rootFileObject = rootFileObject;
        this.fileSystemTree = new Tree((Composite)this, 2052);
        this.fileSystemTree.setHeaderVisible(true);
        final TreeColumn column1 = new TreeColumn(this.fileSystemTree, 16400);
        column1.setText(Messages.getString("VfsBrowser.name"));
        column1.setWidth(260);
        final TreeColumn column2 = new TreeColumn(this.fileSystemTree, 16384);
        column2.setText(Messages.getString("VfsBrowser.type"));
        column2.setWidth(120);
        final TreeColumn column3 = new TreeColumn(this.fileSystemTree, 16384);
        column3.setText(Messages.getString("VfsBrowser.modified"));
        column3.setWidth(180);
        parent.getShell().addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent arg0) {
            }

            public void controlResized(ControlEvent arg0) {
                int treeWidth = VfsBrowser.this.fileSystemTree.getBounds().width;
                if (treeWidth > column1.getWidth()) {
                    int remainderWidth = treeWidth - (column1.getWidth() + column2.getWidth() + column3.getWidth());
                    column1.setWidth(column1.getWidth() + remainderWidth - 10);
                }
            }
        });
        Transfer[] types = new Transfer[]{TextTransfer.getInstance(), FileTransfer.getInstance()};
        DragSource ds = new DragSource((Control)this.fileSystemTree, 19);
        ds.setTransfer(types);
        ds.addDragListener((DragSourceListener)new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
                event.data = VfsBrowser.this.fileSystemTree.getSelection()[0].getText();
            }
        });
        DropTarget dt = new DropTarget((Control)this.fileSystemTree, 19);
        dt.setTransfer(types);
        dt.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                try {
                    VfsBrowser.this.moveItem(VfsBrowser.this.fileSystemTree.getSelection()[0], (TreeItem)event.item);
                }
                catch (FileSystemException e) {
                    MessageBox mb = new MessageBox(parent.getShell());
                    mb.setText(Messages.getString("VfsBrowser.error"));
                    mb.setMessage(e.getMessage());
                    mb.open();
                }
            }
        });
        this.populateFileSystemTree(rootFileObject, this.fileSystemTree, null);
        final Menu popupMenu = new Menu((Decorations)parent.getShell(), 8);
        MenuItem deleteFileItem = new MenuItem(popupMenu, 8);
        deleteFileItem.setText(Messages.getString("VfsBrowser.deleteFile"));
        deleteFileItem.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                try {
                    MessageBox messageDialog = new MessageBox(VfsBrowser.this.getDisplay().getActiveShell(), 192);
                    messageDialog.setText(Messages.getString("VfsFileChooserDialog.confirm"));
                    messageDialog.setMessage(Messages.getString("VfsFileChooserDialog.deleteFile"));
                    int status = messageDialog.open();
                    if (status == 64) {
                        VfsBrowser.this.deleteItem(VfsBrowser.this.fileSystemTree.getSelection()[0]);
                    }
                }
                catch (FileSystemException e) {
                    MessageBox errorDialog = new MessageBox(VfsBrowser.this.fileSystemTree.getDisplay().getActiveShell(), 32);
                    errorDialog.setText(Messages.getString("VfsBrowser.error"));
                    errorDialog.setMessage(e.getMessage());
                    errorDialog.open();
                }
            }
        });
        MenuItem renameFileItem = new MenuItem(popupMenu, 8);
        renameFileItem.setText(Messages.getString("VfsBrowser.renameFile"));
        renameFileItem.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                VfsBrowser.this.promptForRenameFile();
            }
        });
        MenuItem separatorItem = new MenuItem(popupMenu, 2);
        MenuItem refreshItem = new MenuItem(popupMenu, 8);
        refreshItem.setText(Messages.getString("VfsBrowser.refresh"));
        refreshItem.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                VfsBrowser.this.fileObjectChildrenMap.clear();
                try {
                    VfsBrowser.this.selectedFileObject.refresh();
                    VfsBrowser.this.applyFilter();
                }
                catch (FileSystemException e) {
                    e.printStackTrace();
                }
            }
        });
        this.fileSystemTree.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                if (VfsBrowser.this.fileSystemTree.getSelection() != null && VfsBrowser.this.fileSystemTree.getSelection().length > 0) {
                    TreeItem ti = VfsBrowser.this.fileSystemTree.getSelection()[0];
                    VfsBrowser.this.selectedFileObject = (FileObject)ti.getData();
                    try {
                        if (allowDoubleClickOpenFolder || VfsBrowser.this.selectedFileObject.getType().equals((Object)FileType.FILE)) {
                            VfsBrowser.this.fireFileObjectDoubleClicked();
                        } else {
                            ti.setExpanded(!ti.getExpanded());
                            VfsBrowser.this.fireFileObjectSelected();
                        }
                    }
                    catch (FileSystemException ex) {
                        MessageBox mb = new MessageBox(parent.getShell());
                        mb.setText(Messages.getString("VfsBrowser.cannotSelectObject"));
                        mb.setMessage(ex.getMessage());
                        mb.open();
                    }
                }
            }

            public void mouseDown(MouseEvent arg0) {
                if (arg0.button == 3) {
                    popupMenu.setVisible(true);
                }
            }

            public void mouseUp(MouseEvent arg0) {
            }
        });
        this.fileSystemTree.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent e) {
                TreeItem ti = (TreeItem)e.item;
                if (ti != null) {
                    VfsBrowser.this.selectedFileObject = (FileObject)ti.getData();
                    if (ti.getData("isLoaded") == null || !((Boolean)ti.getData("isLoaded")).booleanValue()) {
                        ti.removeAll();
                        VfsBrowser.this.populateFileSystemTree(VfsBrowser.this.selectedFileObject, VfsBrowser.this.fileSystemTree, ti);
                    }
                    VfsBrowser.this.fireFileObjectSelected();
                }
            }
        });
        this.fileSystemTree.addTreeListener(new TreeListener(){

            public void treeExpanded(TreeEvent e) {
                TreeItem ti = (TreeItem)e.item;
                ti.setImage(VfsBrowser.this.getFolderOpenImage(parent.getDisplay()));
                if (ti.getData("isLoaded") == null || !((Boolean)ti.getData("isLoaded")).booleanValue()) {
                    ti.removeAll();
                    VfsBrowser.this.populateFileSystemTree((FileObject)ti.getData(), VfsBrowser.this.fileSystemTree, ti);
                }
                VfsBrowser.this.fireFileObjectSelected();
            }

            public void treeCollapsed(TreeEvent e) {
                TreeItem ti = (TreeItem)e.item;
                ti.setImage(VfsBrowser.this.getFolderImage(parent.getDisplay()));
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                VfsBrowser.this.disposeImages();
            }
        });
    }

    protected void disposeImages() {
        if (this.imgFolderOpen != null && !this.imgFolderOpen.isDisposed()) {
            this.imgFolderOpen.dispose();
        }
        if (this.imgFolder != null && !this.imgFolder.isDisposed()) {
            this.imgFolder.dispose();
        }
        if (this.imgFile != null && !this.imgFile.isDisposed()) {
            this.imgFile.dispose();
        }
    }

    public void promptForRenameFile() {
        String defaultText;
        boolean done = false;
        String text = defaultText = this.fileSystemTree.getSelection()[0].getText();
        while (!done) {
            TextInputDialog textDialog;
            if (text == null) {
                text = defaultText;
            }
            if ((text = (textDialog = ConstProxy.isRunningOnWebspoonMode() ? new TextInputDialog(Messages.getString("VfsBrowser.enterNewFilename"), text, 500, 120) : new TextInputDialog(Messages.getString("VfsBrowser.enterNewFilename"), text, 500, 100)).open()) != null && !"".equals(text)) {
                try {
                    done = this.renameItem(this.fileSystemTree.getSelection()[0], text);
                    if (done) continue;
                    MessageBox errorDialog = new MessageBox(this.fileSystemTree.getDisplay().getActiveShell(), 32);
                    errorDialog.setText(Messages.getString("VfsBrowser.error"));
                    errorDialog.setMessage("Could not rename selection, target exists or operation not supported.");
                    errorDialog.open();
                }
                catch (FileSystemException e) {
                    MessageBox errorDialog = new MessageBox(this.fileSystemTree.getDisplay().getActiveShell(), 32);
                    errorDialog.setText(Messages.getString("VfsBrowser.error"));
                    if (e.getCause() != null) {
                        errorDialog.setMessage(e.getCause().getMessage());
                    } else {
                        errorDialog.setMessage(e.getMessage());
                    }
                    errorDialog.open();
                }
                continue;
            }
            done = true;
        }
    }

    public boolean createFolder(String folderName) throws FileSystemException {
        FileObject newFolder = this.getSelectedFileObject().resolveFile(folderName);
        if (newFolder.exists()) {
            throw new FileSystemException("vfs.provider/create-folder.error", (Object)folderName);
        }
        newFolder.createFolder();
        TreeItem newFolderTreeItem = new TreeItem(this.fileSystemTree.getSelection()[0], 0);
        newFolderTreeItem.setData((Object)newFolder);
        newFolderTreeItem.setData("isLoaded", (Object)Boolean.TRUE);
        newFolderTreeItem.setImage(this.getFolderImage(newFolderTreeItem.getDisplay()));
        this.populateTreeItemText(newFolderTreeItem, newFolder);
        this.fileSystemTree.setSelection(newFolderTreeItem);
        this.setSelectedFileObject(newFolder);
        this.fireFileObjectSelected();
        return true;
    }

    public boolean deleteSelectedItem() throws FileSystemException {
        return this.deleteItem(this.fileSystemTree.getSelection()[0]);
    }

    public boolean deleteItem(TreeItem ti) throws FileSystemException {
        FileObject file = (FileObject)ti.getData();
        if (file.getName().getPath().equals("/")) {
            return false;
        }
        if (file.delete()) {
            ti.dispose();
            return true;
        }
        MessageBox messageDialog = new MessageBox(this.fileSystemTree.getShell(), 192);
        messageDialog.setText(Messages.getString("VfsFileChooserDialog.confirm"));
        messageDialog.setMessage(Messages.getString("VfsFileChooserDialog.deleteFolderWithContents"));
        int status = messageDialog.open();
        if (status == 64 && file.delete((FileSelector)new AllFileSelector()) != 0) {
            ti.dispose();
            return true;
        }
        return false;
    }

    public boolean renameItem(TreeItem ti, String newName) throws FileSystemException {
        FileObject newFileObject;
        FileObject file = (FileObject)ti.getData();
        if (file.canRenameTo(newFileObject = file.getParent().resolveFile(newName))) {
            if (newFileObject.exists()) {
                return false;
            }
            newFileObject.createFile();
            file.moveTo(newFileObject);
            ti.setText(newName);
            ti.setData((Object)newFileObject);
            return true;
        }
        return false;
    }

    public boolean moveItem(TreeItem source, TreeItem destination) throws FileSystemException {
        FileObject file = (FileObject)source.getData();
        FileObject destFile = (FileObject)destination.getData();
        if (!file.exists() && !destFile.exists()) {
            return false;
        }
        try {
            if (destFile.getChildren() != null) {
                destFile = destFile.resolveFile(source.getText());
            }
        }
        catch (Exception e) {
            destFile = destFile.getParent().resolveFile(source.getText());
            destination = destination.getParentItem();
        }
        if (!file.getParent().equals(destFile.getParent())) {
            file.moveTo(destFile);
            TreeItem destTreeItem = new TreeItem(destination, 0);
            destTreeItem.setImage(this.getFileImage(source.getDisplay()));
            destTreeItem.setData((Object)destFile);
            destTreeItem.setData("isLoaded", (Object)Boolean.FALSE);
            this.populateTreeItemText(destTreeItem, destFile);
            source.dispose();
        }
        return true;
    }

    public void setFilter(String filter) {
        if (filter != null) {
            if (!filter.startsWith("*")) {
                filter = "*" + filter;
            }
            filter = filter.replaceAll("\\.", "\\.").replaceAll("\\*", ".*");
        }
        this.fileFilter = filter;
    }

    public void applyFilter() throws FileSystemException {
        if (this.fileSystemTree.getSelection() != null && this.fileSystemTree.getSelection().length > 0) {
            FileObject selectedFileObject = (FileObject)this.fileSystemTree.getSelection()[0].getData();
            this.fileSystemTree.removeAll();
            this.populateFileSystemTree(this.rootFileObject, this.fileSystemTree, null);
            this.selectTreeItemByFileObject(selectedFileObject, true);
        }
    }

    public void selectTreeItemByFileObject(FileObject selectedFileObject, boolean expandSelection) throws FileSystemException {
        if (selectedFileObject == null) {
            return;
        }
        ArrayList<FileObject> selectedFileObjectParentList = new ArrayList<FileObject>();
        selectedFileObjectParentList.add(selectedFileObject);
        for (FileObject parent = selectedFileObject.getParent(); parent != null && !parent.equals(this.rootFileObject); parent = parent.getParent()) {
            selectedFileObjectParentList.add(parent);
        }
        if (this.fileSystemTree.getSelection().length > 0) {
            TreeItem treeItem = this.fileSystemTree.getSelection()[0];
            treeItem.setExpanded(true);
            this.fileSystemTree.setSelection(treeItem);
            this.setSelectedFileObject(selectedFileObject);
            for (int i = selectedFileObjectParentList.size() - 1; i >= 0; --i) {
                FileObject obj = (FileObject)selectedFileObjectParentList.get(i);
                if (!((treeItem = this.findTreeItemByName(treeItem, obj.getName().getBaseName())) == null || treeItem.isDisposed() || treeItem.getData() != null && treeItem.getData("isLoaded") != null && ((Boolean)treeItem.getData("isLoaded")).booleanValue())) {
                    treeItem.removeAll();
                    this.populateFileSystemTree(obj, this.fileSystemTree, treeItem);
                }
                if (treeItem == null || treeItem.isDisposed()) continue;
                this.fileSystemTree.setSelection(treeItem);
                treeItem.setExpanded(expandSelection);
            }
        }
    }

    public void populateTreeItemText(TreeItem ti, FileObject fileObject) {
        try {
            String contentType = fileObject.getContent().getContentInfo().getContentType();
            DateFormat df = SimpleDateFormat.getDateTimeInstance();
            Date date = new Date(fileObject.getContent().getLastModifiedTime());
            if (contentType == null) {
                contentType = "";
            }
            ti.setText(new String[]{fileObject.getName().getBaseName(), contentType, df.format(date)});
        }
        catch (Throwable t) {
            ti.setText(fileObject.getName().getBaseName());
        }
    }

    public boolean setContent(TreeItem ti, byte[] data) {
        FileObject file = (FileObject)ti.getData();
        try {
            OutputStream os = file.getContent().getOutputStream();
            os.write(data);
            os.close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void resetVfsRoot(FileObject newRoot) {
        this.rootFileObject = newRoot;
        this.fileSystemTree.removeAll();
        this.populateFileSystemTree(newRoot, this.fileSystemTree, null);
        try {
            this.selectTreeItemByFileObject(newRoot, true);
        }
        catch (FileSystemException fileSystemException) {
            // empty catch block
        }
        if (this.fileSystemTree.getItemCount() > 0 && this.fileSystemTree.getSelection().length == 0) {
            this.fileSystemTree.setSelection(this.fileSystemTree.getItem(0));
            this.fileSystemTree.getItem(0).setExpanded(true);
        }
    }

    public void populateFileSystemTree(final FileObject inputFile, final Tree tree, TreeItem item) {
        if (inputFile == null) {
            return;
        }
        if (item == null) {
            item = new TreeItem(tree, 0);
            String rootName = inputFile.getName().getBaseName();
            if (rootName == null || "".equals(rootName)) {
                rootName = "/";
            }
            item.setText(rootName);
            item.setData((Object)inputFile);
            item.setExpanded(true);
            tree.setSelection(item);
        } else {
            item.setData((Object)inputFile);
        }
        final TreeItem myItem = item;
        Runnable r = new Runnable(){

            @Override
            public void run() {
                FileObject[] children = null;
                try {
                    children = (FileObject[])VfsBrowser.this.fileObjectChildrenMap.get(inputFile.getName().getFriendlyURI());
                    if (children == null && inputFile.getType().equals((Object)FileType.FOLDER)) {
                        children = inputFile.getChildren();
                        if (children == null) {
                            children = new FileObject[]{};
                        }
                        Arrays.sort(children, new Comparator<FileObject>(){

                            @Override
                            public int compare(FileObject o1, FileObject o2) {
                                try {
                                    FileType o1FileType = o1.getType();
                                    FileType o2FileType = o2.getType();
                                    if (o1FileType.equals((Object)o2FileType)) {
                                        return o1.getName().getBaseName().compareTo(o2.getName().getBaseName());
                                    }
                                    if (o1FileType.equals((Object)FileType.FOLDER)) {
                                        return -1;
                                    }
                                    if (o1FileType.equals((Object)FileType.FILE)) {
                                        return 1;
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                return 0;
                            }

                            @Override
                            public boolean equals(Object obj) {
                                return super.equals(obj);
                            }
                        });
                        VfsBrowser.this.fileObjectChildrenMap.put(inputFile.getName().getFriendlyURI(), children);
                    }
                }
                catch (FileSystemException e) {
                    e.printStackTrace();
                }
                myItem.setData("isLoaded", (Object)Boolean.TRUE);
                if (children != null) {
                    myItem.setImage(VfsBrowser.this.getFolderImage(tree.getDisplay()));
                } else if (VfsBrowser.this.showFoldersOnly) {
                    myItem.removeAll();
                    myItem.dispose();
                    return;
                }
                for (int i = 0; children != null && i < children.length; ++i) {
                    FileObject fileObj = children[i];
                    try {
                        TreeItem childTreeItem;
                        FileType fileType = fileObj.getType();
                        if ((fileType.hasChildren() || fileType.equals((Object)FileType.FOLDER)) && !fileObj.isHidden()) {
                            childTreeItem = new TreeItem(myItem, 0);
                            VfsBrowser.this.populateTreeItemText(childTreeItem, fileObj);
                            childTreeItem.setImage(VfsBrowser.this.getFileImage(tree.getDisplay()));
                            childTreeItem.setData((Object)fileObj);
                            childTreeItem.setData("isLoaded", (Object)Boolean.FALSE);
                            childTreeItem.setImage(VfsBrowser.this.getFolderImage(tree.getDisplay()));
                            TreeItem tmpItem = new TreeItem(childTreeItem, 0);
                            VfsBrowser.this.populateTreeItemText(tmpItem, fileObj);
                            continue;
                        }
                        if (fileType.equals((Object)FileType.FOLDER) || VfsBrowser.this.showFoldersOnly || !VfsBrowser.this.isAcceptedByFilter(fileObj.getName())) continue;
                        childTreeItem = new TreeItem(myItem, 0);
                        VfsBrowser.this.populateTreeItemText(childTreeItem, fileObj);
                        childTreeItem.setImage(VfsBrowser.this.getFileImage(tree.getDisplay()));
                        childTreeItem.setData((Object)fileObj);
                        childTreeItem.setData("isLoaded", (Object)Boolean.FALSE);
                        continue;
                    }
                    catch (FileSystemException e) {
                        e.printStackTrace();
                    }
                }
                if (VfsBrowser.this.fileSystemTree.getItemCount() > 0 && VfsBrowser.this.fileSystemTree.getSelection().length == 0) {
                    VfsBrowser.this.fileSystemTree.setSelection(VfsBrowser.this.fileSystemTree.getItem(0));
                    VfsBrowser.this.fileSystemTree.getItem(0).setExpanded(true);
                }
            }
        };
        BusyIndicator.showWhile((Display)tree.getDisplay(), (Runnable)r);
    }

    public boolean isAcceptedByFilter(TreeItem treeItem) {
        return this.isAcceptedByFilter(((FileObject)treeItem.getData()).getName());
    }

    public boolean isAcceptedByFilter(FileName fileName) {
        if (fileName.getBaseName().startsWith(".")) {
            return false;
        }
        if (this.fileFilter != null && !"".equals(this.fileFilter)) {
            StringTokenizer st = new StringTokenizer(this.fileFilter, ";");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (!fileName.getFriendlyURI().matches(token)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public TreeItem findTreeItemByName(TreeItem treeItem, String itemName) {
        if (treeItem == null || treeItem.getData() != null && (((FileObject)treeItem.getData()).getName().getBaseName().equals(itemName) || ((FileObject)treeItem.getData()).getName().getFriendlyURI().equals(itemName))) {
            return treeItem;
        }
        TreeItem[] children = treeItem.getItems();
        for (int i = 0; children != null && i < children.length; ++i) {
            TreeItem foundItem = this.findTreeItemByName(children[i], itemName);
            if (foundItem == null) continue;
            return foundItem;
        }
        return null;
    }

    public void selectTreeItemByName(String itemName, boolean expandSelectedItem) {
        TreeItem[] children = this.fileSystemTree.getItems();
        for (int i = 0; children != null && i < children.length; ++i) {
            TreeItem foundItem = this.findTreeItemByName(children[i], itemName);
            if (foundItem == null) continue;
            for (TreeItem parent = foundItem.getParentItem(); parent != null; parent = parent.getParentItem()) {
                parent.setExpanded(true);
            }
            foundItem.setExpanded(expandSelectedItem);
            this.setSelectedFileObject((FileObject)foundItem.getData());
            this.fileSystemTree.setSelection(foundItem);
            return;
        }
    }

    public FileObject getSelectedFileObject() {
        return this.selectedFileObject;
    }

    public void setSelectedFileObject(FileObject selectedFileObject) {
        this.selectedFileObject = selectedFileObject;
    }

    public void addVfsBrowserListener(VfsBrowserListener listener) {
        this.eventListenerList.add(listener);
    }

    public void removeVfsBrowserListener(VfsBrowserListener listener) {
        this.eventListenerList.remove(listener);
    }

    public void fireFileObjectDoubleClicked() {
        for (int i = 0; i < this.eventListenerList.size(); ++i) {
            VfsBrowserListener listener = (VfsBrowserListener)this.eventListenerList.get(i);
            listener.fireFileObjectDoubleClicked(this.getSelectedFileObject());
        }
    }

    public void fireFileObjectSelected() {
        for (int i = 0; i < this.eventListenerList.size(); ++i) {
            VfsBrowserListener listener = (VfsBrowserListener)this.eventListenerList.get(i);
            listener.fireFileObjectSelected(this.getSelectedFileObject());
        }
    }

    public void selectNextItem() {
        this.fileSystemTree.setFocus();
    }

    public void selectPreviousItem() {
        this.fileSystemTree.setFocus();
    }

    public FileObject getRootFileObject() {
        return this.rootFileObject;
    }

    public void clearFileChildren(String parent) {
        this.fileObjectChildrenMap.remove(parent);
    }

    public void clearFileChildren() {
        this.fileObjectChildrenMap.clear();
    }

    private Image getFolderOpenImage(Display display) {
        if (this.imgFolderOpen == null || this.imgFolderOpen.isDisposed()) {
            this.imgFolderOpen = new Image((Device)display, ((Object)((Object)this)).getClass().getResourceAsStream("/icons/folderopen.gif"));
        }
        return this.imgFolderOpen;
    }

    private Image getFolderImage(Display display) {
        if (this.imgFolder == null || this.imgFolder.isDisposed()) {
            this.imgFolder = new Image((Device)display, ((Object)((Object)this)).getClass().getResourceAsStream("/icons/folder.gif"));
        }
        return this.imgFolder;
    }

    private Image getFileImage(Display display) {
        if (this.imgFile == null || this.imgFile.isDisposed()) {
            this.imgFile = new Image((Device)display, ((Object)((Object)this)).getClass().getResourceAsStream("/icons/file.png"));
        }
        return this.imgFile;
    }
}

