/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.modules.sbarcodes;

import net.sourceforge.barbecue.Barcode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.krysalis.barcode4j.BarcodeGenerator;
import org.pentaho.reporting.engine.classic.core.function.AbstractExpression;
import org.pentaho.reporting.engine.classic.extensions.modules.sbarcodes.BarcodeDrawable;
import org.pentaho.reporting.engine.classic.extensions.modules.sbarcodes.BarcodeWrapper;
import org.pentaho.reporting.engine.classic.extensions.modules.sbarcodes.SimpleBarcodesUtility;

public class SimpleBarcodesExpression
extends AbstractExpression {
    private static final Log logger = LogFactory.getLog(SimpleBarcodesExpression.class);
    private String type;
    private int barHeight = 10;
    private int barWidth = 1;
    private boolean checksum = false;
    private boolean showText = true;
    private String rawDataField;
    private String rawTypeField;

    public Object getValue() {
        String data = this.getData();
        if (data == null) {
            logger.info((Object)"No data supplied to barcode element.");
            return null;
        }
        String ltype = this.type == null ? this.computeRawType() : this.type;
        if (ltype == null) {
            logger.info((Object)"No type supplied to barcode element.");
            return null;
        }
        try {
            BarcodeGenerator generator = SimpleBarcodesUtility.createBarcode4J(this.type, this.showText, this.checksum, this.barHeight);
            if (generator != null) {
                return new BarcodeDrawable(generator, data);
            }
        }
        catch (Exception e) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Error creating barcode, falling back to null value", (Throwable)e);
            }
            return null;
        }
        Barcode barcode = SimpleBarcodesUtility.createBarcode(data, ltype, this.checksum);
        if (barcode == null) {
            return null;
        }
        barcode.setDrawingText(this.showText);
        barcode.setBarWidth(this.barWidth);
        barcode.setBarHeight(this.barHeight);
        return new BarcodeWrapper(barcode);
    }

    private String getData() {
        if (this.rawDataField == null) {
            return null;
        }
        Object o = this.getDataRow().get(this.rawDataField);
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return (String)o;
        }
        logger.info((Object)"Barcode input is not a String? Using toString() method.");
        return o.toString();
    }

    private String computeRawType() {
        if (this.rawTypeField == null) {
            return null;
        }
        Object o = this.getDataRow().get(this.rawTypeField);
        if (o instanceof String) {
            return (String)o;
        }
        return null;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int getBarHeight() {
        return this.barHeight;
    }

    public void setBarHeight(int barHeight) {
        this.barHeight = barHeight;
    }

    public int getBarWidth() {
        return this.barWidth;
    }

    public void setBarWidth(int barWidth) {
        this.barWidth = barWidth;
    }

    public boolean isChecksum() {
        return this.checksum;
    }

    public void setChecksum(boolean checksum) {
        this.checksum = checksum;
    }

    public boolean isShowText() {
        return this.showText;
    }

    public void setShowText(boolean showText) {
        this.showText = showText;
    }

    public String getRawDataField() {
        return this.rawDataField;
    }

    public void setRawDataField(String rawDataField) {
        this.rawDataField = rawDataField;
    }

    public String getRawTypeField() {
        return this.rawTypeField;
    }

    public void setRawTypeField(String rawTypeField) {
        this.rawTypeField = rawTypeField;
    }
}

