/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.security.policy.rolebased.ws;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.security.policy.rolebased.RoleBindingStruct;
import org.pentaho.platform.security.policy.rolebased.ws.JaxbSafeRoleBindingStruct;
import org.pentaho.platform.security.policy.rolebased.ws.StringKeyListValueMapEntry;
import org.pentaho.platform.security.policy.rolebased.ws.StringKeyStringValueMapEntry;
import org.pentaho.platform.util.messages.Messages;

public class RoleBindingStructAdapter
extends XmlAdapter<JaxbSafeRoleBindingStruct, RoleBindingStruct> {
    private static final Log logger = LogFactory.getLog(RoleBindingStructAdapter.class);

    public JaxbSafeRoleBindingStruct marshal(RoleBindingStruct v) throws Exception {
        JaxbSafeRoleBindingStruct jaxbSafeRoleBindingStruct = new JaxbSafeRoleBindingStruct();
        try {
            Object jaxbEntry;
            if (v.logicalRoleNameMap != null) {
                ArrayList<StringKeyStringValueMapEntry> jaxbLogicalRoleNameMapEntries = new ArrayList<StringKeyStringValueMapEntry>();
                for (Map.Entry<String, Object> entry : v.logicalRoleNameMap.entrySet()) {
                    jaxbEntry = new StringKeyStringValueMapEntry();
                    ((StringKeyStringValueMapEntry)jaxbEntry).key = entry.getKey();
                    ((StringKeyStringValueMapEntry)jaxbEntry).value = (String)entry.getValue();
                    jaxbLogicalRoleNameMapEntries.add((StringKeyStringValueMapEntry)jaxbEntry);
                }
                jaxbSafeRoleBindingStruct.logicalRoleNameMapEntries = jaxbLogicalRoleNameMapEntries;
            }
            if (v.bindingMap != null) {
                ArrayList<StringKeyListValueMapEntry> jaxbBindingMapEntries = new ArrayList<StringKeyListValueMapEntry>();
                for (Map.Entry<String, Object> entry : v.bindingMap.entrySet()) {
                    jaxbEntry = new StringKeyListValueMapEntry();
                    ((StringKeyListValueMapEntry)jaxbEntry).key = entry.getKey();
                    ((StringKeyListValueMapEntry)jaxbEntry).value = (List)entry.getValue();
                    jaxbBindingMapEntries.add((StringKeyListValueMapEntry)jaxbEntry);
                }
                jaxbSafeRoleBindingStruct.bindingMapEntries = jaxbBindingMapEntries;
            }
            if (v.immutableRoles != null) {
                jaxbSafeRoleBindingStruct.immutableRoles = new HashSet<String>(v.immutableRoles);
            }
            return jaxbSafeRoleBindingStruct;
        }
        catch (Exception e) {
            logger.error((Object)Messages.getInstance().getString("RoleBindingStructAdapter.ERROR_0001_MARSHAL", new Object[]{RoleBindingStruct.class.getName(), JaxbSafeRoleBindingStruct.class.getName()}), (Throwable)e);
            throw e;
        }
    }

    public RoleBindingStruct unmarshal(JaxbSafeRoleBindingStruct v) throws Exception {
        HashMap<String, String> logicalRoleNameMap = new HashMap<String, String>();
        HashMap<String, List<String>> bindingMap = new HashMap<String, List<String>>();
        HashSet<String> immutableRoles = new HashSet<String>();
        try {
            if (v.logicalRoleNameMapEntries != null) {
                for (StringKeyStringValueMapEntry stringKeyStringValueMapEntry : v.logicalRoleNameMapEntries) {
                    logicalRoleNameMap.put(stringKeyStringValueMapEntry.key, stringKeyStringValueMapEntry.value);
                }
            }
            if (v.bindingMapEntries != null) {
                for (StringKeyListValueMapEntry stringKeyListValueMapEntry : v.bindingMapEntries) {
                    bindingMap.put(stringKeyListValueMapEntry.key, stringKeyListValueMapEntry.value);
                }
            }
            if (v.immutableRoles != null) {
                immutableRoles.addAll(v.immutableRoles);
            }
            return new RoleBindingStruct(logicalRoleNameMap, bindingMap, immutableRoles);
        }
        catch (Exception e) {
            logger.error((Object)Messages.getInstance().getString("RoleBindingStructAdapter.ERROR_0002_UNMARSHAL", new Object[]{JaxbSafeRoleBindingStruct.class.getName(), RoleBindingStruct.class.getName()}), (Throwable)e);
            throw e;
        }
    }
}

