/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.security.policy.rolebased;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.pentaho.platform.api.engine.IAuthorizationPolicy;
import org.pentaho.platform.security.policy.rolebased.IRoleAuthorizationPolicyRoleBindingDao;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.Assert;

public class RoleAuthorizationPolicy
implements IAuthorizationPolicy {
    private IRoleAuthorizationPolicyRoleBindingDao roleBindingDao;

    public RoleAuthorizationPolicy(IRoleAuthorizationPolicyRoleBindingDao roleBindingDao) {
        Assert.notNull((Object)roleBindingDao);
        this.roleBindingDao = roleBindingDao;
    }

    public List<String> getAllowedActions(String actionNamespace) {
        ArrayList<String> assignedRolesInNamespace = new ArrayList<String>();
        if (actionNamespace == null) {
            assignedRolesInNamespace.addAll(this.roleBindingDao.getBoundLogicalRoleNames(this.getRuntimeRoleNames()));
        } else {
            if (!actionNamespace.endsWith(".")) {
                actionNamespace = actionNamespace + ".";
            }
            for (String assignedRole : this.roleBindingDao.getBoundLogicalRoleNames(this.getRuntimeRoleNames())) {
                if (!assignedRole.startsWith(actionNamespace)) continue;
                assignedRolesInNamespace.add(assignedRole);
            }
        }
        return assignedRolesInNamespace;
    }

    public boolean isAllowed(String actionName) {
        return this.roleBindingDao.getBoundLogicalRoleNames(this.getRuntimeRoleNames()).contains(actionName);
    }

    protected List<String> getRuntimeRoleNames() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        Assert.state((authentication != null ? 1 : 0) != 0);
        Collection authorities = authentication.getAuthorities();
        ArrayList<String> runtimeRoles = new ArrayList<String>(authorities.size());
        for (GrantedAuthority authority : authorities) {
            runtimeRoles.add(authority.getAuthority());
        }
        return runtimeRoles;
    }
}

