/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.webservices;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.pentaho.platform.api.repository2.unified.data.node.DataNode;
import org.pentaho.platform.api.repository2.unified.data.node.DataNodeRef;
import org.pentaho.platform.api.repository2.unified.data.node.DataProperty;
import org.pentaho.platform.api.repository2.unified.data.node.NodeRepositoryFileData;
import org.pentaho.platform.api.repository2.unified.webservices.DataNodeDto;
import org.pentaho.platform.api.repository2.unified.webservices.DataPropertyDto;
import org.pentaho.platform.api.repository2.unified.webservices.NodeRepositoryFileDataDto;

public class NodeRepositoryFileDataAdapter
extends XmlAdapter<NodeRepositoryFileDataDto, NodeRepositoryFileData> {
    public NodeRepositoryFileDataDto marshal(NodeRepositoryFileData v) {
        NodeRepositoryFileDataDto d = new NodeRepositoryFileDataDto();
        DataNodeDto node = new DataNodeDto();
        d.setNode(node);
        this.toDataNodeDto(node, v.getNode());
        return d;
    }

    protected void toDataNodeDto(DataNodeDto nodeDto, DataNode node) {
        nodeDto.setName(node.getName());
        if (node.getId() != null) {
            nodeDto.setId(node.getId().toString());
        }
        ArrayList<DataPropertyDto> dtoProps = new ArrayList<DataPropertyDto>();
        for (DataProperty prop : node.getProperties()) {
            DataPropertyDto dtoProp = new DataPropertyDto();
            dtoProp.setName(prop.getName());
            if (prop.getType() == DataNode.DataPropertyType.BOOLEAN || prop.getType() == DataNode.DataPropertyType.DOUBLE || prop.getType() == DataNode.DataPropertyType.LONG || prop.getType() == DataNode.DataPropertyType.STRING || prop.getType() == DataNode.DataPropertyType.REF) {
                dtoProp.setValue(prop.getString());
            } else if (prop.getType() == DataNode.DataPropertyType.DATE) {
                Date dateProp = prop.getDate();
                dtoProp.setValue(dateProp != null ? String.valueOf(dateProp.getTime()) : null);
            } else {
                throw new IllegalArgumentException();
            }
            dtoProp.setType(prop.getType() != null ? prop.getType().ordinal() : -1);
            dtoProps.add(dtoProp);
        }
        nodeDto.setChildProperties(dtoProps);
        ArrayList<DataNodeDto> nodeDtos = new ArrayList<DataNodeDto>();
        for (DataNode childNode : node.getNodes()) {
            DataNodeDto child = new DataNodeDto();
            nodeDtos.add(child);
            this.toDataNodeDto(child, childNode);
        }
        nodeDto.setChildNodes(nodeDtos);
    }

    public NodeRepositoryFileData unmarshal(NodeRepositoryFileDataDto v) {
        DataNode node = this.toDataNode(v.getNode());
        NodeRepositoryFileData data = new NodeRepositoryFileData(node);
        return data;
    }

    protected DataNode toDataNode(DataNodeDto nodeDto) {
        DataNode node = new DataNode(nodeDto.getName());
        node.setId((Serializable)((Object)nodeDto.getId()));
        for (DataPropertyDto dtoProp : nodeDto.getChildProperties()) {
            int type = dtoProp.getType();
            String name = dtoProp.getName();
            String value = dtoProp.getValue();
            if (type == DataNode.DataPropertyType.BOOLEAN.ordinal()) {
                node.setProperty(name, Boolean.parseBoolean(value));
                continue;
            }
            if (type == DataNode.DataPropertyType.DATE.ordinal()) {
                node.setProperty(name, new Date(Long.parseLong(value)));
                continue;
            }
            if (type == DataNode.DataPropertyType.DOUBLE.ordinal()) {
                node.setProperty(name, Double.parseDouble(value));
                continue;
            }
            if (type == DataNode.DataPropertyType.LONG.ordinal()) {
                node.setProperty(name, Long.parseLong(value));
                continue;
            }
            if (type == DataNode.DataPropertyType.STRING.ordinal()) {
                node.setProperty(name, value);
                continue;
            }
            if (type == DataNode.DataPropertyType.REF.ordinal()) {
                node.setProperty(name, new DataNodeRef((Serializable)((Object)value)));
                continue;
            }
            throw new IllegalArgumentException();
        }
        for (DataNodeDto childNodeDto : nodeDto.getChildNodes()) {
            node.addNode(this.toDataNode(childNodeDto));
        }
        return node;
    }
}

