/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.jcr;

import com.pentaho.pdi.messages.Messages;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.Lock;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.pentaho.platform.api.locale.IPentahoLocale;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.repository2.unified.jcr.DefaultPathConversionHelper;
import org.pentaho.platform.repository2.unified.jcr.ILockHelper;
import org.pentaho.platform.repository2.unified.jcr.JcrRepositoryFileUtils;
import org.pentaho.platform.repository2.unified.jcr.LocalePropertyResolver;
import org.pentaho.platform.repository2.unified.jcr.LocalizationUtil;
import org.pentaho.platform.repository2.unified.jcr.PentahoJcrConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.extensions.jcr.JcrTemplate;

public class RepositoryFileProxy
extends RepositoryFile {
    private static final long serialVersionUID = 5244310953843118329L;
    private static Logger logger = LoggerFactory.getLogger(RepositoryFileProxy.class);
    private static final String INVALID_ITEM_STATE_EXCEPTION_MESSAGE = "RepositoryFileProxy.INVALID_ITEM_STATE_EXCEPTION";
    private static final String REPOSITORY_EXCEPTION_WAS_FOUND_MESSAGE = "RepositoryFileProxy.REPOSITORY_EXCEPTION_WAS_FOUND";
    private Node node;
    private PentahoJcrConstants constants;
    private JcrTemplate template;
    private Map<String, Serializable> metadata;
    private String creatorId;
    private Map<String, Properties> localeMap;
    private String description;
    private String title;
    private IPentahoLocale pentahoLocale;
    private long fileSize = -1L;
    private Date lastModifiedDate;
    private Boolean locked;
    private ILockHelper lockHelper;
    private String lockMessage;
    private String lockOwner;
    private String path;
    private String absPath;
    private Boolean folder;
    private Boolean hidden;
    private Boolean schedulable;
    private Boolean versioned;
    private Serializable id;
    private Lock lock;
    private Date lockDate;
    private String name;
    private String versionId;
    private Date createdDate;
    private Boolean aclNode;

    public RepositoryFileProxy(Node node, JcrTemplate template, IPentahoLocale pentahoLocale) {
        super(null, null, false, Boolean.valueOf(false), Boolean.valueOf(true), false, null, null, null, null, false, null, null, null, null, null, null, null, null, -1L, null, null, false);
        this.node = node;
        this.pentahoLocale = pentahoLocale;
        try {
            this.absPath = node.getPath();
        }
        catch (InvalidItemStateException | ItemNotFoundException | PathNotFoundException e) {
            RepositoryFileProxy.getLogger().warn(Messages.getInstance().getString(INVALID_ITEM_STATE_EXCEPTION_MESSAGE, new Object[]{"constructor"}));
        }
        catch (RepositoryException e) {
            RepositoryFileProxy.getLogger().error(Messages.getInstance().getString(REPOSITORY_EXCEPTION_WAS_FOUND_MESSAGE), (Throwable)e);
        }
        this.template = template;
        this.lockHelper = (ILockHelper)PentahoSystem.get(ILockHelper.class);
    }

    public static Logger getLogger() {
        return logger;
    }

    private PentahoJcrConstants getPentahoJcrConstants() {
        if (this.constants == null) {
            this.executeOperation(session -> {
                this.constants = new PentahoJcrConstants(session);
            });
        }
        return this.constants;
    }

    public int compareTo(RepositoryFile other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (this.equals(other)) {
            return 0;
        }
        return this.getTitle().compareTo(other.getTitle());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        RepositoryFile other = (RepositoryFile)obj;
        if (this.getId() == null) {
            if (other.getId() != null) {
                return false;
            }
            return this.getPath() == null || other.getPath().equals(this.getPath());
        }
        if (!this.getId().equals(other.getId())) {
            return false;
        }
        if (this.getLocale() == null ? other.getLocale() != null : !this.getLocale().equals(other.getLocale())) {
            return false;
        }
        if (this.getVersionId() == null) {
            return other.getVersionId() == null;
        }
        return this.getVersionId().equals(other.getVersionId());
    }

    public Date getCreatedDate() {
        if (this.createdDate == null) {
            this.executeOperation(session -> {
                try {
                    Calendar tmpCal;
                    if (this.node.hasProperty(this.getPentahoJcrConstants().getJCR_CREATED()) && (tmpCal = this.node.getProperty(this.getPentahoJcrConstants().getJCR_CREATED()).getDate()) != null) {
                        this.createdDate = tmpCal.getTime();
                    }
                }
                catch (InvalidItemStateException | ItemNotFoundException | PathNotFoundException e) {
                    RepositoryFileProxy.getLogger().warn(Messages.getInstance().getString(INVALID_ITEM_STATE_EXCEPTION_MESSAGE, new Object[]{"getCreatedDate"}));
                }
                catch (RepositoryException e) {
                    RepositoryFileProxy.getLogger().error(null, (Throwable)e);
                }
            });
        }
        return this.createdDate;
    }

    public Map<String, Serializable> getMetadata() {
        if (this.metadata == null) {
            this.executeOperation(session -> {
                try {
                    this.metadata = JcrRepositoryFileUtils.getFileMetadata(session, this.getId());
                }
                catch (InvalidItemStateException | ItemNotFoundException | PathNotFoundException e) {
                    RepositoryFileProxy.getLogger().warn(Messages.getInstance().getString(INVALID_ITEM_STATE_EXCEPTION_MESSAGE, new Object[]{"getMetadata"}));
                }
                catch (RepositoryException e) {
                    RepositoryFileProxy.getLogger().error(Messages.getInstance().getString(REPOSITORY_EXCEPTION_WAS_FOUND_MESSAGE), (Throwable)e);
                }
            });
        }
        return this.metadata;
    }

    public void setMetadata(Map<String, Serializable> metadata) {
        this.executeOperation(session -> {
            try {
                JcrRepositoryFileUtils.setFileMetadata(session, this.getId(), metadata);
            }
            catch (InvalidItemStateException | ItemNotFoundException | PathNotFoundException e) {
                RepositoryFileProxy.getLogger().warn(Messages.getInstance().getString(INVALID_ITEM_STATE_EXCEPTION_MESSAGE, new Object[]{"setMetadata"}));
            }
            catch (RepositoryException e) {
                RepositoryFileProxy.getLogger().error(Messages.getInstance().getString(REPOSITORY_EXCEPTION_WAS_FOUND_MESSAGE), (Throwable)e);
            }
        });
    }

    public String getCreatorId() {
        try {
            Map<String, Serializable> metadataCreatorId;
            if (this.creatorId == null && (metadataCreatorId = this.getMetadata()) != null) {
                this.creatorId = (String)((Object)metadataCreatorId.get(PentahoJcrConstants.PHO_CONTENTCREATOR));
            }
        }
        catch (Exception e) {
            RepositoryFileProxy.getLogger().error(Messages.getInstance().getString(REPOSITORY_EXCEPTION_WAS_FOUND_MESSAGE), (Throwable)e);
        }
        return this.creatorId;
    }

    private void getTitleAndDescription() {
        if (this.title == null) {
            this.executeOperation(session -> {
                try {
                    if (JcrRepositoryFileUtils.isPentahoHierarchyNode(session, this.getPentahoJcrConstants(), this.node)) {
                        if (this.node.hasNode(this.getPentahoJcrConstants().getPHO_LOCALES())) {
                            LocalePropertyResolver lpr = new LocalePropertyResolver(this.getName());
                            Locale loc = this.getPentahoLocale() != null ? this.getPentahoLocale().getLocale() : null;
                            LocalizationUtil localizationUtil = new LocalizationUtil(this.getLocalePropertiesMap(), loc);
                            this.title = localizationUtil.resolveLocalizedString(lpr.resolveDefaultTitleKey(), null);
                            if (StringUtils.isBlank((String)this.title)) {
                                this.title = localizationUtil.resolveLocalizedString(lpr.resolveTitleKey(), null);
                                if (StringUtils.isBlank((String)this.title)) {
                                    this.title = localizationUtil.resolveLocalizedString(lpr.resolveNameKey(), this.title);
                                }
                            }
                            this.description = localizationUtil.resolveLocalizedString(lpr.resolveDefaultDescriptionKey(), null);
                            if (StringUtils.isBlank((String)this.description)) {
                                this.description = localizationUtil.resolveLocalizedString(lpr.resolveDescriptionKey(), this.description);
                            }
                        }
                        if (this.title == null && this.node.hasNode(this.getPentahoJcrConstants().getPHO_TITLE())) {
                            this.title = JcrRepositoryFileUtils.getLocalizedString(session, this.getPentahoJcrConstants(), this.node.getNode(this.getPentahoJcrConstants().getPHO_TITLE()), this.pentahoLocale);
                        }
                        if (this.description == null && this.node.hasNode(this.getPentahoJcrConstants().getPHO_DESCRIPTION())) {
                            this.description = JcrRepositoryFileUtils.getLocalizedString(session, this.getPentahoJcrConstants(), this.node.getNode(this.getPentahoJcrConstants().getPHO_DESCRIPTION()), this.pentahoLocale);
                        }
                    }
                }
                catch (InvalidItemStateException | ItemNotFoundException | PathNotFoundException e) {
                    RepositoryFileProxy.getLogger().warn(Messages.getInstance().getString(INVALID_ITEM_STATE_EXCEPTION_MESSAGE, new Object[]{"getTitleAndDescription"}));
                }
                catch (RepositoryException e) {
                    RepositoryFileProxy.getLogger().error(Messages.getInstance().getString(REPOSITORY_EXCEPTION_WAS_FOUND_MESSAGE), (Throwable)e);
                }
            });
        }
    }

    public String getDescription() {
        if (this.description != null) {
            return this.description;
        }
        this.getTitleAndDescription();
        return this.description;
    }

    private IPentahoLocale getPentahoLocale() {
        return this.pentahoLocale;
    }

    public Long getFileSize() {
        if (this.fileSize == -1L) {
            this.executeOperation(session -> {
                try {
                    if (this.node.hasProperty(this.getPentahoJcrConstants().getPHO_FILESIZE())) {
                        this.fileSize = this.node.getProperty(this.getPentahoJcrConstants().getPHO_FILESIZE()).getLong();
                    }
                }
                catch (InvalidItemStateException | ItemNotFoundException | PathNotFoundException e) {
                    RepositoryFileProxy.getLogger().warn(Messages.getInstance().getString(INVALID_ITEM_STATE_EXCEPTION_MESSAGE, new Object[]{"getFileSize"}));
                }
                catch (RepositoryException e) {
                    RepositoryFileProxy.getLogger().error(Messages.getInstance().getString(REPOSITORY_EXCEPTION_WAS_FOUND_MESSAGE), (Throwable)e);
                }
            });
        }
        return this.fileSize;
    }

    public Serializable getId() {
        if (this.id == null) {
            this.executeOperation(session -> {
                try {
                    this.id = JcrRepositoryFileUtils.getNodeId(session, this.getPentahoJcrConstants(), this.node);
                }
                catch (InvalidItemStateException | ItemNotFoundException | PathNotFoundException e) {
                    RepositoryFileProxy.getLogger().warn(Messages.getInstance().getString(INVALID_ITEM_STATE_EXCEPTION_MESSAGE, new Object[]{"getId"}));
                }
                catch (RepositoryException e) {
                    RepositoryFileProxy.getLogger().error(Messages.getInstance().getString(REPOSITORY_EXCEPTION_WAS_FOUND_MESSAGE), (Throwable)e);
                }
            });
        }
        return this.id;
    }

    public Date getLastModifiedDate() {
        if (this.lastModifiedDate != null) {
            return this.lastModifiedDate;
        }
        this.executeOperation(session -> {
            try {
                this.lastModifiedDate = this.getLastModifiedDatePentahoFile(this.lastModifiedDate);
            }
            catch (InvalidItemStateException | ItemNotFoundException | PathNotFoundException e) {
                RepositoryFileProxy.getLogger().warn(Messages.getInstance().getString(INVALID_ITEM_STATE_EXCEPTION_MESSAGE, new Object[]{"getLastModifiedDate"}));
            }
            catch (RepositoryException e) {
                RepositoryFileProxy.getLogger().error(Messages.getInstance().getString(REPOSITORY_EXCEPTION_WAS_FOUND_MESSAGE), (Throwable)e);
            }
        });
        return this.lastModifiedDate;
    }

    private Date getLastModifiedDatePentahoFile(Date lastModified) throws RepositoryException {
        Calendar tmpCal;
        if (JcrRepositoryFileUtils.isPentahoFile(this.getPentahoJcrConstants(), this.node) && !this.node.isNodeType(this.getPentahoJcrConstants().getNT_FROZENNODE()) && (tmpCal = this.node.getProperty(this.getPentahoJcrConstants().getPHO_LASTMODIFIED()).getDate()) != null) {
            lastModified = tmpCal.getTime();
        }
        return lastModified;
    }

    public String getLocale() {
        IPentahoLocale loc = this.getPentahoLocale();
        return loc != null ? loc.toString() : null;
    }

    public Map<String, Properties> getLocalePropertiesMap() {
        if (this.localeMap == null) {
            this.executeOperation(session -> {
                try {
                    this.localeMap = JcrRepositoryFileUtils.getLocalePropertiesMap(session, this.getPentahoJcrConstants(), this.node.getNode(this.getPentahoJcrConstants().getPHO_LOCALES()));
                }
                catch (InvalidItemStateException | ItemNotFoundException | PathNotFoundException e) {
                    RepositoryFileProxy.getLogger().warn(Messages.getInstance().getString(INVALID_ITEM_STATE_EXCEPTION_MESSAGE, new Object[]{"getLocale"}));
                }
                catch (RepositoryException e) {
                    RepositoryFileProxy.getLogger().error(Messages.getInstance().getString(REPOSITORY_EXCEPTION_WAS_FOUND_MESSAGE), (Throwable)e);
                }
            });
        }
        return this.localeMap;
    }

    private Lock getLock() {
        if (this.lock == null) {
            this.executeOperation(session -> {
                try {
                    this.lock = session.getWorkspace().getLockManager().getLock(this.node.getPath());
                }
                catch (InvalidItemStateException | ItemNotFoundException | PathNotFoundException e) {
                    RepositoryFileProxy.getLogger().warn(Messages.getInstance().getString(INVALID_ITEM_STATE_EXCEPTION_MESSAGE, new Object[]{"getLock"}));
                }
                catch (RepositoryException e) {
                    RepositoryFileProxy.getLogger().error(Messages.getInstance().getString(REPOSITORY_EXCEPTION_WAS_FOUND_MESSAGE), (Throwable)e);
                }
            });
        }
        return this.lock;
    }

    public Date getLockDate() {
        if (this.isLocked()) {
            this.executeOperation(session -> {
                try {
                    this.lockDate = this.lockHelper.getLockDate(session, this.getPentahoJcrConstants(), this.getLock());
                }
                catch (InvalidItemStateException | ItemNotFoundException | PathNotFoundException e) {
                    RepositoryFileProxy.getLogger().warn(Messages.getInstance().getString(INVALID_ITEM_STATE_EXCEPTION_MESSAGE, new Object[]{"getLockDate"}));
                }
                catch (RepositoryException e) {
                    RepositoryFileProxy.getLogger().error(Messages.getInstance().getString(REPOSITORY_EXCEPTION_WAS_FOUND_MESSAGE), (Throwable)e);
                }
            });
        }
        return this.lockDate;
    }

    public String getLockMessage() {
        if (this.isLocked()) {
            this.executeOperation(session -> {
                try {
                    this.lockMessage = this.lockHelper.getLockMessage(session, this.getPentahoJcrConstants(), this.getLock());
                }
                catch (InvalidItemStateException | ItemNotFoundException | PathNotFoundException e) {
                    RepositoryFileProxy.getLogger().warn(Messages.getInstance().getString(INVALID_ITEM_STATE_EXCEPTION_MESSAGE, new Object[]{"getLockMessage"}));
                }
                catch (RepositoryException e) {
                    RepositoryFileProxy.getLogger().error(Messages.getInstance().getString(REPOSITORY_EXCEPTION_WAS_FOUND_MESSAGE), (Throwable)e);
                }
            });
        }
        return this.lockMessage;
    }

    public String getLockOwner() {
        if (this.isLocked()) {
            this.executeOperation(session -> {
                try {
                    this.lockOwner = this.lockHelper.getLockOwner(session, this.getPentahoJcrConstants(), this.getLock());
                }
                catch (InvalidItemStateException | ItemNotFoundException | PathNotFoundException e) {
                    RepositoryFileProxy.getLogger().warn(Messages.getInstance().getString(INVALID_ITEM_STATE_EXCEPTION_MESSAGE, new Object[]{"getLockOwner"}));
                }
                catch (RepositoryException e) {
                    RepositoryFileProxy.getLogger().error(Messages.getInstance().getString(REPOSITORY_EXCEPTION_WAS_FOUND_MESSAGE), (Throwable)e);
                }
            });
        }
        return this.lockOwner;
    }

    public String getName() {
        if (this.name == null) {
            this.executeOperation(session -> {
                try {
                    this.name = "/".equals(this.getPath()) ? "" : JcrRepositoryFileUtils.getNodeName(session, this.getPentahoJcrConstants(), this.node);
                }
                catch (InvalidItemStateException | ItemNotFoundException | PathNotFoundException e) {
                    RepositoryFileProxy.getLogger().warn(Messages.getInstance().getString(INVALID_ITEM_STATE_EXCEPTION_MESSAGE, new Object[]{"getName"}));
                }
                catch (RepositoryException e) {
                    RepositoryFileProxy.getLogger().error(Messages.getInstance().getString(REPOSITORY_EXCEPTION_WAS_FOUND_MESSAGE), (Throwable)e);
                }
            });
        }
        return this.name;
    }

    public String getPath() {
        if (this.path == null) {
            this.executeOperation(session -> {
                try {
                    this.path = new DefaultPathConversionHelper().absToRel(JcrRepositoryFileUtils.getAbsolutePath(session, this.getPentahoJcrConstants(), this.node));
                }
                catch (InvalidItemStateException | ItemNotFoundException | PathNotFoundException e) {
                    RepositoryFileProxy.getLogger().warn(Messages.getInstance().getString(INVALID_ITEM_STATE_EXCEPTION_MESSAGE, new Object[]{"getPath"}));
                }
                catch (RepositoryException e) {
                    RepositoryFileProxy.getLogger().error(Messages.getInstance().getString(REPOSITORY_EXCEPTION_WAS_FOUND_MESSAGE), (Throwable)e);
                }
            });
        }
        return this.path;
    }

    public String getTitle() {
        this.getTitleAndDescription();
        return this.title != null ? this.title : this.getName();
    }

    public Serializable getVersionId() {
        if (this.versionId == null && this.isVersioned()) {
            this.executeOperation(session -> {
                try {
                    this.versionId = JcrRepositoryFileUtils.getVersionId(session, this.getPentahoJcrConstants(), this.node);
                }
                catch (InvalidItemStateException | ItemNotFoundException | PathNotFoundException e) {
                    RepositoryFileProxy.getLogger().warn(Messages.getInstance().getString(INVALID_ITEM_STATE_EXCEPTION_MESSAGE, new Object[]{"getVersionId"}));
                }
                catch (RepositoryException e) {
                    RepositoryFileProxy.getLogger().error(Messages.getInstance().getString(REPOSITORY_EXCEPTION_WAS_FOUND_MESSAGE), (Throwable)e);
                }
            });
        }
        return this.versionId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getId() == null ? 0 : this.getId().hashCode());
        result = 31 * result + (this.getLocale() == null ? 0 : this.getLocale().hashCode());
        result = 31 * result + (this.getVersionId() == null ? 0 : this.getVersionId().hashCode());
        return result;
    }

    public boolean isFolder() {
        if (this.folder == null) {
            this.executeOperation(session -> {
                try {
                    this.folder = JcrRepositoryFileUtils.isPentahoFolder(this.getPentahoJcrConstants(), this.node);
                }
                catch (InvalidItemStateException | ItemNotFoundException | PathNotFoundException e) {
                    RepositoryFileProxy.getLogger().warn(Messages.getInstance().getString(INVALID_ITEM_STATE_EXCEPTION_MESSAGE, new Object[]{"isFolder"}));
                }
                catch (RepositoryException e) {
                    RepositoryFileProxy.getLogger().error(Messages.getInstance().getString(REPOSITORY_EXCEPTION_WAS_FOUND_MESSAGE), (Throwable)e);
                }
            });
        }
        return this.folder;
    }

    public Boolean isHidden() {
        if (this.hidden == null) {
            this.executeOperation(session -> {
                try {
                    if (this.node.hasProperty(this.getPentahoJcrConstants().getPHO_HIDDEN())) {
                        this.hidden = this.node.getProperty(this.getPentahoJcrConstants().getPHO_HIDDEN()).getBoolean();
                    }
                }
                catch (InvalidItemStateException | ItemNotFoundException | PathNotFoundException e) {
                    RepositoryFileProxy.getLogger().warn(Messages.getInstance().getString(INVALID_ITEM_STATE_EXCEPTION_MESSAGE, new Object[]{"isHidden"}));
                }
                catch (RepositoryException e) {
                    RepositoryFileProxy.getLogger().error(Messages.getInstance().getString(REPOSITORY_EXCEPTION_WAS_FOUND_MESSAGE), (Throwable)e);
                }
            });
        }
        return this.hidden == null ? false : this.hidden;
    }

    public Boolean isSchedulable() {
        if (this.schedulable == null) {
            this.executeOperation(session -> {
                try {
                    Map<String, Serializable> metadataIsSchedulable = this.getMetadata();
                    if (metadataIsSchedulable != null) {
                        this.schedulable = metadataIsSchedulable.get("_PERM_SCHEDULABLE") != null ? Boolean.valueOf(BooleanUtils.toBoolean((String)((String)((Object)metadataIsSchedulable.get("_PERM_SCHEDULABLE"))))) : null;
                    }
                }
                catch (Exception e) {
                    RepositoryFileProxy.getLogger().error(Messages.getInstance().getString(REPOSITORY_EXCEPTION_WAS_FOUND_MESSAGE), (Throwable)e);
                }
            });
        }
        return this.schedulable == null ? true : this.schedulable;
    }

    public boolean isLocked() {
        if (this.locked == null) {
            this.executeOperation(session -> {
                try {
                    this.locked = JcrRepositoryFileUtils.isLocked(this.getPentahoJcrConstants(), this.node);
                }
                catch (InvalidItemStateException | ItemNotFoundException | PathNotFoundException e) {
                    RepositoryFileProxy.getLogger().warn(Messages.getInstance().getString(INVALID_ITEM_STATE_EXCEPTION_MESSAGE, new Object[]{"isLocked"}));
                }
                catch (RepositoryException e) {
                    RepositoryFileProxy.getLogger().error(Messages.getInstance().getString(REPOSITORY_EXCEPTION_WAS_FOUND_MESSAGE), (Throwable)e);
                }
            });
        }
        return this.locked;
    }

    public boolean isVersioned() {
        if (this.versioned == null) {
            this.executeOperation(session -> {
                try {
                    this.versioned = JcrRepositoryFileUtils.isVersioned(session, this.getPentahoJcrConstants(), this.node);
                }
                catch (InvalidItemStateException | ItemNotFoundException | PathNotFoundException e) {
                    RepositoryFileProxy.getLogger().warn(Messages.getInstance().getString(INVALID_ITEM_STATE_EXCEPTION_MESSAGE, new Object[]{"isVersioned"}));
                }
                catch (RepositoryException e) {
                    RepositoryFileProxy.getLogger().error(Messages.getInstance().getString(REPOSITORY_EXCEPTION_WAS_FOUND_MESSAGE), (Throwable)e);
                }
            });
        }
        return this.versioned;
    }

    public boolean isAclNode() {
        if (this.aclNode == null) {
            this.executeOperation(session -> {
                try {
                    if (this.node.hasProperty(this.getPentahoJcrConstants().getPHO_ACLNODE())) {
                        this.aclNode = this.node.getProperty(this.getPentahoJcrConstants().getPHO_ACLNODE()).getBoolean();
                    }
                }
                catch (InvalidItemStateException | ItemNotFoundException | PathNotFoundException e) {
                    RepositoryFileProxy.getLogger().warn(Messages.getInstance().getString(INVALID_ITEM_STATE_EXCEPTION_MESSAGE, new Object[]{"isAclNode"}));
                }
                catch (RepositoryException e) {
                    RepositoryFileProxy.getLogger().error(Messages.getInstance().getString(REPOSITORY_EXCEPTION_WAS_FOUND_MESSAGE), (Throwable)e);
                }
            });
        }
        return this.aclNode != null && this.aclNode != false;
    }

    public String toString() {
        return super.toString();
    }

    private void executeOperation(SessionOperation op) {
        try {
            if (this.node.getSession().isLive()) {
                op.execute(this.node.getSession());
            } else {
                this.template.execute(session -> {
                    this.node = (Node)session.getItem(this.absPath);
                    op.execute(this.node.getSession());
                    return null;
                });
            }
        }
        catch (InvalidItemStateException | ItemNotFoundException | PathNotFoundException e) {
            RepositoryFileProxy.getLogger().warn(Messages.getInstance().getString(INVALID_ITEM_STATE_EXCEPTION_MESSAGE, new Object[]{"toString"}));
        }
        catch (RepositoryException e) {
            RepositoryFileProxy.getLogger().error(Messages.getInstance().getString(REPOSITORY_EXCEPTION_WAS_FOUND_MESSAGE), (Throwable)e);
        }
    }

    private static interface SessionOperation {
        public void execute(Session var1);
    }
}

