/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.jcr;

import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.mt.ITenant;
import org.pentaho.platform.api.mt.ITenantedPrincipleNameResolver;
import org.pentaho.platform.core.mt.Tenant;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.repository2.unified.ServerRepositoryPaths;

public class JcrTenantUtils {
    private static ITenantedPrincipleNameResolver userNameUtils;
    private static ITenantedPrincipleNameResolver roleNameUtils;
    private static String repositoryAdminUsername;

    public static ITenantedPrincipleNameResolver getUserNameUtils() {
        if (userNameUtils == null && PentahoSystem.getInitializedOK()) {
            userNameUtils = (ITenantedPrincipleNameResolver)PentahoSystem.get(ITenantedPrincipleNameResolver.class, (String)"tenantedUserNameUtils", (IPentahoSession)PentahoSessionHolder.getSession());
        }
        return userNameUtils;
    }

    public static ITenantedPrincipleNameResolver getRoleNameUtils() {
        if (roleNameUtils == null && PentahoSystem.getInitializedOK()) {
            roleNameUtils = (ITenantedPrincipleNameResolver)PentahoSystem.get(ITenantedPrincipleNameResolver.class, (String)"tenantedRoleNameUtils", (IPentahoSession)PentahoSessionHolder.getSession());
        }
        return roleNameUtils;
    }

    private static String getRepositoryAdminUserName() {
        if (repositoryAdminUsername == null && PentahoSystem.getInitializedOK()) {
            repositoryAdminUsername = (String)PentahoSystem.get(String.class, (String)"repositoryAdminUsername", (IPentahoSession)PentahoSessionHolder.getSession());
        }
        return repositoryAdminUsername;
    }

    public static String getTenantedRole(String principal) {
        if (principal != null && !principal.equals("administrators") && JcrTenantUtils.getRoleNameUtils() != null) {
            ITenant tenant = JcrTenantUtils.getRoleNameUtils().getTenant(principal);
            if (tenant == null || tenant.getId() == null) {
                IPentahoSession pentahoSession = PentahoSessionHolder.getSession();
                String tenantId = (String)pentahoSession.getAttribute("org.pentaho.tenantId");
                if (tenantId == null) {
                    tenantId = JcrTenantUtils.getDefaultTenantPath();
                }
                tenant = new Tenant(tenantId, Boolean.valueOf(true));
                return JcrTenantUtils.getRoleNameUtils().getPrincipleId(tenant, principal);
            }
            return principal;
        }
        return principal;
    }

    public static boolean isTenatedRole(String principal) {
        if (principal != null && !principal.equals("administrators") && JcrTenantUtils.getRoleNameUtils() != null) {
            return JcrTenantUtils.getRoleNameUtils().isValid(principal);
        }
        return false;
    }

    public static String getTenantedUser(String username) {
        if (username != null && !username.equals(JcrTenantUtils.getRepositoryAdminUserName()) && JcrTenantUtils.getUserNameUtils() != null) {
            ITenant tenant = JcrTenantUtils.getUserNameUtils().getTenant(username);
            if (tenant == null || tenant.getId() == null) {
                IPentahoSession pentahoSession = PentahoSessionHolder.getSession();
                String tenantId = (String)pentahoSession.getAttribute("org.pentaho.tenantId");
                if (tenantId == null) {
                    tenantId = JcrTenantUtils.getDefaultTenantPath();
                }
                tenant = new Tenant(tenantId, Boolean.valueOf(true));
                return JcrTenantUtils.getUserNameUtils().getPrincipleId(tenant, username);
            }
            return username;
        }
        return username;
    }

    public static boolean isTenantedUser(String username) {
        if (username != null && !username.equals(JcrTenantUtils.getRepositoryAdminUserName()) && JcrTenantUtils.getUserNameUtils() != null) {
            return JcrTenantUtils.getUserNameUtils().isValid(username);
        }
        return false;
    }

    public static ITenant getTenant(String principalId, boolean isUser) {
        ITenantedPrincipleNameResolver nameUtils;
        ITenant tenant = null;
        ITenantedPrincipleNameResolver iTenantedPrincipleNameResolver = nameUtils = isUser ? JcrTenantUtils.getUserNameUtils() : JcrTenantUtils.getRoleNameUtils();
        if (nameUtils != null) {
            tenant = nameUtils.getTenant(principalId);
        }
        if (tenant == null || tenant.getId() == null || !tenant.getId().startsWith("/")) {
            tenant = JcrTenantUtils.getCurrentTenant();
        }
        if (tenant == null || tenant.getId() == null) {
            tenant = JcrTenantUtils.getDefaultTenant();
        }
        return tenant;
    }

    public static ITenant getTenant() {
        ITenant tenant = JcrTenantUtils.getCurrentTenant();
        if (tenant == null || tenant.getId() == null) {
            tenant = JcrTenantUtils.getDefaultTenant();
        }
        return tenant;
    }

    public static String getPrincipalName(String principalId, boolean isUser) {
        ITenantedPrincipleNameResolver nameUtils;
        String principalName = null;
        ITenantedPrincipleNameResolver iTenantedPrincipleNameResolver = nameUtils = isUser ? JcrTenantUtils.getUserNameUtils() : JcrTenantUtils.getRoleNameUtils();
        if (nameUtils != null) {
            principalName = nameUtils.getPrincipleName(principalId);
        }
        return principalName;
    }

    public static ITenant getCurrentTenant() {
        if (PentahoSessionHolder.getSession() != null) {
            String tenantId = (String)PentahoSessionHolder.getSession().getAttribute("org.pentaho.tenantId");
            return tenantId != null ? new Tenant(tenantId, Boolean.valueOf(true)) : null;
        }
        return null;
    }

    public static String getDefaultTenantPath() {
        return ServerRepositoryPaths.getPentahoRootFolderPath() + "/" + "tenant0";
    }

    public static ITenant getDefaultTenant() {
        return new Tenant(JcrTenantUtils.getDefaultTenantPath(), Boolean.valueOf(true));
    }
}

