/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified;

import java.text.MessageFormat;
import org.pentaho.platform.api.mt.ITenant;
import org.pentaho.platform.repository2.ClientRepositoryPaths;
import org.pentaho.platform.repository2.unified.ServerRepositoryPaths;
import org.pentaho.platform.repository2.unified.jcr.JcrTenantUtils;

public class DefaultServerRepositoryPathsStrategy
implements ServerRepositoryPaths.IServerRepositoryPathsStrategy {
    private static final String FOLDER_ROOT = "pentaho";
    private static final String FOLDER_ETC = "etc";
    private static final String PATH_ROOT = "/pentaho";
    private final String PATTERN_TENANT_HOME_PATH = "{0}" + ClientRepositoryPaths.getHomeFolderPath();
    private final String PATTERN_TENANT_PUBLIC_PATH = "{0}" + ClientRepositoryPaths.getPublicFolderPath();
    private final String PATTERN_TENANT_ETC_PATH = "{0}/etc";

    @Override
    public String getPentahoRootFolderPath() {
        return PATH_ROOT;
    }

    @Override
    public String getTenantHomeFolderPath(ITenant tenant) {
        return MessageFormat.format(this.PATTERN_TENANT_HOME_PATH, tenant == null || tenant.getId() == null ? JcrTenantUtils.getDefaultTenant().getRootFolderAbsolutePath() : tenant.getRootFolderAbsolutePath());
    }

    @Override
    public String getTenantPublicFolderPath(ITenant tenant) {
        return MessageFormat.format(this.PATTERN_TENANT_PUBLIC_PATH, tenant == null || tenant.getId() == null ? JcrTenantUtils.getDefaultTenant().getRootFolderAbsolutePath() : tenant.getRootFolderAbsolutePath());
    }

    @Override
    public String getTenantRootFolderPath(ITenant tenant) {
        return tenant == null || tenant.getId() == null ? JcrTenantUtils.getDefaultTenant().getRootFolderAbsolutePath() : tenant.getRootFolderAbsolutePath();
    }

    @Override
    public String getUserHomeFolderPath(ITenant tenant, String username) {
        return this.getTenantRootFolderPath(tenant) + ClientRepositoryPaths.getUserHomeFolderPath(username);
    }

    @Override
    public String getPentahoRootFolderName() {
        return FOLDER_ROOT;
    }

    @Override
    public String getTenantHomeFolderName() {
        return ClientRepositoryPaths.getHomeFolderName();
    }

    @Override
    public String getTenantPublicFolderName() {
        return ClientRepositoryPaths.getPublicFolderName();
    }

    @Override
    public String getTenantEtcFolderName() {
        return FOLDER_ETC;
    }

    @Override
    public String getTenantEtcFolderPath(ITenant tenant) {
        return MessageFormat.format("{0}/etc", tenant == null || tenant.getId() == null ? JcrTenantUtils.getDefaultTenant().getRootFolderAbsolutePath() : tenant.getRootFolderAbsolutePath());
    }

    @Override
    public String getTenantId(String absPath) {
        return absPath;
    }
}

