/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.lang.reflect.Executable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.ons.ONS;
import oracle.ons.ONSException;
import oracle.ons.Subscriber;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.util.UCPErrorHandler;

@DefaultLogger(value="oracle.ucp.common")
@Supports(value={Feature.LOAD_BALANCING, Feature.HIGH_AVAILABILITY})
public class ONSDriver {
    private static final ONSDriver instance;
    private ONS onsObj = null;
    boolean calledStart = false;
    boolean isRemote = false;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;

    static ONSDriver instance() {
        return instance;
    }

    /*
     * WARNING - void declaration
     */
    boolean start(String string) throws UniversalConnectionPoolException {
        void config;
        boolean bl = (0xC0000000000000L & TraceControllerImpl.feature) != 0L;
        this.calledStart = false;
        this.isRemote = false;
        if (null == config || "".equals(config)) {
            this.isRemote = false;
            this.calledStart = true;
            if (bl) {
                ClioSupport.ilogFine($$$loggerRef$$$1, ONSDriver.class, $$$methodRef$$$1, this, "use local ONS subscription");
            }
            return true;
        }
        this.isRemote = true;
        if (bl) {
            ClioSupport.ilogFinest($$$loggerRef$$$1, ONSDriver.class, $$$methodRef$$$1, this, "about to start ONS with config: " + (String)config);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>((String)config){
                final /* synthetic */ String val$config;
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;
                private static Executable $$$methodRef$$$2;
                private static Logger $$$loggerRef$$$2;
                {
                    this.val$config = string;
                }

                @Override
                public Boolean run() throws UniversalConnectionPoolException {
                    boolean bl = (0L & TraceControllerImpl.feature) != 0L;
                    try {
                        ONSDriver.this.onsObj = new ONS(this.val$config.trim());
                        if (bl) {
                            ClioSupport.ilogFinest($$$loggerRef$$$0, 1.class, $$$methodRef$$$0, this, "ONS started with config: " + this.val$config);
                        }
                        Boolean bl2 = true;
                        return bl2;
                    }
                    catch (ONSException e) {
                        if (bl) {
                            ClioSupport.ilogWarning($$$loggerRef$$$0, 1.class, $$$methodRef$$$0, this, "failed to start ONS: " + e.getMessage());
                        }
                        if (bl) {
                            ClioSupport.ilogThrowing($$$loggerRef$$$0, 1.class, $$$methodRef$$$0, this, e);
                        }
                        throw UCPErrorHandler.newUniversalConnectionPoolException(308);
                    }
                    finally {
                        ONSDriver.this.calledStart = true;
                    }
                }

                static {
                    try {
                        $$$methodRef$$$2 = 1.class.getDeclaredConstructor(ONSDriver.class, String.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$1 = 1.class.getDeclaredMethod("run", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$0 = 1.class.getDeclaredMethod("run", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                }
            });
        }
        catch (PrivilegedActionException e) {
            this.calledStart = true;
            if (bl) {
                ClioSupport.ilogThrowing($$$loggerRef$$$1, ONSDriver.class, $$$methodRef$$$1, this, e);
            }
            throw UCPErrorHandler.newUniversalConnectionPoolException(308);
        }
    }

    private ONS getONS() throws UniversalConnectionPoolException {
        if (this.calledStart && this.isRemote && this.onsObj == null) {
            throw UCPErrorHandler.newUniversalConnectionPoolException(312);
        }
        return this.onsObj;
    }

    Subscriber createSubscriber(String subscribeConfig) throws UniversalConnectionPoolException {
        ONS onsObj = this.getONS();
        if (onsObj == null) {
            return new Subscriber(subscribeConfig, "", 30000L);
        }
        return onsObj.createNewSubscriber(subscribeConfig, "", 30000L);
    }

    static {
        try {
            $$$methodRef$$$5 = ONSDriver.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$4 = ONSDriver.class.getDeclaredMethod("access$002", ONSDriver.class, ONS.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$3 = ONSDriver.class.getDeclaredMethod("createSubscriber", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$2 = ONSDriver.class.getDeclaredMethod("getONS", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$1 = ONSDriver.class.getDeclaredMethod("start", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$0 = ONSDriver.class.getDeclaredMethod("instance", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        instance = new ONSDriver();
    }
}

