/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v23.group.SRM_S10_GENERAL_RESOURCE;
import ca.uhn.hl7v2.model.v23.group.SRM_S10_LOCATION_RESOURCE;
import ca.uhn.hl7v2.model.v23.group.SRM_S10_PERSONNEL_RESOURCE;
import ca.uhn.hl7v2.model.v23.group.SRM_S10_SERVICE;
import ca.uhn.hl7v2.model.v23.segment.RGS;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class SRM_S10_RESOURCES
extends AbstractGroup {
    public SRM_S10_RESOURCES(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(RGS.class, true, false);
            this.add(SRM_S10_SERVICE.class, false, true);
            this.add(SRM_S10_GENERAL_RESOURCE.class, false, true);
            this.add(SRM_S10_LOCATION_RESOURCE.class, false, true);
            this.add(SRM_S10_PERSONNEL_RESOURCE.class, false, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating SRM_S10_RESOURCES - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3";
    }

    public RGS getRGS() {
        RGS ret = null;
        try {
            ret = (RGS)this.get("RGS");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public SRM_S10_SERVICE getSERVICE() {
        SRM_S10_SERVICE ret = null;
        try {
            ret = (SRM_S10_SERVICE)this.get("SERVICE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public SRM_S10_SERVICE getSERVICE(int rep) {
        SRM_S10_SERVICE ret = null;
        try {
            ret = (SRM_S10_SERVICE)this.get("SERVICE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getSERVICEReps() {
        int reps = -1;
        try {
            reps = this.getAll("SERVICE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertSERVICE(SRM_S10_SERVICE structure, int rep) throws HL7Exception {
        super.insertRepetition("SERVICE", (Structure)structure, rep);
    }

    public SRM_S10_SERVICE insertSERVICE(int rep) throws HL7Exception {
        return (SRM_S10_SERVICE)super.insertRepetition("SERVICE", rep);
    }

    public SRM_S10_SERVICE removeSERVICE(int rep) throws HL7Exception {
        return (SRM_S10_SERVICE)super.removeRepetition("SERVICE", rep);
    }

    public SRM_S10_GENERAL_RESOURCE getGENERAL_RESOURCE() {
        SRM_S10_GENERAL_RESOURCE ret = null;
        try {
            ret = (SRM_S10_GENERAL_RESOURCE)this.get("GENERAL_RESOURCE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public SRM_S10_GENERAL_RESOURCE getGENERAL_RESOURCE(int rep) {
        SRM_S10_GENERAL_RESOURCE ret = null;
        try {
            ret = (SRM_S10_GENERAL_RESOURCE)this.get("GENERAL_RESOURCE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getGENERAL_RESOURCEReps() {
        int reps = -1;
        try {
            reps = this.getAll("GENERAL_RESOURCE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertGENERAL_RESOURCE(SRM_S10_GENERAL_RESOURCE structure, int rep) throws HL7Exception {
        super.insertRepetition("GENERAL_RESOURCE", (Structure)structure, rep);
    }

    public SRM_S10_GENERAL_RESOURCE insertGENERAL_RESOURCE(int rep) throws HL7Exception {
        return (SRM_S10_GENERAL_RESOURCE)super.insertRepetition("GENERAL_RESOURCE", rep);
    }

    public SRM_S10_GENERAL_RESOURCE removeGENERAL_RESOURCE(int rep) throws HL7Exception {
        return (SRM_S10_GENERAL_RESOURCE)super.removeRepetition("GENERAL_RESOURCE", rep);
    }

    public SRM_S10_LOCATION_RESOURCE getLOCATION_RESOURCE() {
        SRM_S10_LOCATION_RESOURCE ret = null;
        try {
            ret = (SRM_S10_LOCATION_RESOURCE)this.get("LOCATION_RESOURCE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public SRM_S10_LOCATION_RESOURCE getLOCATION_RESOURCE(int rep) {
        SRM_S10_LOCATION_RESOURCE ret = null;
        try {
            ret = (SRM_S10_LOCATION_RESOURCE)this.get("LOCATION_RESOURCE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getLOCATION_RESOURCEReps() {
        int reps = -1;
        try {
            reps = this.getAll("LOCATION_RESOURCE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertLOCATION_RESOURCE(SRM_S10_LOCATION_RESOURCE structure, int rep) throws HL7Exception {
        super.insertRepetition("LOCATION_RESOURCE", (Structure)structure, rep);
    }

    public SRM_S10_LOCATION_RESOURCE insertLOCATION_RESOURCE(int rep) throws HL7Exception {
        return (SRM_S10_LOCATION_RESOURCE)super.insertRepetition("LOCATION_RESOURCE", rep);
    }

    public SRM_S10_LOCATION_RESOURCE removeLOCATION_RESOURCE(int rep) throws HL7Exception {
        return (SRM_S10_LOCATION_RESOURCE)super.removeRepetition("LOCATION_RESOURCE", rep);
    }

    public SRM_S10_PERSONNEL_RESOURCE getPERSONNEL_RESOURCE() {
        SRM_S10_PERSONNEL_RESOURCE ret = null;
        try {
            ret = (SRM_S10_PERSONNEL_RESOURCE)this.get("PERSONNEL_RESOURCE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public SRM_S10_PERSONNEL_RESOURCE getPERSONNEL_RESOURCE(int rep) {
        SRM_S10_PERSONNEL_RESOURCE ret = null;
        try {
            ret = (SRM_S10_PERSONNEL_RESOURCE)this.get("PERSONNEL_RESOURCE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getPERSONNEL_RESOURCEReps() {
        int reps = -1;
        try {
            reps = this.getAll("PERSONNEL_RESOURCE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertPERSONNEL_RESOURCE(SRM_S10_PERSONNEL_RESOURCE structure, int rep) throws HL7Exception {
        super.insertRepetition("PERSONNEL_RESOURCE", (Structure)structure, rep);
    }

    public SRM_S10_PERSONNEL_RESOURCE insertPERSONNEL_RESOURCE(int rep) throws HL7Exception {
        return (SRM_S10_PERSONNEL_RESOURCE)super.insertRepetition("PERSONNEL_RESOURCE", rep);
    }

    public SRM_S10_PERSONNEL_RESOURCE removePERSONNEL_RESOURCE(int rep) throws HL7Exception {
        return (SRM_S10_PERSONNEL_RESOURCE)super.removeRepetition("PERSONNEL_RESOURCE", rep);
    }
}

