/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.repository.zipreader;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.DefaultMimeRegistry;
import org.pentaho.reporting.libraries.repository.MimeRegistry;
import org.pentaho.reporting.libraries.repository.Repository;
import org.pentaho.reporting.libraries.repository.RepositoryUtilities;
import org.pentaho.reporting.libraries.repository.zipreader.ZipReadContentLocation;

public class ZipReadRepository
implements Repository {
    private ZipReadContentLocation root;
    private MimeRegistry mimeRegistry;

    public ZipReadRepository(InputStream in) throws IOException {
        this(in, new DefaultMimeRegistry());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZipReadRepository(InputStream in, MimeRegistry mimeRegistry) throws IOException {
        this.mimeRegistry = mimeRegistry;
        this.root = new ZipReadContentLocation(this, null, "");
        try (ZipInputStream zipIn = new ZipInputStream(in);){
            ZipEntry nextEntry = zipIn.getNextEntry();
            if (nextEntry == null) {
                throw new IOException("This repository is empty or does not point to a ZIP file");
            }
            while (nextEntry != null) {
                String[] buildName = RepositoryUtilities.splitPath(nextEntry.getName(), "/");
                if (nextEntry.isDirectory()) {
                    this.root.updateDirectoryEntry(buildName, 0, nextEntry);
                } else {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    Deflater def = new Deflater(nextEntry.getMethod());
                    try (DeflaterOutputStream dos = new DeflaterOutputStream((OutputStream)bos, def);){
                        IOUtils.getInstance().copyStreams((InputStream)zipIn, (OutputStream)dos);
                        dos.flush();
                    }
                    finally {
                        def.end();
                    }
                    this.root.updateEntry(buildName, 0, nextEntry, bos.toByteArray());
                }
                zipIn.closeEntry();
                nextEntry = zipIn.getNextEntry();
            }
        }
    }

    @Override
    public ContentLocation getRoot() throws ContentIOException {
        return this.root;
    }

    @Override
    public MimeRegistry getMimeRegistry() {
        return this.mimeRegistry;
    }
}

