/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.repository.stream;

import org.pentaho.reporting.libraries.repository.ContentCreationException;
import org.pentaho.reporting.libraries.repository.ContentEntity;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentItem;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.Repository;
import org.pentaho.reporting.libraries.repository.stream.StreamContentItem;
import org.pentaho.reporting.libraries.repository.stream.StreamRepository;
import org.pentaho.reporting.libraries.repository.stream.WrappedInputStream;
import org.pentaho.reporting.libraries.repository.stream.WrappedOutputStream;

public class StreamContentLocation
implements ContentLocation {
    private ContentItem contentItem;
    private StreamRepository repository;
    private static final ContentEntity[] EMPTY_CONTENT_ENTITY = new ContentEntity[0];

    public StreamContentLocation(StreamRepository repository) {
        if (repository == null) {
            throw new NullPointerException();
        }
        this.repository = repository;
    }

    @Override
    public ContentEntity[] listContents() throws ContentIOException {
        WrappedInputStream in = this.repository.getInputStream();
        if (in != null && this.contentItem == null) {
            this.contentItem = new StreamContentItem(this.repository.getContentName(), this, in, this.repository.getOutputStream());
        }
        if (this.contentItem == null) {
            return EMPTY_CONTENT_ENTITY;
        }
        return new ContentEntity[]{this.contentItem};
    }

    @Override
    public ContentEntity getEntry(String name) throws ContentIOException {
        WrappedInputStream in = this.repository.getInputStream();
        if (in != null && this.contentItem == null) {
            this.contentItem = new StreamContentItem(this.repository.getContentName(), this, in, this.repository.getOutputStream());
        }
        if (this.contentItem == null) {
            throw new ContentIOException("No such item");
        }
        if (this.contentItem.getName().equals(name)) {
            return this.contentItem;
        }
        throw new ContentIOException("No such item");
    }

    @Override
    public ContentItem createItem(String name) throws ContentCreationException {
        WrappedInputStream in = this.repository.getInputStream();
        WrappedOutputStream outputStream = this.repository.getOutputStream();
        if (in != null && this.contentItem == null) {
            this.contentItem = new StreamContentItem(this.repository.getContentName(), this, in, outputStream);
        }
        if (this.contentItem == null && outputStream != null) {
            this.contentItem = new StreamContentItem(name, this, in, outputStream);
            return this.contentItem;
        }
        throw new ContentCreationException("Failed to create the item. Item already exists or the repository is read-only");
    }

    @Override
    public ContentLocation createLocation(String name) throws ContentCreationException {
        throw new ContentCreationException("A stream repository never creates sub-locations");
    }

    @Override
    public boolean exists(String name) {
        if (this.contentItem != null) {
            return this.contentItem.getName().equals(name);
        }
        WrappedInputStream in = this.repository.getInputStream();
        if (in != null) {
            return this.repository.getContentName().equals(name);
        }
        return false;
    }

    @Override
    public String getName() {
        return "root";
    }

    @Override
    public Object getContentId() {
        return this.getName();
    }

    @Override
    public Object getAttribute(String domain, String key) {
        return null;
    }

    @Override
    public boolean setAttribute(String domain, String key, Object value) {
        return false;
    }

    @Override
    public ContentLocation getParent() {
        return null;
    }

    @Override
    public Repository getRepository() {
        return this.repository;
    }

    @Override
    public boolean delete() {
        return false;
    }
}

