/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.repository;

import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.MimeRegistry;
import org.pentaho.reporting.libraries.repository.NameGenerator;
import org.pentaho.reporting.libraries.repository.Repository;

public class PageSequenceNameGenerator
implements NameGenerator {
    private ContentLocation location;
    private String defaultNameHint;
    private String defaultSuffix;
    private int counter;

    public PageSequenceNameGenerator(ContentLocation location) {
        this(location, "file", null);
    }

    public PageSequenceNameGenerator(ContentLocation location, String defaultNameHint) {
        if (location == null) {
            throw new NullPointerException();
        }
        if (defaultNameHint == null) {
            throw new NullPointerException();
        }
        this.location = location;
        int pos = defaultNameHint.lastIndexOf(46);
        if (this.defaultSuffix == null && pos > 0) {
            if (pos < defaultNameHint.length() - 1) {
                this.defaultNameHint = defaultNameHint.substring(0, pos);
                this.defaultSuffix = defaultNameHint.substring(pos + 1);
            } else {
                this.defaultNameHint = defaultNameHint.substring(0, pos);
                this.defaultSuffix = null;
            }
        } else {
            this.defaultNameHint = defaultNameHint;
            this.defaultSuffix = null;
        }
    }

    public PageSequenceNameGenerator(ContentLocation location, String defaultNameHint, String defaultSuffix) {
        if (location == null) {
            throw new NullPointerException();
        }
        if (defaultNameHint == null) {
            throw new NullPointerException();
        }
        this.location = location;
        this.defaultNameHint = defaultNameHint;
        this.defaultSuffix = defaultSuffix;
    }

    @Override
    public String generateName(String nameHint, String mimeType) throws ContentIOException {
        String name = nameHint != null ? nameHint : this.defaultNameHint;
        String suffix = this.defaultSuffix != null ? this.defaultSuffix : this.getSuffixForType(mimeType, this.location);
        String filename = name + '-' + this.counter + '.' + suffix;
        if (!this.location.exists(filename)) {
            ++this.counter;
            return filename;
        }
        throw new ContentIOException("Unable to generate page-sequence: A file with the next expected name already exists.");
    }

    private String getSuffixForType(String mimeType, ContentLocation location) {
        Repository repository = location.getRepository();
        MimeRegistry mimeRegistry = repository.getMimeRegistry();
        return mimeRegistry.getSuffix(mimeType);
    }
}

