/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.pipes.transform;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.VertexQuery;
import com.tinkerpop.pipes.transform.QueryPipe;
import com.tinkerpop.pipes.util.FastNoSuchElementException;
import com.tinkerpop.pipes.util.PipeHelper;
import java.util.Arrays;
import java.util.List;

public class VertexQueryPipe<E extends Element>
extends QueryPipe<Vertex, E> {
    private Direction direction = Direction.BOTH;
    private String[] labels;
    private int branchFactor;

    public VertexQueryPipe(Class<E> resultingElementClass, Direction direction, List<QueryPipe.HasContainer> hasContainers, List<QueryPipe.IntervalContainer> intervalContainers, int branchFactor, int lowRange, int highRange, String ... labels) {
        this.setResultingElementClass(resultingElementClass);
        this.direction = direction;
        if (null != hasContainers) {
            for (QueryPipe.HasContainer hasContainer : hasContainers) {
                super.addHasContainer(hasContainer);
            }
        }
        if (null != intervalContainers) {
            for (QueryPipe.IntervalContainer intervalContainer : intervalContainers) {
                super.addIntervalContainer(intervalContainer);
            }
        }
        this.branchFactor = branchFactor;
        super.setLowRange(lowRange);
        super.setHighRange(highRange);
        this.labels = labels;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public void setLabels(String ... labels) {
        this.labels = labels;
    }

    public void setBranchFactor(int branchFactor) {
        this.branchFactor = branchFactor;
    }

    @Override
    public String toString() {
        return this.branchFactor == Integer.MAX_VALUE ? PipeHelper.makePipeString(this, this.direction.name().toLowerCase(), Arrays.asList(this.labels), super.toString()) : PipeHelper.makePipeString(this, this.direction.name().toLowerCase(), "branch:" + this.branchFactor, Arrays.asList(this.labels), super.toString());
    }

    @Override
    public E processNextStart() {
        while (true) {
            if (this.count >= this.highRange) {
                throw FastNoSuchElementException.instance();
            }
            if (this.currentIterator.hasNext()) {
                ++this.count;
                Element e = (Element)this.currentIterator.next();
                if (this.count <= this.lowRange) continue;
                return (E)e;
            }
            Vertex vertex = (Vertex)this.starts.next();
            VertexQuery query = vertex.query();
            query = query.direction(this.direction);
            if (this.labels.length > 0) {
                query = query.labels(this.labels);
            }
            if (null != this.hasContainers) {
                for (QueryPipe.HasContainer hasContainer : this.hasContainers) {
                    query = query.has(hasContainer.key, hasContainer.predicate, hasContainer.value);
                }
            }
            if (null != this.intervalContainers) {
                for (QueryPipe.IntervalContainer intervalContainer : this.intervalContainers) {
                    query = query.interval(intervalContainer.key, intervalContainer.startValue, intervalContainer.endValue);
                }
            }
            if (this.branchFactor == Integer.MAX_VALUE) {
                if (this.highRange != Integer.MAX_VALUE) {
                    int temp = this.highRange - this.count;
                    query = temp > 0 ? query.limit(temp) : query;
                }
            } else {
                int temp;
                query = this.highRange == Integer.MAX_VALUE ? query.limit(this.branchFactor) : query.limit((temp = this.highRange - this.count) < this.branchFactor ? temp : this.branchFactor);
            }
            this.currentIterator = this.elementClass.equals(Vertex.class) ? query.vertices().iterator() : query.edges().iterator();
        }
    }
}

