/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.designtime.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;
import org.pentaho.reporting.libraries.designtime.swing.MacOSXIntegration;
import org.pentaho.reporting.libraries.designtime.swing.Messages;
import org.pentaho.reporting.libraries.designtime.swing.settings.DialogSizeSettings;

public abstract class CommonDialog
extends JDialog {
    private boolean confirmed;
    private Action confirmAction;
    private CancelAction cancelAction;
    private JComponent buttonPanel;
    private boolean buttonPaneVisible;
    private DialogSizeSettings dialogSizeSettings;

    protected CommonDialog() {
        this.setModal(true);
    }

    protected CommonDialog(Frame owner) throws HeadlessException {
        super(owner, true);
    }

    protected CommonDialog(Dialog owner) throws HeadlessException {
        super(owner, true);
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    public void setConfirmed(boolean confirmed) {
        this.confirmed = confirmed;
    }

    protected void init() {
        this.dialogSizeSettings = new DialogSizeSettings();
        this.buttonPaneVisible = true;
        this.confirmAction = new OKAction();
        this.cancelAction = new CancelAction();
        this.setDefaultCloseOperation(2);
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        this.buttonPanel = this.createButtonsPane();
        contentPane.add(this.createContentPane(), "Center");
        contentPane.add((Component)this.buttonPanel, "South");
        this.setContentPane(contentPane);
        InputMap inputMap = contentPane.getInputMap(2);
        ActionMap actionMap = contentPane.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "confirm");
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "cancel");
        actionMap.put("confirm", this.getConfirmAction());
        actionMap.put("cancel", this.getCancelAction());
        this.resizeDialog();
    }

    protected abstract String getDialogId();

    protected void resizeDialog() {
        Rectangle rectangle = this.dialogSizeSettings.get(this.getDialogId());
        if (rectangle != null && LibSwingUtil.safeRestoreWindow(this, rectangle) && this.getWidth() > 50 && this.getHeight() > 50) {
            return;
        }
        this.performInitialResize();
    }

    protected void performInitialResize() {
        this.pack();
        LibSwingUtil.centerDialogInParent(this);
    }

    protected Action getCancelAction() {
        return this.cancelAction;
    }

    protected abstract Component createContentPane();

    protected boolean performEdit() {
        this.confirmed = false;
        this.setModal(true);
        this.setVisible(true);
        return this.confirmed;
    }

    public boolean isButtonPaneVisible() {
        return this.buttonPaneVisible;
    }

    public void setButtonPaneVisible(boolean buttonPaneVisible) {
        this.buttonPaneVisible = buttonPaneVisible;
        if (buttonPaneVisible) {
            this.getContentPane().add((Component)this.buttonPanel, "South");
        } else {
            this.getContentPane().remove(this.buttonPanel);
        }
    }

    protected boolean hasCancelButton() {
        return true;
    }

    protected Action[] getExtraActions() {
        return new Action[0];
    }

    protected JPanel createButtonsPane() {
        JButton button = new JButton(this.getConfirmAction());
        button.setDefaultCapable(true);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new FlowLayout(2, 5, 5));
        if (!MacOSXIntegration.MAC_OS_X) {
            buttonsPanel.add(button);
        }
        if (this.hasCancelButton()) {
            buttonsPanel.add(new JButton(this.getCancelAction()));
        }
        if (MacOSXIntegration.MAC_OS_X) {
            buttonsPanel.add(button);
        }
        JPanel extraPanel = new JPanel();
        extraPanel.setLayout(new FlowLayout(0, 5, 5));
        Action[] extraActions = this.getExtraActions();
        for (int i = 0; i < extraActions.length; ++i) {
            Action action = extraActions[i];
            extraPanel.add(new JButton(action));
        }
        JPanel buttonsCarrierPanel = new JPanel();
        buttonsCarrierPanel.setLayout(new BorderLayout(5, 5));
        buttonsCarrierPanel.add((Component)buttonsPanel, "East");
        buttonsCarrierPanel.add((Component)extraPanel, "West");
        return buttonsCarrierPanel;
    }

    protected Action getConfirmAction() {
        return this.confirmAction;
    }

    @Override
    public void hide() {
        this.dialogSizeSettings.put(this.getDialogId(), this.getBounds());
        super.hide();
    }

    @Override
    public void setVisible(boolean b) {
        if (!b) {
            this.dialogSizeSettings.put(this.getDialogId(), this.getBounds());
        }
        super.setVisible(b);
    }

    protected boolean validateInputs(boolean onConfirm) {
        return true;
    }

    private class CancelAction
    extends AbstractAction {
        private CancelAction() {
            this.putValue("Name", Messages.getInstance().getString("CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CommonDialog.this.dispose();
        }
    }

    private class OKAction
    extends AbstractAction {
        private OKAction() {
            this.putValue("Name", Messages.getInstance().getString("OK"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (CommonDialog.this.validateInputs(true)) {
                CommonDialog.this.setConfirmed(true);
                CommonDialog.this.dispose();
            }
        }
    }
}

