/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.xmljoin;

import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLParserFactoryProducer;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.xmljoin.XMLJoinData;
import org.pentaho.di.trans.steps.xmljoin.XMLJoinMeta;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XMLJoin
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = XMLJoinMeta.class;
    private XMLJoinMeta meta;
    private XMLJoinData data;
    private Transformer transformer;

    public XMLJoin(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        String[] source_field_names;
        Object[] rJoinSource;
        this.meta = (XMLJoinMeta)smi;
        this.data = (XMLJoinData)sdi;
        XPath xpath = XPathFactory.newInstance().newXPath();
        if (this.first) {
            this.first = false;
            int target_field_id = -1;
            XMLJoinMeta meta = (XMLJoinMeta)smi;
            this.data.TargetRowSet = this.findInputRowSet(meta.getTargetXMLstep());
            this.data.SourceRowSet = this.findInputRowSet(meta.getSourceXMLstep());
            Object[] rTarget = this.getRowFrom(this.data.TargetRowSet);
            if (rTarget == null) {
                this.logBasic(BaseMessages.getString(PKG, (String)"XMLJoin.NoRowsFoundInTarget", (String[])new String[0]));
                this.setOutputDone();
                return false;
            }
            String[] target_field_names = this.data.TargetRowSet.getRowMeta().getFieldNames();
            for (int i = 0; i < target_field_names.length; ++i) {
                if (!meta.getTargetXMLfield().equals(target_field_names[i])) continue;
                target_field_id = i;
            }
            if (target_field_id == -1) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"XMLJoin.Exception.FieldNotFound", (String[])new String[]{meta.getTargetXMLfield()}));
            }
            this.data.outputRowMeta = this.data.TargetRowSet.getRowMeta().clone();
            meta.getFields(this.data.outputRowMeta, this.getStepname(), new RowMetaInterface[]{this.data.TargetRowSet.getRowMeta()}, null, (VariableSpace)this.getTransMeta(), this.repository, this.metaStore);
            this.data.outputRowData = (Object[])rTarget.clone();
            String strTarget = (String)rTarget[target_field_id];
            InputSource inputSource = new InputSource(new StringReader(strTarget));
            this.data.XPathStatement = meta.getTargetXPath();
            try {
                DocumentBuilder builder = XMLParserFactoryProducer.createSecureDocBuilderFactory().newDocumentBuilder();
                this.data.targetDOM = builder.parse(inputSource);
                if (!meta.isComplexJoin()) {
                    this.data.targetNode = (Node)xpath.evaluate(this.data.XPathStatement, this.data.targetDOM, XPathConstants.NODE);
                    if (this.data.targetNode == null) {
                        throw new KettleXMLException("XPath statement returned no result [" + this.data.XPathStatement + "]");
                    }
                }
            }
            catch (Exception e) {
                throw new KettleXMLException((Throwable)e);
            }
        }
        if ((rJoinSource = this.getRowFrom(this.data.SourceRowSet)) == null) {
            try {
                if (this.meta.isOmitNullValues()) {
                    this.removeEmptyNodes(this.data.targetDOM.getChildNodes());
                }
                StringWriter sw = new StringWriter();
                StreamResult resultXML = new StreamResult(sw);
                DOMSource source = new DOMSource(this.data.targetDOM);
                this.getTransformer().transform(source, resultXML);
                int outputIndex = this.data.outputRowMeta.size() - 1;
                this.putRow(this.data.outputRowMeta, RowDataUtil.addValueData((Object[])this.data.outputRowData, (int)outputIndex, (Object)sw.toString()));
                this.setOutputDone();
                return false;
            }
            catch (Exception e) {
                throw new KettleException((Throwable)e);
            }
        }
        if (this.data.iSourceXMLField == -1) {
            source_field_names = this.data.SourceRowSet.getRowMeta().getFieldNames();
            for (int i = 0; i < source_field_names.length; ++i) {
                if (!this.meta.getSourceXMLfield().equals(source_field_names[i])) continue;
                this.data.iSourceXMLField = i;
            }
            if (this.data.iSourceXMLField == -1) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"XMLJoin.Exception.FieldNotFound", (String[])new String[]{this.meta.getSourceXMLfield()}));
            }
        }
        if (this.meta.isComplexJoin() && this.data.iCompareFieldID == -1) {
            source_field_names = this.data.SourceRowSet.getRowMeta().getFieldNames();
            for (int i = 0; i < source_field_names.length; ++i) {
                if (!this.meta.getJoinCompareField().equals(source_field_names[i])) continue;
                this.data.iCompareFieldID = i;
            }
            if (this.data.iCompareFieldID == -1) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"XMLJoin.Exception.FieldNotFound", (String[])new String[]{this.meta.getJoinCompareField()}));
            }
        }
        String strJoinXML = (String)rJoinSource[this.data.iSourceXMLField];
        try {
            DocumentBuilder builder = XMLParserFactoryProducer.createSecureDocBuilderFactory().newDocumentBuilder();
            Document joinDocument = builder.parse(new InputSource(new StringReader(strJoinXML)));
            Node node = this.data.targetDOM.importNode(joinDocument.getDocumentElement(), true);
            if (this.meta.isComplexJoin()) {
                String strCompareValue = rJoinSource[this.data.iCompareFieldID].toString();
                String strXPathStatement = this.data.XPathStatement.replace("?", strCompareValue);
                this.data.targetNode = (Node)xpath.evaluate(strXPathStatement, this.data.targetDOM, XPathConstants.NODE);
                if (this.data.targetNode == null) {
                    throw new KettleXMLException("XPath statement returned no result [" + strXPathStatement + "]");
                }
            }
            this.data.targetNode.appendChild(node);
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
        return true;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (XMLJoinMeta)smi;
        this.data = (XMLJoinData)sdi;
        if (!super.init(smi, sdi)) {
            return false;
        }
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            if (this.meta.getEncoding() != null) {
                transformer.setOutputProperty("encoding", this.meta.getEncoding());
            }
            if (this.meta.isOmitXMLHeader()) {
                transformer.setOutputProperty("omit-xml-declaration", "yes");
            }
            transformer.setOutputProperty("indent", "no");
            this.setTransformer(transformer);
            this.swapFirstInputRowSetIfExists(this.meta.getTargetXMLstep());
        }
        catch (Exception e) {
            this.log.logError(BaseMessages.getString(PKG, (String)"XMLJoin.Error.Init", (String[])new String[0]), (Throwable)e);
            return false;
        }
        return true;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (XMLJoinMeta)smi;
        this.data = (XMLJoinData)sdi;
        super.dispose(smi, sdi);
    }

    private void setTransformer(Transformer transformer) {
        this.transformer = transformer;
    }

    private Transformer getTransformer() {
        return this.transformer;
    }

    private void removeEmptyNodes(NodeList nodes) {
        for (int i = 0; i < nodes.getLength(); ++i) {
            boolean nodeIsEmpty;
            Node node = nodes.item(i);
            if (node.hasChildNodes()) {
                this.removeEmptyNodes(node.getChildNodes());
            }
            boolean bl = nodeIsEmpty = node.getNodeType() == 1 && !node.hasAttributes() && !node.hasChildNodes() && node.getTextContent().length() == 0;
            if (!nodeIsEmpty) continue;
            node.getParentNode().removeChild(node);
            --i;
        }
    }
}

