/*
 * Decompiled with CFR 0.152.
 */
package com.totvscrm.pentaho.step.databaseJoindynamic;

import com.totvscrm.pentaho.step.databaseJoindynamic.DatabaseJoinDynamic;
import com.totvscrm.pentaho.step.databaseJoindynamic.DatabaseJoinDynamicData;
import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.DatabaseImpact;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@Step(id="DatabaseJoinDynamic.Meta.id", name="DatabaseJoinDynamic.Meta.name", description="DatabaseJoinDynamic.Meta.description", categoryDescription="DatabaseJoinDynamic.Meta.categoryDescription", i18nPackageName="com.totvscrm.pentaho.step.databaseJoindynamic", image="ws_join_dynamic.png", documentationUrl="https://wsintegracoes.webnode.com/databasejoindynamic/", casesUrl="https://wsintegracoes.webnode.com/databasejoindynamic/", forumUrl="https://wsintegracoes.webnode.com/databasejoindynamic/")
public class DatabaseJoinDynamicMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = DatabaseJoinDynamicMeta.class;
    private DatabaseMeta databaseMeta;
    private String sql;
    private String templateSQL;
    private String sqlFieldIn;
    private String query;
    private int rowLimit;
    private String fieldIn;
    private String fieldInLimit;
    private boolean FieldInLimitEnabled;

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta database) {
        this.databaseMeta = database;
    }

    public int getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(int rowLimit) {
        this.rowLimit = rowLimit;
    }

    public String getfieldIn() {
        return this.fieldIn;
    }

    public void setfieldIn(String fieldIn) {
        this.fieldIn = fieldIn;
    }

    public String getFieldInLimit() {
        return this.fieldInLimit;
    }

    public void setFieldInLimit(String fieldInLimit) {
        this.fieldInLimit = fieldInLimit;
    }

    public boolean isFieldInLimitEnabled() {
        return this.FieldInLimitEnabled;
    }

    public void setFieldInLimitEnabled(boolean fieldInLimitEnabled) {
        this.FieldInLimitEnabled = fieldInLimitEnabled;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public String getTemplateSQL() {
        return this.templateSQL;
    }

    public void setTemplateSQL(String templateSQL) {
        this.templateSQL = templateSQL;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getSqlFieldIn() {
        return this.sqlFieldIn;
    }

    public void setSqlFieldIn(String sqlFieldIn) {
        this.sqlFieldIn = sqlFieldIn;
    }

    public Object clone() {
        DatabaseJoinDynamicMeta retval = (DatabaseJoinDynamicMeta)((Object)super.clone());
        return retval;
    }

    public void setDefault() {
        this.databaseMeta = null;
        this.rowLimit = 0;
        this.sql = "SELECT <values> FROM <table name> WHERE ? ORDER BY <order field>";
        this.templateSQL = "SELECT <values> FROM <table name>";
        this.fieldIn = null;
        this.sqlFieldIn = null;
        this.query = null;
        this.fieldInLimit = "0";
        this.FieldInLimitEnabled = false;
    }

    public void getFields(RowMetaInterface row, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        if (this.databaseMeta == null) {
            return;
        }
        row.clear();
        Database db = new Database(loggingObject, this.databaseMeta);
        this.databases = new Database[]{db};
        RowMetaInterface add = null;
        String realSQL = space.environmentSubstitute(this.templateSQL);
        try {
            add = db.getQueryFields(realSQL, false);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleStepException(BaseMessages.getString(PKG, (String)"DatabaseJoinDynamic.Meta.Exception.UnableToDetermineQueryFields", (String[])new String[0]) + Const.CR + realSQL, (Throwable)dbe);
        }
        if (add != null) {
            for (int i = 0; i < add.size(); ++i) {
                ValueMetaInterface v = add.getValueMeta(i);
                v.setOrigin(name);
            }
            row.addRowMeta(add);
        } else {
            try {
                db.connect();
                add = db.getQueryFields(realSQL, false);
                for (int i = 0; i < add.size(); ++i) {
                    ValueMetaInterface v = add.getValueMeta(i);
                    v.setOrigin(name);
                }
                row.addRowMeta(add);
                db.disconnect();
            }
            catch (KettleDatabaseException dbe) {
                throw new KettleStepException(BaseMessages.getString(PKG, (String)"DatabaseJoinDynamic.Meta.Exception.ErrorObtainingFields", (String[])new String[0]), (Throwable)dbe);
            }
        }
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    private void readData(Node stepnode, List<DatabaseMeta> databases) throws KettleXMLException {
        try {
            String con = XMLHandler.getTagValue((Node)stepnode, (String)"connection");
            this.databaseMeta = DatabaseMeta.findDatabase(databases, (String)con);
            this.sql = XMLHandler.getTagValue((Node)stepnode, (String)"sql");
            this.templateSQL = XMLHandler.getTagValue((Node)stepnode, (String)"templateSQL");
            this.rowLimit = Const.toInt((String)XMLHandler.getTagValue((Node)stepnode, (String)"rowlimit"), (int)0);
            this.fieldIn = XMLHandler.getTagValue((Node)stepnode, (String)"fieldIn");
            this.fieldInLimit = XMLHandler.getTagValue((Node)stepnode, (String)"fieldin_limit");
            this.FieldInLimitEnabled = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"fieldin_limit_enabled"));
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"DatabaseJoinDynamic.Meta.Exception.UnableToLoadStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    public String getXML() {
        StringBuilder retval = new StringBuilder(300);
        retval.append("    ").append(XMLHandler.addTagValue((String)"connection", (String)(this.databaseMeta == null ? "" : this.databaseMeta.getName())));
        retval.append("    ").append(XMLHandler.addTagValue((String)"rowlimit", (int)this.rowLimit));
        retval.append("    ").append(XMLHandler.addTagValue((String)"sql", (String)this.sql));
        retval.append("    ").append(XMLHandler.addTagValue((String)"templateSQL", (String)this.templateSQL));
        retval.append("    ").append(XMLHandler.addTagValue((String)"fieldin", (String)this.fieldIn));
        retval.append("    ").append(XMLHandler.addTagValue((String)"fieldin_limit", (String)this.fieldInLimit));
        retval.append("    ").append(XMLHandler.addTagValue((String)"fieldin_limit_enabled", (boolean)this.FieldInLimitEnabled));
        return retval.toString();
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.databaseMeta = rep.loadDatabaseMetaFromStepAttribute(id_step, "id_connection", databases);
            this.rowLimit = (int)rep.getStepAttributeInteger(id_step, "rowlimit");
            this.sql = rep.getStepAttributeString(id_step, "sql");
            this.templateSQL = rep.getStepAttributeString(id_step, "templateSQL");
            this.fieldIn = rep.getStepAttributeString(id_step, "fieldIn");
            this.fieldInLimit = rep.getStepAttributeString(id_step, "fieldin_limit");
            this.FieldInLimitEnabled = rep.getStepAttributeBoolean(id_step, "fieldin_limit_enabled");
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"DatabaseJoinDynamic.Meta.Exception.UnexpectedErrorReadingStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveDatabaseMetaStepAttribute(id_transformation, id_step, "id_connection", this.databaseMeta);
            rep.saveStepAttribute(id_transformation, id_step, "rowlimit", (long)this.rowLimit);
            rep.saveStepAttribute(id_transformation, id_step, "sql", this.sql);
            rep.saveStepAttribute(id_transformation, id_step, "templateSQL", this.templateSQL);
            rep.saveStepAttribute(id_transformation, id_step, "fieldIn", this.fieldIn);
            rep.saveStepAttribute(id_transformation, id_step, "fieldin_limit", this.fieldInLimit);
            if (this.databaseMeta != null) {
                rep.insertStepDatabase(id_transformation, id_step, this.databaseMeta.getObjectId());
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"DatabaseJoinDynamic.Meta.Exception.UnableToSaveStepInfo", (String[])new String[0]) + String.valueOf(id_step), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        Object error_message = "";
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"DatabaseJoinDynamic.Meta.CheckResult.ReceivingInfo", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"DatabaseJoinDynamic.Meta.CheckResult.NoInputReceived", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (this.fieldIn == null || this.fieldIn.length() == 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"DatabaseJoinDynamic.Meta.CheckResult.FieldInMissing", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            ValueMetaInterface vfield = prev.searchValueMeta(this.fieldIn);
            cr = vfield == null ? new CheckResult(4, BaseMessages.getString(PKG, (String)"DatabaseJoinDynamic.Meta.CheckResult.FieldInNotFound", (String[])new String[]{this.fieldIn}), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"DatabaseJoinDynamic.Meta.CheckResult.FieldFound", (String[])new String[]{this.fieldIn, vfield.getOrigin()}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (this.sql == null || this.sql.length() == 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"DatabaseJoinDynamic.Meta.CheckResult.SQLMissing", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"DatabaseJoinDynamic.Meta.CheckResult.SQLFound", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (this.databaseMeta != null) {
            Database db = new Database(loggingObject, this.databaseMeta);
            this.databases = new Database[]{db};
            try {
                db.connect();
                if (this.templateSQL != null && this.templateSQL.length() != 0) {
                    error_message = "";
                    RowMetaInterface r = db.getQueryFields(space.environmentSubstitute(this.templateSQL), true);
                    if (r != null) {
                        cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"DatabaseJoinDynamic.Meta.CheckResult.QueryOK", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                    }
                    error_message = BaseMessages.getString(PKG, (String)"DatabaseJoinDynamic.Meta.CheckResult.InvalidDBQuery", (String[])new String[0]);
                    cr = new CheckResult(4, (String)error_message, (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                }
                error_message = BaseMessages.getString(PKG, (String)"DatabaseJoinDynamic.Meta.CheckResult.TemplateSQLMissing", (String[])new String[0]);
                cr = new CheckResult(4, (String)error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            catch (KettleException e) {
                error_message = BaseMessages.getString(PKG, (String)"DatabaseJoinDynamic.Meta.CheckResult.ErrorOccurred", (String[])new String[0]) + e.getMessage();
                cr = new CheckResult(4, (String)error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            finally {
                db.disconnect();
            }
        } else {
            error_message = BaseMessages.getString(PKG, (String)"DatabaseJoinDynamic.Meta.CheckResult.InvalidConnection", (String[])new String[0]);
            cr = new CheckResult(4, (String)error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new DatabaseJoinDynamic(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    public StepDataInterface getStepData() {
        return new DatabaseJoinDynamicData();
    }

    public void analyseImpact(List<DatabaseImpact> impact, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, Repository repository, IMetaStore metaStore) throws KettleStepException {
        RowMetaInterface out = prev.clone();
        this.getFields(out, stepMeta.getName(), new RowMetaInterface[]{info}, null, (VariableSpace)transMeta, repository, metaStore);
        if (out != null) {
            for (int i = 0; i < out.size(); ++i) {
                ValueMetaInterface outvalue = out.getValueMeta(i);
                DatabaseImpact di = new DatabaseImpact(1, transMeta.getName(), stepMeta.getName(), this.databaseMeta.getDatabaseName(), "", outvalue.getName(), outvalue.getName(), stepMeta.getName(), this.sql, BaseMessages.getString(PKG, (String)"DatabaseJoinDynamic.Meta.DatabaseImpact.Title", (String[])new String[0]));
                impact.add(di);
            }
        }
    }

    public DatabaseMeta[] getUsedDatabaseConnections() {
        if (this.databaseMeta != null) {
            return new DatabaseMeta[]{this.databaseMeta};
        }
        return super.getUsedDatabaseConnections();
    }

    public boolean supportsErrorHandling() {
        return true;
    }
}

