/*
 * Decompiled with CFR 0.152.
 */
package de.simplicit.vjdbc.command;

import de.simplicit.vjdbc.command.Command;
import de.simplicit.vjdbc.command.ConnectionContext;
import de.simplicit.vjdbc.command.JdbcInterfaceType;
import de.simplicit.vjdbc.serial.UIDEx;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DestroyCommand
implements Command {
    static final long serialVersionUID = 4457392123395584636L;
    private static Log _logger = LogFactory.getLog(DestroyCommand.class);
    private Long _uid;
    private int _interfaceType;

    public DestroyCommand() {
    }

    public DestroyCommand(UIDEx regentry, int interfaceType) {
        this._uid = regentry.getUID();
        this._interfaceType = interfaceType;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this._uid);
        out.writeInt(this._interfaceType);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._uid = new Long(in.readLong());
        this._interfaceType = in.readInt();
    }

    @Override
    public Object execute(Object target, ConnectionContext ctx) throws SQLException {
        block8: {
            Object removed = ctx.removeJDBCObject(this._uid);
            if (removed == target) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("Removed " + target.getClass().getName() + " with UID " + this._uid));
                }
                try {
                    Class targetClass = JdbcInterfaceType._interfaces[this._interfaceType];
                    Method mth = targetClass.getDeclaredMethod("close", new Class[0]);
                    mth.invoke(target, (Object[])null);
                    if (_logger.isDebugEnabled()) {
                        _logger.debug((Object)"Invoked close() successfully");
                    }
                    break block8;
                }
                catch (NoSuchMethodException e) {
                }
                catch (Exception e) {
                    if (_logger.isDebugEnabled()) {
                        _logger.debug((Object)"Invocation of close() failed", (Throwable)e);
                    }
                    break block8;
                }
            }
            if (_logger.isWarnEnabled()) {
                _logger.warn((Object)("Target object " + target + " wasn't registered with UID " + this._uid));
            }
        }
        return null;
    }

    public String toString() {
        return "DestroyCommand";
    }
}

