/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.checksum;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.injection.InjectionSupported;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBinary;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.checksum.CheckSum;
import org.pentaho.di.trans.steps.checksum.CheckSumData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@Step(id="CheckSum", i18nPackageName="org.pentaho.di.trans.steps.checksum", name="CheckSum.Name", description="CheckSum.Description", categoryDescription="i18n:org.pentaho.di.trans.step:BaseStep.Category.Transform")
@InjectionSupported(localizationPrefix="CheckSum.Injection.", groups={"FIELDS"})
public class CheckSumMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = CheckSumMeta.class;
    protected static final String XML_TAG_CHECKSUMTYPE = "checksumtype";
    protected static final String XML_TAG_FIELD_SEPARATOR_STRING = "fieldSeparatorString";
    protected static final String XML_TAG_RESULTFIELD_NAME = "resultfieldName";
    protected static final String XML_TAG_RESULT_TYPE = "resultType";
    protected static final String XML_TAG_COMPATIBILITY_MODE = "compatibilityMode";
    protected static final String XML_TAG_OLD_CHECKSUM_BEHAVIOUR = "oldChecksumBehaviour";
    protected static final String XML_TAG_EVALUATION_METHOD = "evaluationMethod";
    protected static final String XML_TAG_FIELDS = "fields";
    protected static final String XML_TAG_FIELD = "field";
    protected static final String XML_TAG_NAME = "name";
    protected static final String XML_TAG_FIELD_NAME = "field_name";
    public static final String TYPE_CRC32 = "CRC32";
    public static final String TYPE_ADLER32 = "ADLER32";
    public static final String TYPE_MD5 = "MD5";
    public static final String TYPE_SHA1 = "SHA-1";
    public static final String TYPE_SHA256 = "SHA-256";
    public static final String[] checksumtypeCodes = new String[]{"CRC32", "ADLER32", "MD5", "SHA-1", "SHA-256"};
    public static final String[] checksumtypeDescs = new String[]{BaseMessages.getString(PKG, (String)"CheckSumMeta.Type.CRC32", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CheckSumMeta.Type.ADLER32", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CheckSumMeta.Type.MD5", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CheckSumMeta.Type.SHA1", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CheckSumMeta.Type.SHA256", (String[])new String[0])};
    public static final String[] resultTypeCode = new String[]{"string", "hexadecimal", "binary"};
    public static final int result_TYPE_STRING = 0;
    public static final int result_TYPE_HEXADECIMAL = 1;
    public static final int result_TYPE_BINARY = 2;
    private static final String[] resultTypeDesc = new String[]{BaseMessages.getString(PKG, (String)"CheckSumMeta.ResultType.String", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CheckSumMeta.ResultType.Hexadecimal", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CheckSumMeta.ResultType.Binary", (String[])new String[0])};
    protected static final String[] EVALUATION_METHOD_CODES = new String[]{"BYTES", "PENTAHO_STRINGS", "NATIVE_STRINGS"};
    public static final int EVALUATION_METHOD_BYTES = 0;
    public static final int EVALUATION_METHOD_PENTAHO_STRINGS = 1;
    public static final int EVALUATION_METHOD_NATIVE_STRINGS = 2;
    public static final int DEFAULT_EVALUATION_METHOD = 0;
    protected static final String[] EVALUATION_METHOD_DESCS = new String[]{BaseMessages.getString(PKG, (String)"CheckSumMeta.EvaluationMethod.Bytes", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CheckSumMeta.EvaluationMethod.PentahoStrings", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CheckSumMeta.EvaluationMethod.NativeStrings", (String[])new String[0])};
    @Injection(name="FIELD_NAME", group="FIELDS")
    private String[] fieldName;
    @Injection(name="RESULT_FIELD")
    private String resultfieldName;
    @Injection(name="TYPE")
    private String checksumtype;
    @Injection(name="COMPATIBILITY_MODE")
    private boolean compatibilityMode;
    @Injection(name="OLD_CHECKSUM_BEHAVIOR")
    @Deprecated
    private boolean oldChecksumBehaviour;
    @Injection(name="FIELD_SEPARATOR_STRING")
    private String fieldSeparatorString;
    @Injection(name="RESULT_TYPE")
    private int resultType;
    @Injection(name="EVALUATION_METHOD")
    private int evaluationMethod;

    public CheckSumMeta() {
        this.allocate(0);
    }

    public void setCheckSumType(int i) {
        this.checksumtype = checksumtypeCodes[i];
    }

    public int getTypeByDesc() {
        if (this.checksumtype == null) {
            return 0;
        }
        for (int i = 0; i < checksumtypeCodes.length; ++i) {
            if (!this.checksumtype.equals(checksumtypeCodes[i])) continue;
            return i;
        }
        return 0;
    }

    public String getCheckSumType() {
        return this.checksumtype;
    }

    public String[] getChecksumtypeDescs() {
        return checksumtypeDescs;
    }

    public String[] getResultTypeDescs() {
        return resultTypeDesc;
    }

    public int getResultType() {
        return this.resultType;
    }

    public String getResultTypeDesc(int i) {
        if (i < 0 || i >= resultTypeDesc.length) {
            return resultTypeDesc[0];
        }
        return resultTypeDesc[i];
    }

    public int getResultTypeByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < resultTypeDesc.length; ++i) {
            if (!resultTypeDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return this.getResultTypeByCode(tt);
    }

    private int getResultTypeByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < resultTypeCode.length; ++i) {
            if (!resultTypeCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public void setResultType(int resultType) {
        this.resultType = resultType;
    }

    public int getEvaluationMethod() {
        return this.evaluationMethod;
    }

    public void setEvaluationMethod(int evaluationMethod) {
        this.evaluationMethod = evaluationMethod;
    }

    public static String[] getEvaluationMethodDescs() {
        return EVALUATION_METHOD_DESCS;
    }

    public static String getEvaluationMethodDesc(int evaluationMethodIndex) {
        if (evaluationMethodIndex < 0 || evaluationMethodIndex >= EVALUATION_METHOD_DESCS.length) {
            evaluationMethodIndex = 0;
        }
        return EVALUATION_METHOD_DESCS[evaluationMethodIndex];
    }

    public static String getEvaluationMethodCode(int evaluationMethodIndex) {
        if (evaluationMethodIndex < 0 || evaluationMethodIndex >= EVALUATION_METHOD_CODES.length) {
            evaluationMethodIndex = 0;
        }
        return EVALUATION_METHOD_CODES[evaluationMethodIndex];
    }

    public int getEvaluationMethodByDesc(String evaluationMethodDesc) {
        if (null != evaluationMethodDesc) {
            for (int i = 0; i < EVALUATION_METHOD_DESCS.length; ++i) {
                if (!EVALUATION_METHOD_DESCS[i].equalsIgnoreCase(evaluationMethodDesc)) continue;
                return i;
            }
            return this.getEvaluationMethodByCode(evaluationMethodDesc);
        }
        return 0;
    }

    public int getEvaluationMethodByCode(String evaluationMethodCode) {
        if (null != evaluationMethodCode) {
            for (int i = 0; i < EVALUATION_METHOD_CODES.length; ++i) {
                if (!EVALUATION_METHOD_CODES[i].equalsIgnoreCase(evaluationMethodCode)) continue;
                return i;
            }
        }
        return 0;
    }

    public String getResultFieldName() {
        return this.resultfieldName;
    }

    public void setResultFieldName(String resultfieldName) {
        this.resultfieldName = resultfieldName;
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    public Object clone() {
        CheckSumMeta retval = (CheckSumMeta)((Object)super.clone());
        int nrfields = this.fieldName.length;
        retval.allocate(nrfields);
        System.arraycopy(this.fieldName, 0, retval.fieldName, 0, nrfields);
        return retval;
    }

    public void allocate(int nrfields) {
        this.fieldName = new String[nrfields];
    }

    public String[] getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String[] fieldName) {
        this.fieldName = fieldName;
    }

    public String getFieldSeparatorString() {
        return this.fieldSeparatorString;
    }

    public void setFieldSeparatorString(String fieldSeparatorString) {
        this.fieldSeparatorString = fieldSeparatorString;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.checksumtype = XMLHandler.getTagValue((Node)stepnode, (String)XML_TAG_CHECKSUMTYPE);
            this.resultfieldName = XMLHandler.getTagValue((Node)stepnode, (String)XML_TAG_RESULTFIELD_NAME);
            this.resultType = this.getResultTypeByCode(Const.NVL((String)XMLHandler.getTagValue((Node)stepnode, (String)XML_TAG_RESULT_TYPE), (String)""));
            this.compatibilityMode = this.parseCompatibilityMode(XMLHandler.getTagValue((Node)stepnode, (String)XML_TAG_COMPATIBILITY_MODE));
            this.oldChecksumBehaviour = this.parseOldChecksumBehaviour(XMLHandler.getTagValue((Node)stepnode, (String)XML_TAG_OLD_CHECKSUM_BEHAVIOUR));
            String evalMet = XMLHandler.getTagValue((Node)stepnode, (String)XML_TAG_EVALUATION_METHOD);
            if (null == evalMet) {
                evalMet = Const.getEnvironmentVariable((String)"KETTLE_DEFAULT_CHECKSUM_EVALUATION_METHOD", (String)"BYTES");
            }
            this.evaluationMethod = this.getEvaluationMethodByCode(evalMet);
            this.setFieldSeparatorString(XMLHandler.getTagValue((Node)stepnode, (String)XML_TAG_FIELD_SEPARATOR_STRING));
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)XML_TAG_FIELDS);
            int nrfields = XMLHandler.countNodes((Node)fields, (String)XML_TAG_FIELD);
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)XML_TAG_FIELD, (int)i);
                this.fieldName[i] = XMLHandler.getTagValue((Node)fnode, (String)XML_TAG_NAME);
            }
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    private boolean parseCompatibilityMode(String compatibilityMode) {
        if (compatibilityMode == null) {
            return true;
        }
        return Boolean.parseBoolean(compatibilityMode) || "Y".equalsIgnoreCase(compatibilityMode);
    }

    private boolean parseOldChecksumBehaviour(String oldChecksumBehaviour) {
        if (oldChecksumBehaviour == null) {
            return true;
        }
        return Boolean.parseBoolean(oldChecksumBehaviour) || "Y".equalsIgnoreCase(oldChecksumBehaviour);
    }

    private static String getResultTypeCode(int i) {
        if (i < 0 || i >= resultTypeCode.length) {
            return resultTypeCode[0];
        }
        return resultTypeCode[i];
    }

    public String getXML() {
        StringBuilder retval = new StringBuilder(200);
        retval.append("      ").append(XMLHandler.addTagValue((String)XML_TAG_CHECKSUMTYPE, (String)this.checksumtype));
        retval.append("      ").append(XMLHandler.addTagValue((String)XML_TAG_RESULTFIELD_NAME, (String)this.resultfieldName));
        retval.append("      ").append(XMLHandler.addTagValue((String)XML_TAG_RESULT_TYPE, (String)CheckSumMeta.getResultTypeCode(this.resultType)));
        retval.append("      ").append(XMLHandler.addTagValue((String)XML_TAG_COMPATIBILITY_MODE, (boolean)this.compatibilityMode));
        retval.append("      ").append(XMLHandler.addTagValue((String)XML_TAG_OLD_CHECKSUM_BEHAVIOUR, (boolean)this.oldChecksumBehaviour));
        retval.append("      ").append(XMLHandler.addTagValue((String)XML_TAG_EVALUATION_METHOD, (String)CheckSumMeta.getEvaluationMethodCode(this.evaluationMethod)));
        if (this.getFieldSeparatorString() != null) {
            retval.append("      ").append(XMLHandler.addTagValue((String)XML_TAG_FIELD_SEPARATOR_STRING, (String)this.getFieldSeparatorString()));
        }
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.fieldName.length; ++i) {
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)XML_TAG_NAME, (String)this.fieldName[i]));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        return retval.toString();
    }

    public void setDefault() {
        this.resultfieldName = null;
        this.checksumtype = checksumtypeCodes[0];
        this.resultType = 1;
        this.fieldSeparatorString = null;
        this.evaluationMethod = 0;
        this.allocate(0);
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.checksumtype = rep.getStepAttributeString(id_step, XML_TAG_CHECKSUMTYPE);
            this.resultfieldName = rep.getStepAttributeString(id_step, XML_TAG_RESULTFIELD_NAME);
            this.resultType = this.getResultTypeByCode(Const.NVL((String)rep.getStepAttributeString(id_step, XML_TAG_RESULT_TYPE), (String)""));
            this.compatibilityMode = this.parseCompatibilityMode(rep.getStepAttributeString(id_step, XML_TAG_COMPATIBILITY_MODE));
            this.oldChecksumBehaviour = this.parseOldChecksumBehaviour(rep.getStepAttributeString(id_step, XML_TAG_OLD_CHECKSUM_BEHAVIOUR));
            String evalMet = rep.getStepAttributeString(id_step, XML_TAG_EVALUATION_METHOD);
            if (null == evalMet) {
                evalMet = Const.getEnvironmentVariable((String)"KETTLE_DEFAULT_CHECKSUM_EVALUATION_METHOD", (String)"BYTES");
            }
            this.evaluationMethod = this.getEvaluationMethodByCode(evalMet);
            this.setFieldSeparatorString(rep.getStepAttributeString(id_step, XML_TAG_FIELD_SEPARATOR_STRING));
            int nrfields = rep.countNrStepAttributes(id_step, XML_TAG_FIELD_NAME);
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                this.fieldName[i] = rep.getStepAttributeString(id_step, i, XML_TAG_FIELD_NAME);
            }
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, XML_TAG_CHECKSUMTYPE, this.checksumtype);
            rep.saveStepAttribute(id_transformation, id_step, XML_TAG_RESULTFIELD_NAME, this.resultfieldName);
            rep.saveStepAttribute(id_transformation, id_step, XML_TAG_RESULT_TYPE, CheckSumMeta.getResultTypeCode(this.resultType));
            rep.saveStepAttribute(id_transformation, id_step, XML_TAG_COMPATIBILITY_MODE, this.compatibilityMode);
            rep.saveStepAttribute(id_transformation, id_step, XML_TAG_OLD_CHECKSUM_BEHAVIOUR, this.oldChecksumBehaviour);
            rep.saveStepAttribute(id_transformation, id_step, XML_TAG_EVALUATION_METHOD, CheckSumMeta.getEvaluationMethodCode(this.evaluationMethod));
            if (this.getFieldSeparatorString() != null) {
                rep.saveStepAttribute(id_transformation, id_step, XML_TAG_FIELD_SEPARATOR_STRING, this.getFieldSeparatorString());
            }
            for (int i = 0; i < this.fieldName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, XML_TAG_FIELD_NAME, this.fieldName[i]);
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    public void getFields(RowMetaInterface inputRowMeta, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        if (!Utils.isEmpty((CharSequence)this.resultfieldName)) {
            ValueMetaInteger v = null;
            if (this.checksumtype.equals(TYPE_CRC32) || this.checksumtype.equals(TYPE_ADLER32)) {
                v = new ValueMetaInteger(space.environmentSubstitute(this.resultfieldName));
            } else {
                switch (this.resultType) {
                    case 2: {
                        v = new ValueMetaBinary(space.environmentSubstitute(this.resultfieldName));
                        break;
                    }
                    default: {
                        v = new ValueMetaString(space.environmentSubstitute(this.resultfieldName));
                    }
                }
            }
            v.setOrigin(name);
            inputRowMeta.addValueMeta((ValueMetaInterface)v);
        }
    }

    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        String error_message = "";
        if (Utils.isEmpty((CharSequence)this.resultfieldName)) {
            error_message = BaseMessages.getString(PKG, (String)"CheckSumMeta.CheckResult.ResultFieldMissing", (String[])new String[0]);
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
        } else {
            error_message = BaseMessages.getString(PKG, (String)"CheckSumMeta.CheckResult.ResultFieldOK", (String[])new String[0]);
            cr = new CheckResult(1, error_message, (CheckResultSourceInterface)stepMeta);
        }
        remarks.add((CheckResultInterface)cr);
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"CheckSumMeta.CheckResult.NotReceivingFields", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"CheckSumMeta.CheckResult.StepRecevingData", (String[])new String[]{prev.size() + ""}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            boolean error_found = false;
            error_message = "";
            for (int i = 0; i < this.fieldName.length; ++i) {
                int idx = prev.indexOfValue(this.fieldName[i]);
                if (idx >= 0) continue;
                error_message = error_message + "\t\t" + this.fieldName[i] + Const.CR;
                error_found = true;
            }
            if (error_found) {
                error_message = BaseMessages.getString(PKG, (String)"CheckSumMeta.CheckResult.FieldsFound", (String[])new String[]{error_message});
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else if (this.fieldName.length > 0) {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"CheckSumMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"CheckSumMeta.CheckResult.NoFieldsEntered", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"CheckSumMeta.CheckResult.StepRecevingData2", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"CheckSumMeta.CheckResult.NoInputReceivedFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (this.isCompatibilityMode()) {
            cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"CheckSumMeta.CheckResult.CompatibilityModeWarning", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            if (TYPE_SHA256.equals(this.getCheckSumType())) {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"CheckSumMeta.CheckResult.CompatibilityModeSHA256Error", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        }
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new CheckSum(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    public StepDataInterface getStepData() {
        return new CheckSumData();
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    @Deprecated
    public boolean isCompatibilityMode() {
        return this.compatibilityMode;
    }

    @Deprecated
    public boolean isOldChecksumBehaviour() {
        return this.oldChecksumBehaviour;
    }

    @Deprecated
    public void setCompatibilityMode(boolean compatibilityMode) {
        this.compatibilityMode = compatibilityMode;
    }

    @Deprecated
    public void setOldChecksumBehaviour(boolean oldChecksumBehaviour) {
        this.oldChecksumBehaviour = oldChecksumBehaviour;
    }
}

