/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.checksum;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.commons.codec.binary.Hex;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.checksum.CheckSumData;
import org.pentaho.di.trans.steps.checksum.CheckSumMeta;

public class CheckSum
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = CheckSumMeta.class;
    private CheckSumMeta meta;
    private CheckSumData data;

    public CheckSum(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block20: {
            this.meta = (CheckSumMeta)smi;
            this.data = (CheckSumData)sdi;
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                int i;
                int[] fieldIndexMapping;
                this.first = false;
                RowMetaInterface inputRowMeta = this.getInputRowMeta();
                this.data.outputRowMeta = inputRowMeta.clone();
                this.data.nrInfields = this.data.outputRowMeta.size();
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, (VariableSpace)this, this.repository, this.metaStore);
                if (this.meta.getFieldSeparatorString() != null && !this.meta.getFieldSeparatorString().isEmpty()) {
                    this.data.fieldSeparatorStringBytes = this.meta.getFieldSeparatorString().getBytes(StandardCharsets.UTF_8);
                }
                if (this.meta.getFieldName() == null || this.meta.getFieldName().length > 0) {
                    fieldIndexMapping = new int[this.meta.getFieldName().length];
                    for (i = 0; i < this.meta.getFieldName().length; ++i) {
                        fieldIndexMapping[i] = this.getInputRowMeta().indexOfValue(this.meta.getFieldName()[i]);
                        if (fieldIndexMapping[i] >= 0) continue;
                        this.logError(BaseMessages.getString(PKG, (String)"CheckSum.Log.CanNotFindField", (String[])new String[]{this.meta.getFieldName()[i]}));
                        throw new KettleException(BaseMessages.getString(PKG, (String)"CheckSum.Log.CanNotFindField", (String[])new String[]{this.meta.getFieldName()[i]}));
                    }
                } else {
                    fieldIndexMapping = new int[inputRowMeta.size()];
                    for (i = 0; i < fieldIndexMapping.length; ++i) {
                        fieldIndexMapping[i] = i;
                    }
                }
                this.initializeFieldConverters(inputRowMeta, fieldIndexMapping);
                this.initializeChecksumCalculator();
            }
            Object[] outputRowData = null;
            try {
                for (int i = 0; i < this.data.fieldConverters.length; ++i) {
                    if (i != 0 && this.data.fieldSeparatorStringBytes != null) {
                        this.data.checksumCalculator.update(this.data.fieldSeparatorStringBytes);
                    }
                    this.data.checksumCalculator.update(this.data.fieldConverters[i].getBytes(r));
                }
                Object checksumResult = this.data.checksumCalculator.getResult();
                if (checksumResult instanceof Long) {
                    outputRowData = RowDataUtil.addValueData((Object[])r, (int)this.data.nrInfields, (Object)((Long)checksumResult));
                } else if (checksumResult instanceof byte[]) {
                    byte[] o = (byte[])checksumResult;
                    switch (this.meta.getResultType()) {
                        case 2: {
                            outputRowData = RowDataUtil.addValueData((Object[])r, (int)this.data.nrInfields, (Object)o);
                            break;
                        }
                        case 1: {
                            String hex = this.meta.isCompatibilityMode() ? this.byteToHexEncode_compatible(o) : new String(Hex.encodeHex((byte[])o));
                            outputRowData = RowDataUtil.addValueData((Object[])r, (int)this.data.nrInfields, (Object)hex);
                            break;
                        }
                        default: {
                            outputRowData = RowDataUtil.addValueData((Object[])r, (int)this.data.nrInfields, (Object)CheckSum.getStringFromBytes(o));
                        }
                    }
                }
                if (this.checkFeedback(this.getLinesRead()) && this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"CheckSum.Log.LineNumber", (String[])new String[]{Long.toString(this.getLinesRead())}));
                }
                this.putRow(this.data.outputRowMeta, outputRowData);
            }
            catch (Exception e) {
                boolean sendToErrorRow = false;
                String errorMessage = null;
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"CheckSum.ErrorInStepRunning", (String[])new String[0]) + e.getMessage());
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block20;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, this.meta.getResultFieldName(), "CheckSum001");
            }
        }
        return true;
    }

    private void initializeChecksumCalculator() throws KettleException {
        try {
            switch (this.meta.getCheckSumType()) {
                case "MD5": 
                case "SHA-1": 
                case "SHA-256": {
                    this.data.checksumCalculator = new DigestChecksumCalculator(MessageDigest.getInstance(this.meta.getCheckSumType()));
                    break;
                }
                case "ADLER32": {
                    this.data.checksumCalculator = new ChecksumChecksumCalculator(new Adler32());
                    break;
                }
                case "CRC32": {
                    this.data.checksumCalculator = new ChecksumChecksumCalculator(new CRC32());
                    break;
                }
                default: {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"CheckSum.Error.UnknownChecksumType", (String[])new String[]{this.meta.getCheckSumType()}));
                }
            }
        }
        catch (KettleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"CheckSum.Error.Digest", (String[])new String[0]), (Throwable)e);
        }
    }

    private void initializeFieldConverters(RowMetaInterface inputRowMeta, int[] fieldIndexMapping) throws KettleException {
        this.data.fieldConverters = new FieldToBytesConverter[fieldIndexMapping.length];
        block5: for (int i = 0; i < fieldIndexMapping.length; ++i) {
            switch (this.meta.getEvaluationMethod()) {
                case 0: {
                    this.data.fieldConverters[i] = new BytesToBytesConverter(inputRowMeta, fieldIndexMapping[i]);
                    continue block5;
                }
                case 1: {
                    this.data.fieldConverters[i] = new PentahoStringsToBytesConverter(inputRowMeta, fieldIndexMapping[i]);
                    continue block5;
                }
                case 2: {
                    this.data.fieldConverters[i] = new NativeStringsToBytesConverter(inputRowMeta, fieldIndexMapping[i]);
                    continue block5;
                }
                default: {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"CheckSum.Error.UnknownEvaluationMethod", (Object[])new Object[]{this.meta.getEvaluationMethod()}));
                }
            }
        }
    }

    private static String getStringFromBytes(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            sb.append(0xFF & b);
            if (i + 1 >= bytes.length) continue;
            sb.append("-");
        }
        return sb.toString();
    }

    public String byteToHexEncode_compatible(byte[] in) {
        if (in == null) {
            return null;
        }
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        String hex = new String(in);
        char[] s = hex.toCharArray();
        StringBuilder hexString = new StringBuilder(2 * s.length);
        for (int i = 0; i < s.length; ++i) {
            hexString.append(hexDigits[(s[i] & 0xF0) >> 4]);
            hexString.append(hexDigits[s[i] & 0xF]);
        }
        return hexString.toString();
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (CheckSumMeta)smi;
        this.data = (CheckSumData)sdi;
        if (super.init(smi, sdi)) {
            if (Utils.isEmpty((CharSequence)this.meta.getResultFieldName())) {
                this.logError(BaseMessages.getString(PKG, (String)"CheckSum.Error.ResultFieldMissing", (String[])new String[0]));
                return false;
            }
            if (this.meta.isCompatibilityMode() && "SHA-256".equals(this.meta.getCheckSumType())) {
                this.logError(BaseMessages.getString(PKG, (String)"CheckSumMeta.CheckResult.CompatibilityModeSHA256Error", (String[])new String[0]));
                return false;
            }
            return true;
        }
        return false;
    }

    public static class BytesToBytesConverter
    implements FieldToBytesConverter {
        private final RowMetaInterface rmi;
        private final ValueMetaInterface vmi;
        private final int fieldIndex;
        private final boolean isBinary;

        public BytesToBytesConverter(RowMetaInterface inputRowMeta, int fieldIndex) {
            this.rmi = inputRowMeta;
            this.vmi = this.rmi.getValueMeta(fieldIndex);
            this.fieldIndex = fieldIndex;
            this.isBinary = this.vmi.isBinary();
        }

        @Override
        public byte[] getBytes(Object[] row) throws KettleException {
            return this.isBinary ? this.getBytesFromBinary(row) : this.getBytesFromNonBinary(row);
        }

        private byte[] getBytesFromBinary(Object[] row) throws KettleException {
            return this.rmi.getBinary(row, this.fieldIndex);
        }

        private byte[] getBytesFromNonBinary(Object[] row) throws KettleException {
            return this.vmi.getNativeDataType(row[this.fieldIndex]).toString().getBytes();
        }
    }

    public static class NativeStringsToBytesConverter
    implements FieldToBytesConverter {
        private final ValueMetaInterface vmi;
        private final int fieldIndex;

        public NativeStringsToBytesConverter(RowMetaInterface inputRowMeta, int fieldIndex) {
            this.vmi = inputRowMeta.getValueMeta(fieldIndex);
            this.fieldIndex = fieldIndex;
        }

        @Override
        public byte[] getBytes(Object[] row) throws KettleException {
            return String.valueOf(this.vmi.getNativeDataType(row[this.fieldIndex])).getBytes();
        }
    }

    public static class PentahoStringsToBytesConverter
    implements FieldToBytesConverter {
        private final RowMetaInterface rmi;
        private final int fieldIndex;

        public PentahoStringsToBytesConverter(RowMetaInterface inputRowMeta, int fieldIndex) {
            this.rmi = inputRowMeta;
            this.fieldIndex = fieldIndex;
        }

        @Override
        public byte[] getBytes(Object[] row) throws KettleException {
            return String.valueOf(this.rmi.getString(row, this.fieldIndex)).getBytes();
        }
    }

    public static interface FieldToBytesConverter {
        public byte[] getBytes(Object[] var1) throws KettleException;
    }

    public static class DigestChecksumCalculator
    implements GenericChecksumCalculator<byte[]> {
        private final MessageDigest digest;

        public DigestChecksumCalculator(MessageDigest digest) {
            this.digest = digest;
        }

        @Override
        public void update(byte[] contentBytes) {
            if (contentBytes != null) {
                this.digest.update(contentBytes);
            }
        }

        @Override
        public byte[] getResult() {
            return this.digest.digest();
        }
    }

    public static class ChecksumChecksumCalculator
    implements GenericChecksumCalculator<Long> {
        private final Checksum checksum;

        public ChecksumChecksumCalculator(Checksum checksum) {
            this.checksum = checksum;
        }

        @Override
        public void update(byte[] contentBytes) {
            if (contentBytes != null) {
                this.checksum.update(contentBytes, 0, contentBytes.length);
            }
        }

        @Override
        public Long getResult() {
            try {
                Long l = new Long(this.checksum.getValue());
                return l;
            }
            finally {
                this.checksum.reset();
            }
        }
    }

    public static interface GenericChecksumCalculator<R> {
        public void update(byte[] var1);

        public R getResult();
    }
}

