/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.autodoc;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.gui.AreaOwner;
import org.pentaho.di.core.gui.GCInterface;
import org.pentaho.di.core.gui.Point;
import org.pentaho.di.core.gui.ScrollBarInterface;
import org.pentaho.di.core.gui.SwingGC;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.JobPainter;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.steps.autodoc.ReportSubjectLocation;

public class JobInformation {
    private static JobInformation jobInfo;
    private Repository repository;
    private Map<ReportSubjectLocation, JobInformationValues> map = new HashMap<ReportSubjectLocation, JobInformationValues>();

    public static final JobInformation getInstance() {
        if (jobInfo == null) {
            throw new RuntimeException("The JobInformation singleton was not initialized!");
        }
        return jobInfo;
    }

    public static final void init(Repository repository) {
        jobInfo = new JobInformation();
        JobInformation.jobInfo.repository = repository;
    }

    private JobInformation() {
    }

    public BufferedImage getImage(ReportSubjectLocation location) throws KettleException {
        return this.getValues((ReportSubjectLocation)location).image;
    }

    public JobMeta getJobMeta(ReportSubjectLocation location) throws KettleException {
        return this.getValues((ReportSubjectLocation)location).jobMeta;
    }

    public List<AreaOwner> getImageAreaList(ReportSubjectLocation location) throws KettleException {
        return this.getValues((ReportSubjectLocation)location).areaOwners;
    }

    private JobInformationValues getValues(ReportSubjectLocation location) throws KettleException {
        JobInformationValues values = this.map.get(location);
        if (values == null) {
            values = this.loadValues(location);
            this.map.put(location, values);
        }
        return values;
    }

    private JobMeta loadJob(ReportSubjectLocation location) throws KettleException {
        JobMeta jobMeta = !Utils.isEmpty((CharSequence)location.getFilename()) ? new JobMeta(location.getFilename(), this.repository) : this.repository.loadJob(location.getName(), location.getDirectory(), null, null);
        return jobMeta;
    }

    private JobInformationValues loadValues(ReportSubjectLocation location) throws KettleException {
        JobMeta jobMeta = this.loadJob(location);
        Point min = jobMeta.getMinimum();
        Point area = jobMeta.getMaximum();
        area.x += 30;
        area.y += 30;
        int iconsize = 32;
        ScrollBarInterface bar = new ScrollBarInterface(){

            public void setThumb(int thumb) {
            }

            public int getSelection() {
                return 0;
            }
        };
        SwingGC gc = new SwingGC(null, area, iconsize, 50, 20);
        ArrayList<AreaOwner> areaOwners = new ArrayList<AreaOwner>();
        JobPainter painter = new JobPainter((GCInterface)gc, jobMeta, area, bar, bar, null, null, null, areaOwners, new ArrayList(), iconsize, 1, 0, 0, true, "FreeSans", 10);
        painter.setMagnification(0.25f);
        painter.drawJob();
        BufferedImage bufferedImage = (BufferedImage)gc.getImage();
        int newWidth = bufferedImage.getWidth() - min.x;
        int newHeigth = bufferedImage.getHeight() - min.y;
        BufferedImage image = new BufferedImage(newWidth, newHeigth, bufferedImage.getType());
        image.getGraphics().drawImage(bufferedImage, 0, 0, newWidth, newHeigth, min.x, min.y, min.x + newWidth, min.y + newHeigth, null);
        JobInformationValues values = new JobInformationValues();
        values.jobMeta = jobMeta;
        values.image = image;
        values.areaOwners = areaOwners;
        return values;
    }

    public void drawImage(Graphics2D g2d, Rectangle2D rectangle2d, ReportSubjectLocation location, boolean pixelateImages) throws KettleException {
        JobMeta jobMeta = this.loadJob(location);
        Point min = jobMeta.getMinimum();
        Point area = jobMeta.getMaximum();
        area.x -= min.x;
        area.y -= min.y;
        int iconsize = 32;
        ScrollBarInterface bar = new ScrollBarInterface(){

            public void setThumb(int thumb) {
            }

            public int getSelection() {
                return 0;
            }
        };
        Rectangle rect = new Rectangle(0, 0, area.x, area.y);
        double magnificationX = rectangle2d.getWidth() / rect.getWidth();
        double magnificationY = rectangle2d.getHeight() / rect.getHeight();
        float magnification = (float)Math.min(1.0, Math.min(magnificationX, magnificationY));
        SwingGC gc = new SwingGC(g2d, (Rectangle2D)rect, iconsize, 0, 0);
        gc.setDrawingPixelatedImages(pixelateImages);
        ArrayList areaOwners = new ArrayList();
        JobPainter painter = new JobPainter((GCInterface)gc, jobMeta, area, bar, bar, null, null, null, areaOwners, new ArrayList(), iconsize, 1, 0, 0, true, "FreeSans", 10);
        painter.setMagnification(magnification);
        painter.setTranslationX((float)(-min.x) * magnification);
        painter.setTranslationY((float)(-min.y) * magnification);
        painter.drawJob();
    }

    private class JobInformationValues {
        public BufferedImage image;
        public JobMeta jobMeta;
        public List<AreaOwner> areaOwners;

        private JobInformationValues() {
        }
    }
}

