/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.abort;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.abort.Abort;
import org.pentaho.di.trans.steps.abort.AbortData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@Step(id="Abort", i18nPackageName="org.pentaho.di.trans.steps.abort", name="Abort.Name", description="Abort.Description", categoryDescription="i18n:org.pentaho.di.trans.step:BaseStep.Category.Flow")
public class AbortMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = AbortMeta.class;
    private String rowThreshold;
    private String message;
    private boolean alwaysLogRows;
    private AbortOption abortOption;

    public void getFields(RowMetaInterface inputRowMeta, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
    }

    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepinfo, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        if (input.length == 0) {
            CheckResult cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"AbortMeta.CheckResult.NoInputReceivedError", (String[])new String[0]), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        }
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        return new Abort(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public StepDataInterface getStepData() {
        return new AbortData();
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    public void setDefault() {
        this.rowThreshold = "0";
        this.message = "";
        this.alwaysLogRows = true;
        this.abortOption = AbortOption.ABORT;
    }

    public String getXML() {
        StringBuilder retval = new StringBuilder(200);
        retval.append("      ").append(XMLHandler.addTagValue((String)"row_threshold", (String)this.rowThreshold));
        retval.append("      ").append(XMLHandler.addTagValue((String)"message", (String)this.message));
        retval.append("      ").append(XMLHandler.addTagValue((String)"always_log_rows", (boolean)this.alwaysLogRows));
        retval.append("      ").append(XMLHandler.addTagValue((String)"abort_option", (String)this.abortOption.toString()));
        return retval.toString();
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.rowThreshold = XMLHandler.getTagValue((Node)stepnode, (String)"row_threshold");
            this.message = XMLHandler.getTagValue((Node)stepnode, (String)"message");
            this.alwaysLogRows = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"always_log_rows"));
            String abortOptionString = XMLHandler.getTagValue((Node)stepnode, (String)"abort_option");
            if (!StringUtil.isEmpty((String)abortOptionString)) {
                this.abortOption = AbortOption.valueOf(abortOptionString);
            } else {
                String awe = XMLHandler.getTagValue((Node)stepnode, (String)"abort_with_error");
                if (awe == null) {
                    awe = "Y";
                }
                this.abortOption = "Y".equalsIgnoreCase(awe) ? AbortOption.ABORT_WITH_ERROR : AbortOption.ABORT;
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"AbortMeta.Exception.UnexpectedErrorInReadingStepInfoFromRepository", (String[])new String[0]), (Throwable)e);
        }
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            boolean abortWithError;
            this.rowThreshold = rep.getStepAttributeString(id_step, "row_threshold");
            this.message = rep.getStepAttributeString(id_step, "message");
            this.alwaysLogRows = rep.getStepAttributeBoolean(id_step, "always_log_rows");
            String abortOptionString = rep.getStepAttributeString(id_step, 0, "abort_option");
            this.abortOption = !StringUtil.isEmpty((String)abortOptionString) ? AbortOption.valueOf(abortOptionString) : ((abortWithError = rep.getStepAttributeBoolean(id_step, 0, "abort_with_error", true)) ? AbortOption.ABORT_WITH_ERROR : AbortOption.ABORT);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"AbortMeta.Exception.UnexpectedErrorInReadingStepInfoFromRepository", (String[])new String[0]), (Throwable)e);
        }
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "row_threshold", this.rowThreshold);
            rep.saveStepAttribute(id_transformation, id_step, "message", this.message);
            rep.saveStepAttribute(id_transformation, id_step, "always_log_rows", this.alwaysLogRows);
            rep.saveStepAttribute(id_transformation, id_step, "abort_option", this.abortOption.toString());
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"AbortMeta.Exception.UnableToSaveStepInfoToRepository", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getRowThreshold() {
        return this.rowThreshold;
    }

    public void setRowThreshold(String rowThreshold) {
        this.rowThreshold = rowThreshold;
    }

    public boolean isAlwaysLogRows() {
        return this.alwaysLogRows;
    }

    public void setAlwaysLogRows(boolean alwaysLogRows) {
        this.alwaysLogRows = alwaysLogRows;
    }

    public AbortOption getAbortOption() {
        return this.abortOption;
    }

    public void setAbortOption(AbortOption abortOption) {
        this.abortOption = abortOption;
    }

    public boolean isAbortWithError() {
        return this.abortOption == AbortOption.ABORT_WITH_ERROR;
    }

    public boolean isAbort() {
        return this.abortOption == AbortOption.ABORT;
    }

    public boolean isSafeStop() {
        return this.abortOption == AbortOption.SAFE_STOP;
    }

    public static enum AbortOption {
        ABORT,
        ABORT_WITH_ERROR,
        SAFE_STOP;

    }
}

