/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.plugins.fileopensave.providers.repository.model;

import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.core.LastUsedFile;
import org.pentaho.di.plugins.fileopensave.api.providers.File;
import org.pentaho.di.plugins.fileopensave.api.providers.Utils;
import org.pentaho.di.plugins.fileopensave.providers.repository.model.RepositoryObject;
import org.pentaho.di.repository.ObjectId;

public class RepositoryFile
extends RepositoryObject
implements File {
    public static final String DELIMITER = "/";
    private String username;

    public static RepositoryFile create(LastUsedFile lastUsedFile, ObjectId objectId) {
        RepositoryFile repositoryFile = new RepositoryFile();
        repositoryFile.setType(lastUsedFile.isTransformation() ? "transformation" : "job");
        repositoryFile.setDate(lastUsedFile.getLastOpened());
        repositoryFile.setRoot("Recents");
        repositoryFile.setName(lastUsedFile.getFilename());
        repositoryFile.setParent(lastUsedFile.getDirectory());
        repositoryFile.setPath(lastUsedFile.getDirectory() + DELIMITER + lastUsedFile.getFilename());
        repositoryFile.setRepository(lastUsedFile.getRepositoryName());
        repositoryFile.setUsername(lastUsedFile.getUsername());
        repositoryFile.setObjectId(objectId.getId());
        return repositoryFile;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public static RepositoryFile build(org.pentaho.di.repository.RepositoryObject repositoryObject) {
        RepositoryFile repositoryFile = new RepositoryFile();
        repositoryFile.setObjectId(repositoryObject.getObjectId().getId());
        repositoryFile.setName(repositoryObject.getName());
        repositoryFile.setType(repositoryObject.getObjectType().getTypeDescription());
        repositoryFile.setExtension(repositoryObject.getObjectType().getExtension());
        repositoryFile.setDate(repositoryObject.getModifiedDate());
        repositoryFile.setParent(repositoryObject.getRepositoryDirectory().getPath());
        String rootPath = repositoryObject.getRepositoryDirectory().getPath();
        rootPath = rootPath.equals(DELIMITER) ? rootPath : rootPath + DELIMITER;
        String filename = repositoryObject.getName();
        if (!filename.endsWith(repositoryFile.getExtension())) {
            filename = filename + repositoryFile.getExtension();
        }
        repositoryFile.setPath(rootPath + filename);
        repositoryFile.setRoot("Pentaho Repository");
        repositoryFile.setCanEdit(true);
        return repositoryFile;
    }

    public static RepositoryFile build(String parentPath, org.pentaho.platform.api.repository2.unified.RepositoryFile repositoryFile, Boolean isAdmin) {
        RepositoryFile repositoryFile1 = new RepositoryFile();
        repositoryFile1.setObjectId((String)((Object)repositoryFile.getId()));
        repositoryFile1.setName(RepositoryFile.stripExtension(repositoryFile.getName()));
        repositoryFile1.setType(RepositoryFile.getType(repositoryFile.getName()));
        repositoryFile1.setExtension("");
        repositoryFile1.setDate(repositoryFile.getLastModifiedDate());
        repositoryFile1.setParent(parentPath);
        repositoryFile1.setPath(repositoryFile.getPath());
        repositoryFile1.setHidden(repositoryFile.isHidden() != false && isAdmin == false);
        repositoryFile1.setRoot("Pentaho Repository");
        repositoryFile1.setCanEdit(true);
        return repositoryFile1;
    }

    public static String stripExtension(String filename) {
        if (filename.indexOf(46) != -1) {
            return filename.substring(0, filename.lastIndexOf(46));
        }
        return filename;
    }

    public static String getType(String filename) {
        if (filename.endsWith(".ktr")) {
            return "transformation";
        }
        if (filename.endsWith(".kjb")) {
            return "job";
        }
        return "";
    }

    public int hashCode() {
        return Objects.hash(this.getProvider(), this.getPath());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RepositoryFile)) {
            return false;
        }
        RepositoryFile compare = (RepositoryFile)((Object)obj);
        return compare.getProvider().equals(this.getProvider()) && StringUtils.equals((String)compare.getPath(), (String)this.getPath());
    }

    public boolean passesTypeFilter(String filter) {
        return Utils.matches((String)(this.getName() + ("transformation".equalsIgnoreCase(this.getType()) ? ".ktr" : ".kjb")), (String)filter);
    }
}

