/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.plugins.fileopensave.providers.recents.model;

import org.pentaho.di.core.LastUsedFile;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.plugins.fileopensave.providers.recents.model.RecentFile;

public class RecentUtils {
    public static final char DELIMITER = '/';
    public static final char WINDOWS_DELIMITER = '\\';

    public static boolean isUrl(String path) {
        return path.matches("^[\\w]+://.*");
    }

    public static boolean isWindows(String path) {
        return path.matches("^[A-Za-z]+:\\\\.*");
    }

    private RecentUtils() {
    }

    public static String getFilename(String path) {
        if (RecentUtils.isWindows(path)) {
            int index = path.lastIndexOf(92);
            return path.substring(index + 1);
        }
        int index = path.lastIndexOf(47);
        return path.substring(index + 1);
    }

    public static String getParent(String path) {
        if (RecentUtils.isWindows(path)) {
            int index = path.lastIndexOf(92);
            return path.substring(0, index);
        }
        int index = path.lastIndexOf(47);
        if (index != -1) {
            return path.substring(0, index);
        }
        return path;
    }

    public static void setPaths(LastUsedFile lastUsedFile, RecentFile recentFile) {
        if (!Utils.isEmpty((CharSequence)lastUsedFile.getRepositoryName())) {
            recentFile.setName(lastUsedFile.getFilename());
            recentFile.setParent(lastUsedFile.getDirectory());
            recentFile.setPath(lastUsedFile.getDirectory() + '/' + lastUsedFile.getFilename());
            recentFile.setRepository(lastUsedFile.getRepositoryName());
            recentFile.setUsername(lastUsedFile.getUsername());
        } else {
            String path = lastUsedFile.getFilename();
            recentFile.setName(RecentUtils.getFilename(path));
            recentFile.setParent(RecentUtils.getParent(path));
            recentFile.setPath(path);
        }
    }
}

