/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.plugins.fileopensave.providers.local;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Stream;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.plugins.fileopensave.api.providers.BaseFileProvider;
import org.pentaho.di.plugins.fileopensave.api.providers.Directory;
import org.pentaho.di.plugins.fileopensave.api.providers.Tree;
import org.pentaho.di.plugins.fileopensave.api.providers.Utils;
import org.pentaho.di.plugins.fileopensave.api.providers.exception.FileException;
import org.pentaho.di.plugins.fileopensave.api.providers.exception.FileExistsException;
import org.pentaho.di.plugins.fileopensave.providers.local.model.LocalDirectory;
import org.pentaho.di.plugins.fileopensave.providers.local.model.LocalFile;
import org.pentaho.di.plugins.fileopensave.providers.local.model.LocalTree;

public class LocalFileProvider
extends BaseFileProvider<LocalFile> {
    public static final String NAME = "Local";
    public static final String TYPE = "local";

    public Class<LocalFile> getFileClass() {
        return LocalFile.class;
    }

    public String getName() {
        return NAME;
    }

    public String getType() {
        return TYPE;
    }

    public Tree getTree() {
        return this.getTree(new ArrayList<String>());
    }

    public Tree getTree(List<String> connectionTypes) {
        LocalTree localTree = new LocalTree(NAME);
        ArrayList<LocalFile> rootFiles = new ArrayList<LocalFile>();
        ArrayList<Path> paths = new ArrayList<Path>();
        FileSystems.getDefault().getRootDirectories().forEach(paths::add);
        paths.forEach(path -> {
            LocalDirectory localDirectory = new LocalDirectory();
            localDirectory.setPath(path.toString());
            localDirectory.setName(path.toString());
            localDirectory.setRoot(NAME);
            localDirectory.setHasChildren(true);
            rootFiles.add(localDirectory);
        });
        localTree.setFiles(rootFiles);
        return localTree;
    }

    public List<LocalFile> getFiles(LocalFile file, String filters, VariableSpace space) throws FileException {
        return this.getFiles(file, filters);
    }

    public List<LocalFile> searchFiles(LocalFile file, final String filters, final String searchString, VariableSpace space) {
        final ArrayList<LocalFile> files = new ArrayList<LocalFile>();
        FileVisitor<Path> visitor = new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                return Files.isReadable(dir) ? FileVisitResult.CONTINUE : FileVisitResult.SKIP_SUBTREE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (Files.isReadable(file)) {
                    LocalFileProvider.this.addReadableFiles(files, file, searchString, filters);
                    return FileVisitResult.CONTINUE;
                }
                return FileVisitResult.SKIP_SUBTREE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                return FileVisitResult.SKIP_SUBTREE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                if (Files.isReadable(dir)) {
                    LocalFileProvider.this.addReadableFiles(files, dir, searchString, filters);
                    return FileVisitResult.CONTINUE;
                }
                return FileVisitResult.SKIP_SUBTREE;
            }
        };
        try {
            Files.walkFileTree(Paths.get(file.getPath(), new String[0]), (FileVisitor<? super Path>)visitor);
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
        return files;
    }

    private void addReadableFiles(List<LocalFile> files, Path path, String searchString, String filters) {
        String name;
        if (path.getFileName() != null && Files.isReadable(path) && (Utils.matches((String)(name = path.getFileName().toString()), (String)searchString) || name.toLowerCase().contains(searchString.toLowerCase()))) {
            if (path.toFile().isDirectory()) {
                files.add(LocalDirectory.create(Utils.getParent((String)path.toString(), (String)FileSystems.getDefault().getSeparator()), path));
            } else if (Utils.matches((String)name, (String)filters)) {
                files.add(LocalFile.create(Utils.getParent((String)path.toString(), (String)FileSystems.getDefault().getSeparator()), path));
            }
        }
    }

    public List<LocalFile> getFiles(LocalFile file, String filters) {
        ArrayList<LocalFile> files = new ArrayList<LocalFile>();
        try (Stream<Path> paths = Files.list(Paths.get(file.getPath(), new String[0]));){
            paths.forEach(path -> {
                String name = path.getFileName().toString();
                try {
                    if (path.toFile().isDirectory()) {
                        files.add(LocalDirectory.create(file.getPath(), path));
                    } else if (Utils.matches((String)name, (String)filters)) {
                        files.add(LocalFile.create(file.getPath(), path));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return files;
    }

    public boolean isAvailable() {
        return true;
    }

    public List<LocalFile> delete(List<LocalFile> files, VariableSpace space) {
        ArrayList<LocalFile> deletedFiles = new ArrayList<LocalFile>();
        for (LocalFile file : files) {
            try {
                File indexFile = new File(file.getPath());
                if (indexFile.isDirectory()) {
                    this.deleteFolder(indexFile);
                } else {
                    indexFile.delete();
                }
                deletedFiles.add(file);
            }
            catch (Exception exception) {}
        }
        return deletedFiles;
    }

    public void deleteFolder(File file) {
        for (File subFile : file.listFiles()) {
            if (subFile.isDirectory()) {
                this.deleteFolder(subFile);
                continue;
            }
            subFile.delete();
        }
        file.delete();
    }

    public LocalFile add(LocalFile folder, VariableSpace space) throws FileException {
        Path folderPath = Paths.get(folder.getPath(), new String[0]);
        if (folderPath.toFile().exists()) {
            throw new FileExistsException();
        }
        try {
            Path newPath = Files.createDirectories(Paths.get(folder.getPath(), new String[0]), new FileAttribute[0]);
            LocalDirectory localDirectory = new LocalDirectory();
            localDirectory.setName(newPath.getFileName().toString());
            localDirectory.setPath(newPath.getFileName().toString());
            localDirectory.setDate(new Date(Files.getLastModifiedTime(newPath, new LinkOption[0]).toMillis()));
            localDirectory.setRoot(NAME);
            localDirectory.setCanAddChildren(true);
            localDirectory.setCanEdit(true);
            return localDirectory;
        }
        catch (IOException e) {
            return null;
        }
    }

    public LocalFile rename(LocalFile file, String newPath, boolean overwrite, VariableSpace space) throws FileException {
        return this.doMove(file.getPath(), newPath, overwrite, space);
    }

    public LocalFile move(LocalFile file, String toPath, boolean overwrite, VariableSpace space) throws FileException {
        return this.doMove(file.getPath(), toPath, overwrite, space);
    }

    private LocalFile doMove(String path, String newPath, boolean overwrite, VariableSpace space) throws FileException {
        try {
            Path movePath = overwrite ? Files.move(Paths.get(path, new String[0]), Paths.get(newPath, new String[0]), StandardCopyOption.REPLACE_EXISTING) : Files.move(Paths.get(path, new String[0]), Paths.get(newPath, new String[0]), new CopyOption[0]);
            if (Paths.get(path, new String[0]).toFile().isDirectory()) {
                return LocalDirectory.create(movePath.getParent().toString(), movePath);
            }
            return LocalFile.create(movePath.getParent().toString(), movePath);
        }
        catch (IOException e) {
            return null;
        }
    }

    public LocalFile copy(LocalFile file, String toPath, boolean overwrite, VariableSpace space) throws FileException {
        try {
            Path newPath = Paths.get(toPath, new String[0]);
            if (!(file instanceof Directory)) {
                newPath = Files.copy(Paths.get(file.getPath(), new String[0]), Paths.get(toPath, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                return LocalFile.create(newPath.getParent().toString(), newPath);
            }
            Files.walk(Paths.get(file.getPath(), new String[0]), new FileVisitOption[0]).forEach(source -> {
                Path destination = Paths.get(toPath, source.toString().substring(file.getPath().length()));
                try {
                    Files.copy(source, destination, new CopyOption[0]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            if (newPath.toFile().isDirectory()) {
                return LocalDirectory.create(newPath.getParent().toString(), newPath);
            }
            return LocalFile.create(newPath.getParent().toString(), newPath);
        }
        catch (IOException e) {
            return null;
        }
    }

    public boolean fileExists(LocalFile dir, String path, VariableSpace space) {
        return Paths.get(path, new String[0]).toFile().exists();
    }

    public InputStream readFile(LocalFile file, VariableSpace space) {
        try {
            return new BufferedInputStream(new FileInputStream(new File(file.getPath())));
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public LocalFile writeFile(InputStream inputStream, LocalFile destDir, String path, boolean overwrite, VariableSpace space) throws FileException {
        try {
            Files.copy(inputStream, Paths.get(path, new String[0]), new CopyOption[0]);
            return LocalFile.create(destDir.getPath(), Paths.get(path, new String[0]));
        }
        catch (FileAlreadyExistsException e) {
            throw new FileExistsException();
        }
        catch (IOException e) {
            return null;
        }
    }

    public boolean isSame(org.pentaho.di.plugins.fileopensave.api.providers.File file1, org.pentaho.di.plugins.fileopensave.api.providers.File file2) {
        return file1.getProvider().equals(file2.getProvider());
    }

    public String getNewName(LocalFile destDir, String newPath, VariableSpace space) {
        String extension = Utils.getExtension((String)newPath);
        String parent = Utils.getParent((String)newPath, (String)File.separator);
        String name = Utils.getName((String)newPath, (String)File.separator).replace("." + extension, "");
        int i = 1;
        String testName = newPath;
        while (Paths.get(testName, new String[0]).toFile().exists()) {
            testName = Utils.isValidExtension((String)extension) ? parent + name + " " + i + "." + extension : newPath + " " + i;
            ++i;
        }
        return testName;
    }

    public LocalFile getParent(LocalFile file) {
        for (Path path : FileSystems.getDefault().getRootDirectories()) {
            if (file.getParent() != null && !path.toString().equals(file.getParent()) && !path.toString().equals(file.getParent() + FileSystems.getDefault().getSeparator())) continue;
            return null;
        }
        return LocalDirectory.create(Utils.getParent((String)file.getParent(), (String)FileSystems.getDefault().getSeparator()), Paths.get(file.getParent(), new String[0]));
    }

    public void clearProviderCache() {
    }

    public LocalFile createDirectory(String parentPath, LocalFile file, String newFolderName) throws FileException {
        LocalFile newLocalFile = file instanceof Directory ? LocalFile.create(parentPath, Paths.get(file.getPath() + FileSystems.getDefault().getSeparator() + newFolderName, new String[0])) : LocalFile.create(parentPath, Paths.get(file.getParent() + FileSystems.getDefault().getSeparator() + newFolderName, new String[0]));
        return this.add(newLocalFile, (VariableSpace)null);
    }

    public LocalFile getFile(LocalFile file, VariableSpace space) {
        return null;
    }
}

