/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.plugins.fileopensave.extension;

import java.util.function.Supplier;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.extension.ExtensionPoint;
import org.pentaho.di.core.extension.ExtensionPointInterface;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.plugins.fileopensave.api.file.FileDetails;
import org.pentaho.di.plugins.fileopensave.api.providers.FileProvider;
import org.pentaho.di.plugins.fileopensave.api.providers.exception.InvalidFileProviderException;
import org.pentaho.di.plugins.fileopensave.dialog.FileOpenSaveDialog;
import org.pentaho.di.plugins.fileopensave.providers.ProviderService;
import org.pentaho.di.plugins.fileopensave.service.ProviderServiceService;
import org.pentaho.di.ui.core.FileDialogOperation;
import org.pentaho.di.ui.spoon.Spoon;

@ExtensionPoint(id="FileOpenSaveNewExtensionPoint", extensionPointId="SpoonOpenSaveNew", description="Open the new file browser")
public class FileOpenSaveExtensionPoint
implements ExtensionPointInterface {
    private static final int WIDTH = Const.isOSX() || Const.isLinux() ? 930 : 947;
    private static final int HEIGHT = Const.isOSX() || Const.isLinux() ? 618 : 626;
    private Supplier<Spoon> spoonSupplier = Spoon::getInstance;
    private final ProviderService providerService;

    public FileOpenSaveExtensionPoint() {
        this(ProviderServiceService.get());
    }

    public FileOpenSaveExtensionPoint(ProviderService providerService) {
        this.providerService = providerService;
    }

    public void callExtensionPoint(LogChannelInterface logChannelInterface, Object o) throws KettleException {
        FileDialogOperation fileDialogOperation = (FileDialogOperation)o;
        this.resolveProvider(fileDialogOperation);
        FileOpenSaveDialog fileOpenSaveDialog = new FileOpenSaveDialog(this.spoonSupplier.get().getShell(), WIDTH, HEIGHT, logChannelInterface);
        fileOpenSaveDialog.setProviderFilter(fileDialogOperation.getProviderFilter());
        fileOpenSaveDialog.open(fileDialogOperation);
        fileDialogOperation.setPath(null);
        fileDialogOperation.setFilename(null);
        fileDialogOperation.setConnection(null);
        if (!Utils.isEmpty((CharSequence)fileOpenSaveDialog.getProvider())) {
            try {
                FileProvider fileProvider = this.providerService.get(fileOpenSaveDialog.getProvider());
                fileProvider.setFileProperties((FileDetails)fileOpenSaveDialog, fileDialogOperation);
            }
            catch (InvalidFileProviderException e) {
                throw new KettleException((Throwable)e);
            }
        }
    }

    private void resolveProvider(FileDialogOperation op) {
        if (op.getProvider() == null) {
            if (op.getConnection() != null) {
                op.setProvider("vfs");
            } else if (this.spoonSupplier.get().rep != null) {
                op.setProvider("repository");
            } else {
                op.setProvider("local");
            }
        }
    }
}

