/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.plugins.fileopensave.dialog;

import java.util.Map;
import java.util.Objects;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.GUIResource;

public class PasteConfirmationDialog
extends Dialog {
    private static final Class<?> PKG = PasteConfirmationDialog.class;
    private Shell shell;
    boolean isApplyToAll = false;
    private final Map<String, ActionListener> listenerMap;

    public PasteConfirmationDialog(Shell parent, Map<String, ActionListener> listeners) {
        super(parent, 67680);
        this.listenerMap = listeners;
    }

    public void open(String fileName) {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 268503136);
        this.shell.setImage(Objects.requireNonNull(GUIResource.getInstance()).getImageSpoon());
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setText(BaseMessages.getString(PKG, (String)"paste-confirmation-dialog.title", (String[])new String[0]));
        Objects.requireNonNull(PropsUI.getInstance()).setLook((Control)this.shell);
        Label wlImage = new Label((Composite)this.shell, 0);
        wlImage.setImage(GUIResource.getInstance().getImageWarning32());
        FormData fdWarnImage = new FormData();
        fdWarnImage.left = new FormAttachment(0, 15);
        fdWarnImage.top = new FormAttachment(0, 15);
        fdWarnImage.height = 32;
        fdWarnImage.width = 32;
        wlImage.setLayoutData((Object)fdWarnImage);
        PropsUI.getInstance().setLook((Control)wlImage);
        Label wlMessage = new Label((Composite)this.shell, 0x800040);
        wlMessage.setText(BaseMessages.getString(PKG, (String)"paste-confirmation-dialog.messages", (String[])new String[]{fileName}));
        FormData fdMessage = new FormData();
        fdMessage.left = new FormAttachment((Control)wlImage, 15, 131072);
        fdMessage.right = new FormAttachment(100, -15);
        fdMessage.top = new FormAttachment((Control)wlImage, 0, 128);
        wlMessage.setLayoutData((Object)fdMessage);
        PropsUI.getInstance().setLook((Control)wlMessage);
        Button spacer = new Button((Composite)this.shell, 0);
        FormData fdSpacer = new FormData();
        fdSpacer.right = new FormAttachment(100, 0);
        fdSpacer.bottom = new FormAttachment(100, -15);
        fdSpacer.left = new FormAttachment(100, -11);
        fdSpacer.top = new FormAttachment((Control)wlMessage, 15, 1024);
        spacer.setLayoutData((Object)fdSpacer);
        spacer.setVisible(false);
        PropsUI.getInstance().setLook((Control)spacer);
        Button attachTo = spacer;
        Button checkButton = new Button((Composite)this.shell, 32);
        checkButton.setText(BaseMessages.getString(PKG, (String)"paste-confirmation-dialog.applyToAll.label", (String[])new String[0]));
        FormData fdCheckButton = new FormData();
        fdCheckButton.bottom = new FormAttachment(100, -15);
        fdCheckButton.left = new FormAttachment(0, 15);
        checkButton.setLayoutData((Object)fdCheckButton);
        checkButton.addListener(13, event -> {
            this.isApplyToAll = ((Button)event.widget).getSelection();
        });
        PropsUI.getInstance().setLook((Control)checkButton);
        for (Map.Entry<String, ActionListener> item : this.listenerMap.entrySet()) {
            Button wButton = new Button((Composite)this.shell, 8);
            wButton.setText(item.getKey());
            FormData fdButton = new FormData();
            fdButton.right = new FormAttachment((Control)attachTo, -4, 16384);
            fdButton.bottom = new FormAttachment((Control)attachTo, 0, 1024);
            wButton.setLayoutData((Object)fdButton);
            wButton.addListener(13, this.listenAndDispose(item.getValue()));
            PropsUI.getInstance().setLook((Control)wButton);
            attachTo = wButton;
        }
        Point point = this.shell.computeSize(436, -1);
        this.shell.setSize(point);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private Listener listenAndDispose(ActionListener listener) {
        return event -> {
            if (Objects.nonNull(listener)) {
                listener.handleEvent(event, this.isApplyToAll);
            }
            this.shell.dispose();
        };
    }

    public static interface ActionListener {
        public void handleEvent(Event var1, boolean var2);
    }
}

