/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.HexBinaryValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;

public class Base64BinaryValue
extends AtomicValue {
    private byte[] binaryValue;

    public Base64BinaryValue(CharSequence s) throws XPathException {
        Base64Decoder decoder = new Base64Decoder();
        try {
            decoder.translate(s);
        }
        catch (IllegalArgumentException e) {
            XPathException err = new XPathException(e.getMessage());
            err.setErrorCode("FORG0001");
            throw err;
        }
        this.binaryValue = decoder.getByteArray();
        this.typeLabel = BuiltInAtomicType.BASE64_BINARY;
    }

    public Base64BinaryValue(CharSequence s, AtomicType type) {
        Base64Decoder decoder = new Base64Decoder();
        decoder.translate(s);
        this.binaryValue = decoder.getByteArray();
        this.typeLabel = type;
    }

    public Base64BinaryValue(byte[] value) {
        this.binaryValue = value;
        this.typeLabel = BuiltInAtomicType.BASE64_BINARY;
    }

    public AtomicValue copyAsSubType(AtomicType typeLabel) {
        Base64BinaryValue v = new Base64BinaryValue(this.binaryValue);
        v.typeLabel = typeLabel;
        return v;
    }

    public byte[] getBinaryValue() {
        return this.binaryValue;
    }

    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.BASE64_BINARY;
    }

    public ConversionResult convertPrimitive(BuiltInAtomicType requiredType, boolean validate, XPathContext context) {
        switch (requiredType.getPrimitiveType()) {
            case 528: 
            case 632: {
                return this;
            }
            case 513: {
                return new StringValue(this.getStringValueCS());
            }
            case 631: {
                return new UntypedAtomicValue(this.getStringValueCS());
            }
            case 527: {
                return new HexBinaryValue(this.binaryValue);
            }
        }
        ValidationFailure err = new ValidationFailure("Cannot convert base64Binary to " + requiredType.getDisplayName());
        err.setErrorCode("XPTY0004");
        return err;
    }

    public String getStringValue() {
        Base64Encoder encoder = new Base64Encoder();
        encoder.translate(this.binaryValue);
        return new String(encoder.getCharArray());
    }

    public int getLengthInOctets() {
        return this.binaryValue.length;
    }

    public Comparable getSchemaComparable() {
        return new Base64BinaryComparable();
    }

    public Object getXPathComparable(boolean ordered, StringCollator collator, XPathContext context) {
        return ordered ? null : this;
    }

    public boolean equals(Object other) {
        return Arrays.equals(this.binaryValue, ((Base64BinaryValue)other).binaryValue);
    }

    public int hashCode() {
        return Base64BinaryValue.byteArrayHashCode(this.binaryValue);
    }

    protected static int byteArrayHashCode(byte[] value) {
        long h = 0L;
        for (int i = 0; i < Math.min(value.length, 64); ++i) {
            h = h << 1 ^ (long)value[i];
        }
        return (int)(h >> 32 ^ h);
    }

    private static final class Base64Decoder {
        private ByteArrayOutputStream out = new ByteArrayOutputStream();
        private byte[] token = new byte[4];
        private byte[] bytes = new byte[3];
        private int token_length = 0;
        private static final byte NUL = 127;
        private static final byte EOF = 126;
        private static final byte SP = 125;
        private static final byte[] map = new byte[]{127, 127, 127, 127, 127, 127, 127, 127, 127, 125, 125, 127, 127, 125, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 125, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 62, 127, 127, 127, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 127, 127, 127, 126, 127, 127, 127, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 127, 127, 127, 127, 127, 127, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127};

        private Base64Decoder() {
        }

        private void decode_token() {
            int num = this.token[0] << 18 | this.token[1] << 12 | this.token[2] << 6 | this.token[3];
            this.bytes[0] = (byte)(0xFF & num >> 16);
            this.bytes[1] = (byte)(0xFF & num >> 8);
            this.bytes[2] = (byte)(0xFF & num);
            this.out.write(this.bytes, 0, 3);
        }

        private void decode_final_token() {
            byte b0 = this.token[0];
            byte b1 = this.token[1];
            byte b2 = this.token[2];
            byte b3 = this.token[3];
            int eq_count = 0;
            if (b0 == 126) {
                b0 = 0;
                ++eq_count;
            }
            if (b1 == 126) {
                b1 = 0;
                ++eq_count;
            }
            if (b2 == 126) {
                b2 = 0;
                ++eq_count;
            }
            if (b3 == 126) {
                b3 = 0;
                ++eq_count;
            }
            if (eq_count > 2) {
                throw new IllegalArgumentException("The number of '=' signs at the end of a base64 value must not exceed 2");
            }
            if (eq_count == 2 && (b1 & 0xF) != 0) {
                throw new IllegalArgumentException("In base64, if the value ends with '==' then the last character must be one of [AQgw]");
            }
            if (eq_count == 1 && (b2 & 3) != 0) {
                throw new IllegalArgumentException("In base64, if the value ends with '=' then the last character must be one of [AEIMQUYcgkosw048]");
            }
            int num = b0 << 18 | b1 << 12 | b2 << 6 | b3;
            this.out.write((byte)(num >> 16));
            if (eq_count <= 1) {
                this.out.write((byte)(num >> 8 & 0xFF));
                if (eq_count == 0) {
                    this.out.write((byte)(num & 0xFF));
                }
            }
        }

        public final void translate(CharSequence str) throws IllegalArgumentException {
            if (this.token == null) {
                return;
            }
            int length = str.length();
            int found_eq = 0;
            for (int i = 0; i < length; ++i) {
                char c = str.charAt(i);
                if (c > '\u007f') {
                    throw new IllegalArgumentException("non-ASCII character in Base64 value (at offset " + i + ')');
                }
                byte t = map[c];
                if (t == 127) {
                    throw new IllegalArgumentException("invalid character '" + c + "' in Base64 value (at offset " + i + ')');
                }
                if (found_eq > 0 && t != 126 && t != 125) {
                    throw new IllegalArgumentException("In Base64, an '=' character can appear only at the end");
                }
                if (t == 126) {
                    if (found_eq > 0) {
                        if (++found_eq > 2) {
                            throw new IllegalArgumentException("Base64 value can contain at most two '=' characters");
                        }
                        this.token_length = (this.token_length + 1) % 4;
                        continue;
                    }
                    found_eq = 1;
                    int lengthAtEOF = this.token_length;
                    this.eof();
                    this.token_length = (lengthAtEOF + 1) % 4;
                    continue;
                }
                if (t == 125) continue;
                this.token[this.token_length++] = t;
                if (this.token_length != 4) continue;
                if (found_eq == 0) {
                    this.decode_token();
                }
                this.token_length = 0;
            }
            if (this.token_length != 0) {
                throw new IllegalArgumentException("Base64 input must be a multiple of four characters");
            }
        }

        private void eof() {
            if (this.token != null && this.token_length != 0) {
                while (this.token_length < 4) {
                    this.token[this.token_length++] = 126;
                }
                this.decode_final_token();
            }
            this.token_length = 0;
            this.token = new byte[4];
            this.bytes = new byte[3];
        }

        public byte[] getByteArray() {
            this.eof();
            return this.out.toByteArray();
        }
    }

    private static final class Base64Encoder {
        private FastStringBuffer out = new FastStringBuffer(256);
        private int buf = 0;
        private int buf_bytes = 0;
        private char[] line = new char[74];
        private int line_length = 0;
        private static final char[] map = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

        private Base64Encoder() {
        }

        private void encode_token() {
            int i = this.line_length;
            this.line[i] = map[0x3F & this.buf >> 18];
            this.line[i + 1] = map[0x3F & this.buf >> 12];
            this.line[i + 2] = map[0x3F & this.buf >> 6];
            this.line[i + 3] = map[0x3F & this.buf];
            this.line_length += 4;
            this.buf = 0;
            this.buf_bytes = 0;
        }

        private void encode_partial_token() {
            int i = this.line_length;
            this.line[i] = map[0x3F & this.buf >> 18];
            this.line[i + 1] = map[0x3F & this.buf >> 12];
            this.line[i + 2] = this.buf_bytes == 1 ? 61 : map[0x3F & this.buf >> 6];
            this.line[i + 3] = this.buf_bytes <= 2 ? 61 : map[0x3F & this.buf];
            this.line_length += 4;
            this.buf = 0;
            this.buf_bytes = 0;
        }

        private void flush_line() {
            this.out.append(this.line, 0, this.line_length);
            this.line_length = 0;
        }

        public final void translate(byte[] in) {
            int i;
            int in_length = in.length;
            for (i = 0; i < in_length; ++i) {
                this.buf = this.buf_bytes == 0 ? this.buf & 0xFFFF | in[i] << 16 : (this.buf_bytes == 1 ? this.buf & 0xFF00FF | in[i] << 8 & 0xFFFF : this.buf & 0xFFFF00 | in[i] & 0xFF);
                if (++this.buf_bytes == 3) {
                    this.encode_token();
                    if (this.line_length >= 72) {
                        this.flush_line();
                    }
                }
                if (i != in_length - 1) continue;
                if (this.buf_bytes > 0 && this.buf_bytes < 3) {
                    this.encode_partial_token();
                }
                if (this.line_length <= 0) continue;
                this.flush_line();
            }
            for (i = 0; i < this.line.length; ++i) {
                this.line[i] = '\u0000';
            }
        }

        public char[] getCharArray() {
            if (this.buf_bytes != 0) {
                this.encode_partial_token();
            }
            this.flush_line();
            for (int i = 0; i < this.line.length; ++i) {
                this.line[i] = '\u0000';
            }
            char[] ch = new char[this.out.length()];
            if (this.out.length() > 0) {
                this.out.getChars(0, this.out.length(), ch, 0);
            }
            return ch;
        }
    }

    private class Base64BinaryComparable
    implements Comparable {
        private Base64BinaryComparable() {
        }

        public Base64BinaryValue getBase64BinaryValue() {
            return Base64BinaryValue.this;
        }

        public int compareTo(Object o) {
            if (o instanceof Base64BinaryComparable && Arrays.equals(this.getBase64BinaryValue().binaryValue, ((Base64BinaryComparable)o).getBase64BinaryValue().binaryValue)) {
                return 0;
            }
            return Integer.MIN_VALUE;
        }

        public boolean equals(Object o) {
            return this.compareTo(o) == 0;
        }

        public int hashCode() {
            return Base64BinaryValue.this.hashCode();
        }
    }
}

