/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula;

import java.util.Locale;
import java.util.MissingResourceException;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.formula.ErrorValue;
import org.pentaho.reporting.libraries.formula.Messages;

public class CustomErrorValue
implements ErrorValue {
    private String errorMessage;
    private int errorCode;

    public CustomErrorValue(String errorMessage) {
        this.errorMessage = errorMessage;
        this.errorCode = -1;
    }

    public CustomErrorValue(int errorCode, String errorMessage) {
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    @Override
    public String getNamespace() {
        return "http://jfreereport.sourceforge.net/libformula/usererror";
    }

    @Override
    public int getErrorCode() {
        return this.errorCode;
    }

    @Override
    public String getErrorMessage(Locale locale) {
        if (StringUtils.isEmpty((String)this.errorMessage)) {
            try {
                return new Messages(locale).strictString("ErrorValue." + this.errorCode);
            }
            catch (MissingResourceException mre) {
                return new Messages(locale).formatMessage("ErrorValue.Generic", new Integer(this.errorCode));
            }
        }
        return this.errorMessage;
    }
}

