/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.ldapinput;

import java.util.HashSet;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.ldapinput.LDAPConnection;
import org.pentaho.di.trans.steps.ldapinput.LDAPInputData;
import org.pentaho.di.trans.steps.ldapinput.LDAPInputField;
import org.pentaho.di.trans.steps.ldapinput.LDAPInputMeta;

public class LDAPInput
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = LDAPInputMeta.class;
    private LDAPInputMeta meta;
    private LDAPInputData data;

    public LDAPInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        if (!this.data.dynamic && this.first) {
            this.first = false;
            this.data.outputRowMeta = new RowMeta();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, (VariableSpace)this, this.repository, this.metaStore);
            this.data.convertRowMeta = this.data.outputRowMeta.cloneToType(2);
            this.search(this.data.staticSearchBase, this.data.staticFilter);
        }
        Object[] outputRowData = null;
        try {
            outputRowData = this.getOneRow();
            if (outputRowData == null) {
                this.setOutputDone();
                return false;
            }
            this.putRow(this.data.outputRowMeta, outputRowData);
            if (this.log.isRowLevel()) {
                this.logRowlevel(BaseMessages.getString(PKG, (String)"LDAPInput.log.ReadRow", (String[])new String[0]), new Object[]{this.data.outputRowMeta.getString(outputRowData)});
            }
            if (this.checkFeedback(this.getLinesInput()) && this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"LDAPInput.log.LineRow", (String[])new String[0]) + this.getLinesInput());
            }
            return true;
        }
        catch (Exception e) {
            boolean sendToErrorRow = false;
            String errorMessage = null;
            if (!this.getStepMeta().isDoingErrorHandling()) {
                this.logError(BaseMessages.getString(PKG, (String)"LDAPInput.log.Exception", (String[])new String[]{e.getMessage()}));
                this.setErrors(1L);
                this.logError(Const.getStackTracker((Throwable)e));
                this.stopAll();
                this.setOutputDone();
                return false;
            }
            sendToErrorRow = true;
            errorMessage = e.toString();
            if (sendToErrorRow) {
                this.putError(this.getInputRowMeta(), outputRowData, 1L, errorMessage, null, "LDAPINPUT001");
            }
            return true;
        }
    }

    private boolean dynamicSearch() throws KettleException {
        this.data.readRow = this.getRow();
        if (this.data.readRow == null) {
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"LDAPInput.Log.FinishedProcessing", (String[])new String[0]));
            }
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            if (this.meta.isDynamicSearch() && Utils.isEmpty((CharSequence)this.meta.getDynamicSearchFieldName())) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"LDAPInput.Error.DynamicSearchFieldMissing", (String[])new String[0]));
            }
            if (this.meta.isDynamicFilter() && Utils.isEmpty((CharSequence)this.meta.getDynamicFilterFieldName())) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"LDAPInput.Error.DynamicFilterFieldMissing", (String[])new String[0]));
            }
            this.data.nrIncomingFields = this.getInputRowMeta().size();
            this.data.outputRowMeta = this.getInputRowMeta().clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, (VariableSpace)this, this.repository, this.metaStore);
            this.data.convertRowMeta = this.data.outputRowMeta.cloneToType(2);
            if (this.meta.isDynamicSearch()) {
                this.data.indexOfSearchBaseField = this.getInputRowMeta().indexOfValue(this.meta.getDynamicSearchFieldName());
                if (this.data.indexOfSearchBaseField < 0) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"LDAPInput.Exception.CouldnotFindField", (String[])new String[]{this.meta.getDynamicSearchFieldName()}));
                }
            }
            if (this.meta.isDynamicFilter()) {
                this.data.indexOfFilterField = this.getInputRowMeta().indexOfValue(this.meta.getDynamicFilterFieldName());
                if (this.data.indexOfFilterField < 0) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"LDAPInput.Exception.CouldnotFindField", (String[])new String[]{this.meta.getDynamicFilterFieldName()}));
                }
            }
        }
        String searchBase = this.data.staticSearchBase;
        if (this.data.indexOfSearchBaseField > 0) {
            searchBase = this.getInputRowMeta().getString(this.data.readRow, this.data.indexOfSearchBaseField);
        }
        String filter = this.data.staticFilter;
        if (this.data.indexOfFilterField >= 0) {
            filter = this.getInputRowMeta().getString(this.data.readRow, this.data.indexOfFilterField);
        }
        this.search(searchBase, filter);
        return true;
    }

    private Object[] getOneRow() throws KettleException {
        if (this.data.dynamic) {
            while (this.data.readRow == null || (this.data.attributes = this.data.connection.getAttributes()) == null) {
                if (this.dynamicSearch()) continue;
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"LDAPInput.Log.FinishedProcessing", (String[])new String[0]));
                }
                return null;
            }
        } else {
            this.data.attributes = this.data.connection.getAttributes();
        }
        if (this.data.attributes == null) {
            return null;
        }
        return this.buildRow();
    }

    private Object[] buildRow() throws KettleException {
        Object[] outputRowData = this.buildEmptyRow();
        if (this.data.dynamic) {
            System.arraycopy(this.data.readRow, 0, outputRowData, 0, this.data.readRow.length);
        }
        try {
            RowMetaInterface irow;
            for (int i = 0; i < this.meta.getInputFields().length; ++i) {
                LDAPInputField field = this.meta.getInputFields()[i];
                int index = this.data.nrIncomingFields + i;
                Attribute attr = this.data.attributes.get(field.getRealAttribute());
                if (attr != null) {
                    outputRowData[index] = this.getAttributeValue(field, attr, index, outputRowData[index]);
                }
                if (!field.isRepeated() || this.data.previousRow == null || outputRowData[index] != null) continue;
                outputRowData[index] = this.data.previousRow[index];
            }
            int fIndex = this.data.nrIncomingFields + this.data.nrfields;
            if (this.meta.includeRowNumber() && !Utils.isEmpty((CharSequence)this.meta.getRowNumberField())) {
                outputRowData[fIndex] = new Long(this.data.rownr);
            }
            this.data.previousRow = (irow = this.getInputRowMeta()) == null ? outputRowData : irow.cloneRow(outputRowData);
            ++this.data.rownr;
            this.incrementLinesInput();
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"LDAPInput.Exception.CanNotReadLDAP", (String[])new String[0]), (Throwable)e);
        }
        return outputRowData;
    }

    private Object getAttributeValue(LDAPInputField field, Attribute attr, int i, Object outputRowData) throws Exception {
        if (field.getType() == 8) {
            try {
                return attr.get();
            }
            catch (ClassCastException e) {
                return attr.get().toString().getBytes();
            }
        }
        String retval = null;
        if (field.getReturnType() == 1 && field.getType() == 2) {
            return LDAPConnection.extractBytesAndConvertToString(attr, field.isObjectSid());
        }
        retval = this.extractString(attr);
        switch (field.getTrimType()) {
            case 1: {
                retval = Const.ltrim((String)retval);
                break;
            }
            case 2: {
                retval = Const.rtrim((String)retval);
                break;
            }
            case 3: {
                retval = Const.trim((String)retval);
                break;
            }
        }
        ValueMetaInterface targetValueMeta = this.data.outputRowMeta.getValueMeta(i);
        ValueMetaInterface sourceValueMeta = this.data.convertRowMeta.getValueMeta(i);
        return targetValueMeta.convertData(sourceValueMeta, (Object)retval);
    }

    private String extractString(Attribute attr) throws Exception {
        StringBuilder attrStr = new StringBuilder();
        NamingEnumeration<?> eattr = attr.getAll();
        while (eattr.hasMore()) {
            if (attrStr.length() > 0) {
                attrStr.append(this.data.multi_valuedFieldSeparator);
            }
            attrStr.append(eattr.next().toString());
        }
        return attrStr.toString();
    }

    private void connectServerLdap() throws KettleException {
        LDAPInputField field;
        int i;
        this.data.attrReturned = new String[this.meta.getInputFields().length];
        this.data.attributesBinary = new HashSet();
        for (i = 0; i < this.meta.getInputFields().length; ++i) {
            field = this.meta.getInputFields()[i];
            String name = this.environmentSubstitute(field.getAttribute());
            field.setRealAttribute(name);
            if (field.getReturnType() == 1) {
                this.data.attributesBinary.add(name);
            }
            this.data.attrReturned[i] = name;
        }
        this.data.connection = new LDAPConnection(this.log, (VariableSpace)this, this.meta, this.data.attributesBinary);
        for (i = 0; i < this.data.attrReturned.length; ++i) {
            field = this.meta.getInputFields()[i];
            if (!field.isSortedKey()) continue;
            this.data.connection.addSortingAttributes(this.data.attrReturned[i]);
        }
        if (this.meta.UseAuthentication()) {
            String username = this.environmentSubstitute(this.meta.getUserName());
            String password = Encr.decryptPasswordOptionallyEncrypted((String)this.environmentSubstitute(this.meta.getPassword()));
            this.data.connection.connect(username, password);
        } else {
            this.data.connection.connect();
        }
        if (this.meta.getTimeLimit() > 0) {
            this.data.connection.setTimeLimit(this.meta.getTimeLimit() * 1000);
        }
        if (this.meta.isPaging()) {
            this.data.connection.SetPagingSize(Const.toInt((String)this.environmentSubstitute(this.meta.getPageSize()), (int)-1));
        }
    }

    private void search(String searchBase, String filter) throws KettleException {
        this.data.connection.search(searchBase, filter, this.meta.getRowLimit(), this.data.attrReturned, this.meta.getSearchScope());
    }

    private Object[] buildEmptyRow() {
        Object[] rowData = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
        return rowData;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (LDAPInputMeta)smi;
        this.data = (LDAPInputData)sdi;
        if (super.init(smi, sdi)) {
            this.data.rownr = 1L;
            this.data.multi_valuedFieldSeparator = this.environmentSubstitute(this.meta.getMultiValuedSeparator());
            this.data.nrfields = this.meta.getInputFields().length;
            this.data.staticFilter = this.environmentSubstitute(this.meta.getFilterString());
            this.data.staticSearchBase = this.environmentSubstitute(this.meta.getSearchBase());
            this.data.dynamic = this.meta.isDynamicSearch() || this.meta.isDynamicFilter();
            try {
                this.connectServerLdap();
                return true;
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"LDAPInput.ErrorInit", (String[])new String[]{e.toString()}));
                this.stopAll();
                this.setErrors(1L);
            }
        }
        return false;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (LDAPInputMeta)smi;
        this.data = (LDAPInputData)sdi;
        if (this.data.connection != null) {
            try {
                this.data.connection.close();
            }
            catch (KettleException e) {
                this.logError(BaseMessages.getString(PKG, (String)"LDAPInput.Exception.ErrorDisconecting", (String[])new String[]{e.toString()}));
            }
        }
        this.data.attributesBinary = null;
        super.dispose(smi, sdi);
    }
}

