/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.schema;

import org.pentaho.di.core.changed.ChangedFlagInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.pms.messages.Messages;
import org.pentaho.pms.schema.PhysicalColumn;
import org.pentaho.pms.schema.concept.ConceptInterface;
import org.pentaho.pms.schema.concept.ConceptUtilityBase;
import org.pentaho.pms.schema.concept.ConceptUtilityInterface;
import org.pentaho.pms.util.ObjectAlreadyExistsException;
import org.pentaho.pms.util.UniqueArrayList;
import org.pentaho.pms.util.UniqueList;

public class PhysicalTable
extends ConceptUtilityBase
implements Cloneable,
ChangedFlagInterface,
ConceptUtilityInterface {
    private DatabaseMeta databaseMeta;
    private UniqueList<PhysicalColumn> physicalColumns;

    public PhysicalTable(String id, String targetSchema, String targetTable, DatabaseMeta databaseMeta, UniqueList<PhysicalColumn> columns) {
        super(id);
        this.databaseMeta = databaseMeta;
        this.physicalColumns = columns;
        if (targetSchema != null) {
            this.setTargetSchema(targetSchema);
        }
        this.setTargetTable(targetTable);
    }

    public PhysicalTable() {
        this(null, null, null, null, new UniqueArrayList<PhysicalColumn>());
    }

    public PhysicalTable(String id) {
        this(id, null, null, null, new UniqueArrayList<PhysicalColumn>());
    }

    @Override
    public String getModelElementDescription() {
        return Messages.getString("PhysicalTable.USER_DESCRIPTION");
    }

    public Object clone() {
        try {
            PhysicalTable retval = (PhysicalTable)super.clone();
            retval.setConcept((ConceptInterface)this.getConcept().clone());
            retval.setPhysicalColumns(new UniqueArrayList<PhysicalColumn>());
            for (int i = 0; i < this.nrPhysicalColumns(); ++i) {
                PhysicalColumn physicalColumn = this.getPhysicalColumn(i);
                try {
                    retval.addPhysicalColumn((PhysicalColumn)physicalColumn.clone());
                    continue;
                }
                catch (ObjectAlreadyExistsException e) {
                    throw new RuntimeException(e);
                }
            }
            retval.setDatabaseMeta(this.databaseMeta);
            return retval;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public void setDatabaseMeta(DatabaseMeta databaseMeta) {
        this.databaseMeta = databaseMeta;
    }

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setPhysicalColumns(UniqueList<PhysicalColumn> physicalColumns) {
        this.physicalColumns = physicalColumns;
        this.setChanged();
    }

    public UniqueList<PhysicalColumn> getPhysicalColumns() {
        return this.physicalColumns;
    }

    public PhysicalColumn getPhysicalColumn(int i) {
        return this.physicalColumns.get(i);
    }

    public void addPhysicalColumn(PhysicalColumn column) throws ObjectAlreadyExistsException {
        this.physicalColumns.add(column);
        this.setChanged();
    }

    public void addPhysicalColumn(int i, PhysicalColumn column) throws ObjectAlreadyExistsException {
        this.physicalColumns.add(i, column);
        this.setChanged();
    }

    public int findPhysicalColumnNr(String columnName) {
        for (int i = 0; i < this.physicalColumns.size(); ++i) {
            if (!this.getPhysicalColumn(i).getId().equalsIgnoreCase(columnName)) continue;
            return i;
        }
        return -1;
    }

    public PhysicalColumn findPhysicalColumn(String columnId) {
        int idx = this.findPhysicalColumnNr(columnId);
        if (idx >= 0) {
            return this.getPhysicalColumn(idx);
        }
        return null;
    }

    public PhysicalColumn findPhysicalColumn(String locale, String columnName) {
        for (int i = 0; i < this.nrPhysicalColumns(); ++i) {
            PhysicalColumn physicalColumn = this.getPhysicalColumn(i);
            if (!columnName.equalsIgnoreCase(physicalColumn.getConcept().getName(locale))) continue;
            return physicalColumn;
        }
        return this.findPhysicalColumn(columnName);
    }

    public int indexOfPhysicalColumn(PhysicalColumn f) {
        return this.physicalColumns.indexOf(f);
    }

    public void removePhysicalColumn(int i) {
        this.physicalColumns.remove(i);
        this.setChanged();
    }

    public void removeAllPhysicalColumns() {
        this.physicalColumns.clear();
        this.setChanged();
    }

    public int nrPhysicalColumns() {
        return this.physicalColumns.size();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        if (this.databaseMeta != null) {
            return this.databaseMeta.getName() + "-->" + this.getId();
        }
        return this.getId();
    }

    public String[] getColumnIDs() {
        String[] ids = new String[this.nrPhysicalColumns()];
        for (int i = 0; i < this.nrPhysicalColumns(); ++i) {
            ids[i] = this.getPhysicalColumn(i).getId();
        }
        return ids;
    }

    public String[] getColumnNames(String locale) {
        String[] names = new String[this.nrPhysicalColumns()];
        for (int i = 0; i < this.nrPhysicalColumns(); ++i) {
            names[i] = this.getPhysicalColumn(i).getDisplayName(locale);
        }
        return names;
    }

    @Override
    public void clearChanged() {
        super.clearChanged();
        for (int i = 0; i < this.nrPhysicalColumns(); ++i) {
            this.getPhysicalColumn(i).clearChanged();
        }
    }
}

