/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.model.olap;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.metadata.model.LogicalTable;
import org.pentaho.metadata.model.olap.OlapCalculatedMember;
import org.pentaho.metadata.model.olap.OlapDimensionUsage;
import org.pentaho.metadata.model.olap.OlapMeasure;

public class OlapCube
implements Cloneable,
Serializable {
    private String name;
    private LogicalTable logicalTable;
    private List<OlapDimensionUsage> olapDimensionUsages = new ArrayList<OlapDimensionUsage>();
    private List<OlapMeasure> olapMeasures = new ArrayList<OlapMeasure>();
    private List<OlapCalculatedMember> olapCalculatedMembers = new ArrayList<OlapCalculatedMember>();

    public Object clone() {
        int i;
        OlapCube olapCube = new OlapCube();
        olapCube.name = this.name;
        for (i = 0; i < this.olapDimensionUsages.size(); ++i) {
            OlapDimensionUsage usage = this.olapDimensionUsages.get(i);
            olapCube.olapDimensionUsages.add((OlapDimensionUsage)usage.clone());
        }
        for (i = 0; i < this.olapMeasures.size(); ++i) {
            OlapMeasure measure = this.olapMeasures.get(i);
            olapCube.olapMeasures.add((OlapMeasure)measure.clone());
        }
        for (i = 0; i < this.olapCalculatedMembers.size(); ++i) {
            OlapCalculatedMember cm = this.olapCalculatedMembers.get(i);
            olapCube.olapCalculatedMembers.add((OlapCalculatedMember)cm.clone());
        }
        if (this.logicalTable != null) {
            olapCube.logicalTable = this.logicalTable;
        }
        return olapCube;
    }

    public boolean equals(Object obj) {
        return this.name.equals(((OlapCube)obj).getName());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LogicalTable getLogicalTable() {
        return this.logicalTable;
    }

    public void setLogicalTable(LogicalTable logicalTable) {
        this.logicalTable = logicalTable;
    }

    public List<OlapDimensionUsage> getOlapDimensionUsages() {
        return this.olapDimensionUsages;
    }

    public void setOlapDimensionUsages(List<OlapDimensionUsage> olapDimensionUsages) {
        this.olapDimensionUsages = olapDimensionUsages;
    }

    public List<OlapMeasure> getOlapMeasures() {
        return this.olapMeasures;
    }

    public void setOlapMeasures(List<OlapMeasure> olapMeasures) {
        this.olapMeasures = olapMeasures;
    }

    public OlapMeasure findOlapMeasure(String measureName) {
        for (int i = 0; i < this.olapMeasures.size(); ++i) {
            OlapMeasure olapMeasure = this.olapMeasures.get(i);
            if (!olapMeasure.getName().equals(measureName)) continue;
            return olapMeasure;
        }
        return null;
    }

    public String[] getUnusedColumnNames(String locale) {
        List<String> names = this.logicalTable.getColumnNames(locale);
        for (int i = names.size() - 1; i >= 0; --i) {
            String columnName = names.get(i);
            for (int m = 0; m < this.olapMeasures.size(); ++m) {
                OlapMeasure measure = this.olapMeasures.get(m);
                if (!measure.getLogicalColumn().getName(locale).equals(columnName)) continue;
                names.remove(i);
            }
        }
        return names.toArray(new String[names.size()]);
    }

    public List<OlapCalculatedMember> getOlapCalculatedMembers() {
        return this.olapCalculatedMembers;
    }

    public void setOlapCalculatedMembers(List<OlapCalculatedMember> olapCalculatedMembers) {
        this.olapCalculatedMembers = olapCalculatedMembers;
    }
}

