/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.model;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.metadata.model.IPhysicalTable;
import org.pentaho.metadata.model.LogicalColumn;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.model.concept.Concept;
import org.pentaho.metadata.model.concept.IConcept;

public class LogicalTable
extends Concept {
    private static final long serialVersionUID = -2655375483724689568L;
    private List<LogicalColumn> logicalColumns = new ArrayList<LogicalColumn>();
    private static final String CLASS_ID = "LogicalTable";

    public LogicalTable() {
    }

    public LogicalTable(LogicalModel logicalModel, IPhysicalTable physicalTable) {
        this.setParent(logicalModel);
        this.setPhysicalConcept(physicalTable);
    }

    @Override
    public List<IConcept> getChildren() {
        ArrayList<IConcept> children = new ArrayList<IConcept>();
        children.addAll(this.logicalColumns);
        return children;
    }

    @Override
    public List<String> getUniqueId() {
        ArrayList<String> uid = new ArrayList<String>(this.getParent().getUniqueId());
        uid.add(CLASS_ID.concat("-") + this.getId());
        return uid;
    }

    public void setLogicalModel(LogicalModel logicalModel) {
        this.setParent(logicalModel);
    }

    public LogicalModel getLogicalModel() {
        return (LogicalModel)this.getParent();
    }

    public IPhysicalTable getPhysicalTable() {
        return (IPhysicalTable)this.getPhysicalConcept();
    }

    public void setPhysicalTable(IPhysicalTable physicalTable) {
        this.setPhysicalConcept(physicalTable);
    }

    public List<LogicalColumn> getLogicalColumns() {
        return this.logicalColumns;
    }

    public List<String> getColumnNames(String locale) {
        ArrayList<String> list = new ArrayList<String>();
        for (LogicalColumn column : this.logicalColumns) {
            list.add(column.getName(locale));
        }
        return list;
    }

    public void setLogicalColumns(List<LogicalColumn> columns) {
        this.logicalColumns = columns;
    }

    public void addLogicalColumn(LogicalColumn column) {
        this.logicalColumns.add(column);
    }

    @Override
    public IConcept getInheritedConcept() {
        return this.getPhysicalTable();
    }

    @Override
    public IConcept getSecurityParentConcept() {
        return this.getLogicalModel();
    }

    public LogicalColumn findLogicalColumn(String id) {
        for (LogicalColumn col : this.logicalColumns) {
            if (!id.equals(col.getId())) continue;
            return col;
        }
        return null;
    }

    public boolean equals(Object obj) {
        LogicalTable other = (LogicalTable)obj;
        return other.getId().equals(this.getId());
    }

    @Override
    public Object clone() {
        LogicalTable clone = new LogicalTable();
        this.clone(clone);
        clone.setParent(this.getParent());
        clone.setPhysicalConcept(this.getPhysicalConcept());
        clone.setLogicalColumns(new ArrayList<LogicalColumn>());
        for (LogicalColumn col : this.logicalColumns) {
            clone.addLogicalColumn(col);
        }
        return clone;
    }
}

