/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.automodel;

import java.util.ArrayList;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.database.DatabaseMetaInformation;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.logging.LoggingObject;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.metadata.automodel.AutoModeler;
import org.pentaho.metadata.automodel.SchemaTable;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.model.LogicalColumn;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.model.LogicalRelationship;
import org.pentaho.metadata.model.LogicalTable;
import org.pentaho.pms.core.exception.PentahoMetadataException;

public class AutoModelerScenario {
    public AutoModelerScenario() throws KettleDatabaseException, PentahoMetadataException {
        String databaseType = "MySQL";
        String hostname = "localhost";
        String port = "3306";
        String databaseName = "test";
        String username = "matt";
        String password = "abcd";
        DatabaseMeta databaseMeta = new DatabaseMeta(databaseName, databaseType, "JDBC", hostname, databaseName, port, username, password);
        DatabaseMetaInformation dmi = new DatabaseMetaInformation(databaseMeta);
        dmi.getData((LoggingObjectInterface)new LoggingObject((Object)"Auto Modeler"), null);
        String schemaName = dmi.getSchemas()[0].getSchemaName();
        String[] tableNames = dmi.getSchemas()[0].getItems();
        SchemaTable[] schemaTables = new SchemaTable[]{new SchemaTable("dwh", "d_customer"), new SchemaTable("dwh", "d_product"), new SchemaTable("dwh", "d_date"), new SchemaTable("dwh", "f_orderlines")};
        AutoModeler modeler = new AutoModeler("en_US", "Orders", databaseMeta, schemaTables);
        Domain domain = modeler.generateDomain();
        LogicalModel model = domain.getLogicalModels().get(0);
        for (int i = 0; i < model.getLogicalTables().size(); ++i) {
            LogicalTable leftTable = model.getLogicalTables().get(i);
            ArrayList<LogicalTable> tables = new ArrayList<LogicalTable>();
            for (int t = 0; t < model.getLogicalTables().size(); ++t) {
                LogicalTable table = model.getLogicalTables().get(t);
                if (leftTable == table) continue;
                tables.add(table);
            }
            LogicalTable rightTable = (LogicalTable)tables.get(0);
            LogicalColumn leftColumn = leftTable.getLogicalColumns().get(0);
            LogicalColumn rightColumn = rightTable.getLogicalColumns().get(0);
            model.addLogicalRelationship(new LogicalRelationship(model, leftTable, rightTable, leftColumn, rightColumn));
        }
    }
}

