/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.baserver.utils.web;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.pentaho.di.baserver.utils.web.ServletOutputStreamWrapper;

public class InternalHttpServletResponse
implements HttpServletResponse {
    private static final String CHARSET_PREFIX = "charset=";
    private final ByteArrayOutputStream content;
    private final ServletOutputStreamWrapper servletOutputStream;
    private String characterEncoding = null;
    private PrintWriter writer;
    private int contentLength = 0;
    private String contentType;
    private int bufferSize = 4096;
    private boolean committed;
    private int status = 204;
    private String errorMessage;
    private String redirectedUrl;
    private String forwardedUrl;
    private String includedUrl;

    public InternalHttpServletResponse(ByteArrayOutputStream outputStream) {
        this.content = outputStream;
        this.servletOutputStream = new ServletOutputStreamWrapper(this.content);
        this.writer = new PrintWriter(this.content);
    }

    public InternalHttpServletResponse() {
        this(new ByteArrayOutputStream());
    }

    public boolean isOutputStreamAccessAllowed() {
        return true;
    }

    public boolean isWriterAccessAllowed() {
        return true;
    }

    public ServletOutputStream getOutputStream() {
        if (!this.isOutputStreamAccessAllowed()) {
            throw new IllegalStateException("OutputStream access not allowed");
        }
        return this.servletOutputStream;
    }

    public PrintWriter getWriter() throws UnsupportedEncodingException {
        if (!this.isWriterAccessAllowed()) {
            throw new IllegalStateException("Writer access not allowed");
        }
        return this.writer;
    }

    public byte[] getContentAsByteArray() {
        this.flushBuffer();
        return this.content.toByteArray();
    }

    public String getContentAsString() throws UnsupportedEncodingException {
        this.flushBuffer();
        return this.characterEncoding != null ? this.content.toString(this.characterEncoding) : this.content.toString();
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }

    public String getCharacterEncoding() {
        return null;
    }

    public void setCharacterEncoding(String s) {
    }

    public String getHeader(String name) {
        return "";
    }

    public Collection<String> getHeaders(String name) {
        return null;
    }

    public Collection<String> getHeaderNames() {
        return null;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        int charsetIndex;
        this.contentType = contentType;
        if (contentType != null && (charsetIndex = contentType.toLowerCase().indexOf(CHARSET_PREFIX)) != -1) {
            String encoding = contentType.substring(charsetIndex + CHARSET_PREFIX.length());
            this.setCharacterEncoding(encoding);
        }
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void flushBuffer() {
        if (this.writer != null) {
            this.writer.flush();
        }
        if (this.servletOutputStream != null) {
            try {
                this.servletOutputStream.flush();
            }
            catch (IOException ex) {
                throw new IllegalStateException("Could not flush OutputStream: " + ex.getMessage());
            }
        }
        this.committed = true;
    }

    public void resetBuffer() {
        if (this.committed) {
            throw new IllegalStateException("Cannot reset buffer - response is already committed");
        }
        this.content.reset();
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public void reset() {
        this.resetBuffer();
        this.characterEncoding = null;
        this.contentLength = 0;
        this.contentType = null;
        this.status = 200;
        this.errorMessage = null;
    }

    public Locale getLocale() {
        return null;
    }

    public void setLocale(Locale locale) {
    }

    public void sendError(int status, String errorMessage) throws IOException {
        if (this.committed) {
            throw new IllegalStateException("Cannot set error status - response is already committed");
        }
        this.status = status;
        this.errorMessage = errorMessage;
        this.committed = true;
    }

    public void sendError(int status) throws IOException {
        if (this.committed) {
            throw new IllegalStateException("Cannot set error status - response is already committed");
        }
        this.status = status;
        this.committed = true;
    }

    public void sendRedirect(String url) throws IOException {
        if (this.committed) {
            throw new IllegalStateException("Cannot send redirect - response is already committed");
        }
        this.redirectedUrl = url;
        this.committed = true;
    }

    public void setDateHeader(String s, long l) {
    }

    public void addDateHeader(String s, long l) {
    }

    public void setHeader(String s, String s2) {
    }

    public void addHeader(String s, String s2) {
    }

    public void setIntHeader(String s, int i) {
    }

    public void addIntHeader(String s, int i) {
    }

    public void setStatus(int status, String errorMessage) {
        this.status = status;
        this.errorMessage = errorMessage;
    }

    public void addCookie(Cookie cookie) {
    }

    public boolean containsHeader(String s) {
        return false;
    }

    public String encodeURL(String url) {
        return url;
    }

    public String encodeRedirectURL(String url) {
        return url;
    }

    public String encodeUrl(String url) {
        return url;
    }

    public String encodeRedirectUrl(String url) {
        return url;
    }

    public String getRedirectedUrl() {
        return this.redirectedUrl;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getForwardedUrl() {
        return this.forwardedUrl;
    }

    public void setForwardedUrl(String forwardedUrl) {
        this.forwardedUrl = forwardedUrl;
    }

    public String getIncludedUrl() {
        return this.includedUrl;
    }

    public void setIncludedUrl(String includedUrl) {
        this.includedUrl = includedUrl;
    }
}

