/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.baserver.utils.web;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.pentaho.di.baserver.utils.web.Http;
import org.pentaho.di.baserver.utils.web.HttpParameter;
import org.pentaho.di.baserver.utils.web.InternalHttpServletRequest;
import org.pentaho.di.baserver.utils.web.InternalHttpServletResponse;
import org.pentaho.di.baserver.utils.web.Response;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.util.HttpClientManager;
import org.pentaho.di.core.util.HttpClientUtil;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.web.servlet.JAXRSPluginServlet;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.web.context.request.RequestContextListener;

public class HttpConnectionHelper {
    public static final String UTF_8 = "UTF-8";
    public static final String APPLICATION_FORM_ENCODED = "application/x-www-form-urlencoded";
    public static final String CONTENT_TYPE = "Content-Type";
    private static final Log logger = LogFactory.getLog(HttpConnectionHelper.class);
    private static HttpConnectionHelper _instance = new HttpConnectionHelper();

    public static HttpConnectionHelper getInstance() {
        return _instance;
    }

    public Response invokeEndpoint(String serverUrl, String userName, String password, String moduleName, String endpointPath, String httpMethod, List<HttpParameter> httpParameters) {
        Response response = new Response();
        String requestUrl = serverUrl.endsWith("/") ? serverUrl : serverUrl + "/";
        requestUrl = moduleName.equals("platform") ? requestUrl + "api" : requestUrl + "plugin/" + moduleName + "/api";
        requestUrl = endpointPath.startsWith("/") ? requestUrl + endpointPath : requestUrl + "/" + endpointPath;
        logger.info((Object)("requestUrl = " + requestUrl));
        try {
            response = this.callHttp(requestUrl, httpParameters, httpMethod, userName, password);
        }
        catch (IOException ex) {
            logger.error((Object)"Failed ", (Throwable)ex);
        }
        catch (KettleStepException ex) {
            logger.error((Object)"Failed ", (Throwable)ex);
        }
        return response;
    }

    public Response invokeEndpoint(String moduleName, String endpointPath, String httpMethod, List<HttpParameter> httpParameters) {
        if (moduleName.equals("platform")) {
            return this.invokePlatformEndpoint(endpointPath, httpMethod, httpParameters);
        }
        return this.invokePluginEndpoint(moduleName, endpointPath, httpMethod, httpParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Response invokePlatformEndpoint(String endpointPath, String httpMethod, List<HttpParameter> httpParameters) {
        Response response = new Response();
        ServletContext servletContext = null;
        RequestDispatcher requestDispatcher = null;
        try {
            Object context = this.getContext();
            if (context instanceof ServletContext) {
                servletContext = (ServletContext)context;
                requestDispatcher = servletContext.getRequestDispatcher("/api" + endpointPath);
            }
        }
        catch (NoClassDefFoundError ex) {
            logger.error((Object)"Failed to get application servlet context", (Throwable)ex);
            return response;
        }
        if (requestDispatcher != null) {
            URL fullyQualifiedServerURL;
            try {
                fullyQualifiedServerURL = this.getUrl();
            }
            catch (MalformedURLException e) {
                logger.error((Object)"FullyQualifiedServerURL is incorrect");
                return response;
            }
            InternalHttpServletRequest servletRequest = new InternalHttpServletRequest(httpMethod, fullyQualifiedServerURL, "/api", endpointPath);
            servletRequest.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", DispatcherType.FORWARD);
            try {
                this.insertParameters(httpMethod, httpParameters, servletRequest);
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Object)"Can't encode parameters");
                return response;
            }
            ServletRequestEvent servletRequestEvent = new ServletRequestEvent(servletContext, (ServletRequest)servletRequest);
            RequestContextListener requestContextListener = new RequestContextListener();
            requestContextListener.requestInitialized(servletRequestEvent);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            InternalHttpServletResponse servletResponse = new InternalHttpServletResponse(outputStream);
            try {
                long startTime = System.currentTimeMillis();
                requestDispatcher.forward((ServletRequest)servletRequest, (ServletResponse)servletResponse);
                long responseTime = System.currentTimeMillis() - startTime;
                response.setStatusCode(servletResponse.getStatus());
                response.setResult(servletResponse.getContentAsString());
                response.setResponseTime(responseTime);
            }
            catch (ServletException ex) {
                logger.error((Object)"Failed ", (Throwable)ex);
                Response response2 = response;
                return response2;
            }
            catch (IOException ex) {
                logger.error((Object)"Failed ", (Throwable)ex);
                Response response3 = response;
                return response3;
            }
            finally {
                requestContextListener.requestDestroyed(servletRequestEvent);
            }
        }
        return response;
    }

    protected void insertParameters(String httpMethod, List<HttpParameter> httpParameters, InternalHttpServletRequest servletRequest) throws UnsupportedEncodingException {
        Http method = Http.getHttpMethod(httpMethod);
        switch (method) {
            case POST: 
            case PUT: 
            case DELETE: {
                List queryParameters = httpParameters.stream().filter(param -> param.getParamType() == HttpParameter.ParamType.QUERY).collect(Collectors.toList());
                for (HttpParameter parameter : queryParameters) {
                    String value = parameter.getValue() != null ? URLEncoder.encode(parameter.getValue(), UTF_8) : null;
                    String name = parameter.getName() != null ? URLEncoder.encode(parameter.getName(), UTF_8) : null;
                    servletRequest.setParameter(name, value);
                }
                servletRequest.setContentType(APPLICATION_FORM_ENCODED);
                servletRequest.putHeader(CONTENT_TYPE, APPLICATION_FORM_ENCODED);
                String bodyQuery = this.constructQueryString(httpParameters, true, HttpParameter.ParamType.BODY, HttpParameter.ParamType.NONE);
                servletRequest.setContent(bodyQuery.getBytes(UTF_8));
                break;
            }
            default: {
                for (HttpParameter parameter : httpParameters) {
                    String value = parameter.getValue() != null ? URLEncoder.encode(parameter.getValue(), UTF_8) : null;
                    String name = parameter.getName() != null ? URLEncoder.encode(parameter.getName(), UTF_8) : null;
                    servletRequest.setParameter(name, value);
                }
            }
        }
    }

    protected URL getUrl() throws MalformedURLException {
        return new URL(this.getFullyQualifiedServerURL());
    }

    protected String getFullyQualifiedServerURL() {
        return PentahoSystem.getApplicationContext().getFullyQualifiedServerURL();
    }

    protected Object getContext() {
        return PentahoSystem.getApplicationContext().getContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Response invokePluginEndpoint(String pluginName, String endpointPath, String httpMethod, List<HttpParameter> httpParameters) {
        URL fullyQualifiedServerURL;
        Response response = new Response();
        response.setStatusCode(404);
        response.setResponseTime(0L);
        IPluginManager pluginManager = this.getPluginManager();
        if (pluginManager == null) {
            logger.error((Object)"Failed to get plugin manager");
            return response;
        }
        ClassLoader classLoader = this.getPluginClassLoader(pluginName, pluginManager);
        if (classLoader == null) {
            logger.error((Object)("No such plugin: " + pluginName));
            return response;
        }
        ListableBeanFactory beanFactory = this.getListableBeanFactory(pluginName, pluginManager);
        if (beanFactory == null || !beanFactory.containsBean("api")) {
            logger.error((Object)("Bean not found for plugin: " + pluginName));
            return response;
        }
        JAXRSPluginServlet pluginServlet = this.getJAXRSPluginServlet(beanFactory);
        try {
            fullyQualifiedServerURL = this.getUrl();
        }
        catch (MalformedURLException e) {
            logger.error((Object)"FullyQualifiedServerURL is incorrect");
            return response;
        }
        InternalHttpServletRequest servletRequest = new InternalHttpServletRequest(httpMethod, fullyQualifiedServerURL, "/plugin", "/" + pluginName + "/api" + endpointPath);
        try {
            this.insertParameters(httpMethod, httpParameters, servletRequest);
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"Can't encode parameters");
            return response;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        InternalHttpServletResponse servletResponse = new InternalHttpServletResponse(outputStream);
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            long startTime = System.currentTimeMillis();
            Thread.currentThread().setContextClassLoader(classLoader);
            pluginServlet.service((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse);
            long responseTime = System.currentTimeMillis() - startTime;
            response.setStatusCode(servletResponse.getStatus());
            response.setResult(servletResponse.getContentAsString());
            response.setResponseTime(responseTime);
        }
        catch (ServletException ex) {
            logger.error((Object)"Failed ", (Throwable)ex);
            Response response2 = response;
            return response2;
        }
        catch (IOException ex) {
            logger.error((Object)"Failed ", (Throwable)ex);
            Response response3 = response;
            return response3;
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
        return response;
    }

    protected JAXRSPluginServlet getJAXRSPluginServlet(ListableBeanFactory beanFactory) {
        return (JAXRSPluginServlet)beanFactory.getBean("api", JAXRSPluginServlet.class);
    }

    protected ListableBeanFactory getListableBeanFactory(String pluginName, IPluginManager pluginManager) {
        return pluginManager.getBeanFactory(pluginName);
    }

    protected ClassLoader getPluginClassLoader(String pluginName, IPluginManager pluginManager) {
        return pluginManager.getClassLoader(pluginName);
    }

    protected IPluginManager getPluginManager() {
        return (IPluginManager)PentahoSystem.get(IPluginManager.class);
    }

    public Response callHttp(String url, List<HttpParameter> httpParameters, String httpMethod, String user, String password) throws IOException, KettleStepException {
        int status;
        long startTime = System.currentTimeMillis();
        HttpClient httpclient = this.getHttpClient(user, password);
        HttpRequestBase method = this.getHttpMethod(url, httpParameters, httpMethod);
        HttpResponse httpResponse = null;
        try {
            httpResponse = httpclient.execute((HttpUriRequest)method);
            status = httpResponse.getStatusLine().getStatusCode();
        }
        catch (IllegalArgumentException ex) {
            status = -1;
        }
        Response response = new Response();
        if (status != -1) {
            String contentType;
            String encoding = UTF_8;
            Header[] contentTypeHeader = method.getHeaders(CONTENT_TYPE);
            if (contentTypeHeader != null && contentTypeHeader.length != 0 && (contentType = contentTypeHeader[0].getValue()) != null && contentType.contains("charset")) {
                encoding = contentType.replaceFirst("^.*;\\s*charset\\s*=\\s*", "").replace("\"", "").trim();
            }
            String body = HttpClientUtil.responseToString((HttpResponse)httpResponse, (Charset)Charset.forName(encoding));
            long responseTime = System.currentTimeMillis() - startTime;
            response.setStatusCode(status);
            response.setResult(body);
            response.setResponseTime(responseTime);
        }
        return response;
    }

    protected Credentials getCredentials(String user, String password) {
        return new UsernamePasswordCredentials(user, password);
    }

    protected HttpRequestBase getHttpMethod(String url, List<HttpParameter> httpParameters, String httpMethod) {
        Http method = Http.getHttpMethod(httpMethod);
        switch (method) {
            case GET: {
                return new HttpGet(url + this.constructQueryString(httpParameters, false, new HttpParameter.ParamType[0]));
            }
            case POST: {
                HttpPost postMethod = new HttpPost(url + this.constructQueryString(httpParameters, false, HttpParameter.ParamType.QUERY));
                this.setRequestEntity((HttpRequestBase)postMethod, httpParameters, HttpParameter.ParamType.BODY, HttpParameter.ParamType.NONE);
                return postMethod;
            }
            case PUT: {
                HttpPut putMethod = new HttpPut(url + this.constructQueryString(httpParameters, false, HttpParameter.ParamType.QUERY));
                this.setRequestEntity((HttpRequestBase)putMethod, httpParameters, HttpParameter.ParamType.BODY, HttpParameter.ParamType.NONE);
                return putMethod;
            }
            case DELETE: {
                return new HttpDelete(url + this.constructQueryString(httpParameters, false, new HttpParameter.ParamType[0]));
            }
            case HEAD: {
                return new HttpHead(url + this.constructQueryString(httpParameters, false, new HttpParameter.ParamType[0]));
            }
            case OPTIONS: {
                return new HttpOptions(url + this.constructQueryString(httpParameters, false, new HttpParameter.ParamType[0]));
            }
        }
        return new HttpGet(url + this.constructQueryString(httpParameters, false, new HttpParameter.ParamType[0]));
    }

    private void setRequestEntity(HttpRequestBase method, List<HttpParameter> httpParameters, HttpParameter.ParamType ... paramTypes) {
        try {
            String queryString = this.constructQueryString(httpParameters, true, paramTypes);
            StringEntity requestEntity = new StringEntity(queryString, ContentType.APPLICATION_FORM_URLENCODED);
            if (method instanceof HttpEntityEnclosingRequestBase) {
                HttpEntityEnclosingRequestBase httpEntityEnclosingRequestBase = (HttpEntityEnclosingRequestBase)method;
                httpEntityEnclosingRequestBase.setEntity((HttpEntity)requestEntity);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed", (Throwable)e);
        }
    }

    private String constructQueryString(List<HttpParameter> httpParameters, boolean escapeFirstCh, HttpParameter.ParamType ... paramTypes) {
        StringBuilder queryString = new StringBuilder();
        if (httpParameters != null && !httpParameters.isEmpty()) {
            List<HttpParameter.ParamType> acceptableParamTypes = Arrays.asList(paramTypes);
            if (!acceptableParamTypes.isEmpty()) {
                httpParameters = httpParameters.stream().filter(param -> acceptableParamTypes.contains((Object)param.getParamType())).collect(Collectors.toList());
            }
            if (!httpParameters.isEmpty()) {
                try {
                    boolean first = true;
                    for (HttpParameter param2 : httpParameters) {
                        if (first) {
                            queryString.append("?");
                            first = false;
                        } else {
                            queryString.append("&");
                        }
                        String name = param2.getName() != null ? param2.getName() : "";
                        String value = param2.getValue();
                        if (value != null) {
                            queryString.append(URLEncoder.encode(name, UTF_8)).append("=").append(URLEncoder.encode(value, UTF_8));
                            continue;
                        }
                        queryString.append(URLEncoder.encode(name, UTF_8));
                    }
                }
                catch (UnsupportedEncodingException e) {
                    logger.error((Object)"Failed ", (Throwable)e);
                }
            }
        }
        String query = queryString.toString();
        if (escapeFirstCh && !query.isEmpty()) {
            query = query.substring(1);
        }
        return query;
    }

    HttpClient getHttpClient(String user, String password) {
        HttpClientManager.HttpClientBuilderFacade clientBuilder = HttpClientManager.getInstance().createBuilder();
        clientBuilder.setCredentials(user, password);
        return clientBuilder.build();
    }
}

