/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.baserver.utils;

import java.util.List;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.baserver.utils.GetSessionVariableData;
import org.pentaho.di.baserver.utils.GetSessionVariableDialog;
import org.pentaho.di.baserver.utils.GetSessionVariableStep;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@Step(id="GetSessionVariableStep", name="GetSessionVariableMeta.Name", image="icons/getsessionvariable.svg", description="GetSessionVariableMeta.Description", i18nPackageName="pt.webdetails.di.baserverutils", categoryDescription="i18n:org.pentaho.di.trans.step:BaseStep.Category.BAServer", isSeparateClassLoaderNeeded=true, documentationUrl="https://pentaho-community.atlassian.net/wiki/display/EAI/Get+Session+Variables")
public class GetSessionVariableMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = GetSessionVariableMeta.class;
    private String[] fieldName;
    private String[] variableName;
    private int[] fieldType;
    private String[] fieldFormat;
    private int[] fieldLength;
    private int[] fieldPrecision;
    private String[] currency;
    private String[] decimal;
    private String[] group;
    private int[] trimType;
    private String[] defaultValue;

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new GetSessionVariableStep(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    public StepDataInterface getStepData() {
        return new GetSessionVariableData();
    }

    public StepDialogInterface getDialog(Shell shell, StepMetaInterface meta, TransMeta transMeta, String name) {
        return new GetSessionVariableDialog(shell, meta, transMeta, name);
    }

    public String[] getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String[] fieldName) {
        this.fieldName = fieldName;
    }

    public String[] getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String[] variableName) {
        this.variableName = variableName;
    }

    public int[] getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(int[] fieldType) {
        this.fieldType = fieldType;
    }

    public String[] getFieldFormat() {
        return this.fieldFormat;
    }

    public void setFieldFormat(String[] fieldFormat) {
        this.fieldFormat = fieldFormat;
    }

    public int[] getFieldLength() {
        return this.fieldLength;
    }

    public void setFieldLength(int[] fieldLength) {
        this.fieldLength = fieldLength;
    }

    public int[] getFieldPrecision() {
        return this.fieldPrecision;
    }

    public void setFieldPrecision(int[] fieldPrecision) {
        this.fieldPrecision = fieldPrecision;
    }

    public String[] getCurrency() {
        return this.currency;
    }

    public void setCurrency(String[] currency) {
        this.currency = currency;
    }

    public String[] getDecimal() {
        return this.decimal;
    }

    public void setDecimal(String[] decimal) {
        this.decimal = decimal;
    }

    public String[] getGroup() {
        return this.group;
    }

    public void setGroup(String[] group) {
        this.group = group;
    }

    public int[] getTrimType() {
        return this.trimType;
    }

    public void setTrimType(int[] trimType) {
        this.trimType = trimType;
    }

    public String[] getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String[] defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void allocate(int count) {
        this.fieldName = new String[count];
        this.variableName = new String[count];
        this.fieldType = new int[count];
        this.fieldFormat = new String[count];
        this.fieldLength = new int[count];
        this.fieldPrecision = new int[count];
        this.currency = new String[count];
        this.decimal = new String[count];
        this.group = new String[count];
        this.trimType = new int[count];
        this.defaultValue = new String[count];
    }

    public void setDefault() {
        this.allocate(0);
    }

    public Object clone() {
        GetSessionVariableMeta clone = (GetSessionVariableMeta)((Object)super.clone());
        int count = this.fieldName.length;
        clone.allocate(count);
        for (int i = 0; i < count; ++i) {
            clone.fieldName[i] = this.fieldName[i];
            clone.variableName[i] = this.variableName[i];
            clone.fieldType[i] = this.fieldType[i];
            clone.fieldFormat[i] = this.fieldFormat[i];
            clone.currency[i] = this.currency[i];
            clone.decimal[i] = this.decimal[i];
            clone.group[i] = this.group[i];
            clone.fieldLength[i] = this.fieldLength[i];
            clone.fieldPrecision[i] = this.fieldPrecision[i];
            clone.trimType[i] = this.trimType[i];
            clone.defaultValue[i] = this.defaultValue[i];
        }
        return clone;
    }

    public void getFields(RowMetaInterface inputRowMeta, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        int length = -1;
        for (int i = 0; i < this.fieldName.length; ++i) {
            String string;
            if (this.variableName[i] == null || (string = space.environmentSubstitute(this.variableName[i])).length() <= length) continue;
            length = string.length();
        }
        RowMeta row = new RowMeta();
        for (int i = 0; i < this.fieldName.length; ++i) {
            ValueMeta valueMeta = new ValueMeta(this.fieldName[i], this.fieldType[i]);
            if (this.fieldLength[i] < 0) {
                valueMeta.setLength(length);
            } else {
                valueMeta.setLength(this.fieldLength[i]);
            }
            if (this.fieldPrecision[i] >= 0) {
                valueMeta.setPrecision(this.fieldPrecision[i]);
            }
            valueMeta.setConversionMask(this.fieldFormat[i]);
            valueMeta.setGroupingSymbol(this.group[i]);
            valueMeta.setDecimalSymbol(this.decimal[i]);
            valueMeta.setCurrencySymbol(this.currency[i]);
            valueMeta.setTrimType(this.trimType[i]);
            valueMeta.setOrigin(name);
            row.addValueMeta((ValueMetaInterface)valueMeta);
        }
        inputRowMeta.mergeRowMeta((RowMetaInterface)row);
    }

    public String getXML() {
        StringBuffer xml = new StringBuffer(300);
        xml.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.fieldName.length; ++i) {
            if (this.fieldName[i] == null || this.fieldName[i].length() == 0) continue;
            xml.append("      <field>").append(Const.CR);
            xml.append("        ").append(XMLHandler.addTagValue((String)"name", (String)this.fieldName[i]));
            xml.append("        ").append(XMLHandler.addTagValue((String)"variable", (String)this.variableName[i]));
            xml.append("        ").append(XMLHandler.addTagValue((String)"type", (String)ValueMeta.getTypeDesc((int)this.fieldType[i])));
            xml.append("        ").append(XMLHandler.addTagValue((String)"format", (String)this.fieldFormat[i]));
            xml.append("        ").append(XMLHandler.addTagValue((String)"currency", (String)this.currency[i]));
            xml.append("        ").append(XMLHandler.addTagValue((String)"decimal", (String)this.decimal[i]));
            xml.append("        ").append(XMLHandler.addTagValue((String)"group", (String)this.group[i]));
            xml.append("        ").append(XMLHandler.addTagValue((String)"length", (int)this.fieldLength[i]));
            xml.append("        ").append(XMLHandler.addTagValue((String)"precision", (int)this.fieldPrecision[i]));
            xml.append("        ").append(XMLHandler.addTagValue((String)"trim_type", (String)ValueMeta.getTrimTypeCode((int)this.trimType[i])));
            xml.append("        ").append(XMLHandler.addTagValue((String)"default_value", (String)this.defaultValue[i]));
            xml.append("      </field>").append(Const.CR);
        }
        xml.append("    </fields>").append(Const.CR);
        return xml.toString();
    }

    public void loadXML(Node stepNode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        try {
            Node fields = XMLHandler.getSubNode((Node)stepNode, (String)"fields");
            int count = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(count);
            for (int i = 0; i < count; ++i) {
                Node fieldNode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.fieldName[i] = XMLHandler.getTagValue((Node)fieldNode, (String)"name");
                this.variableName[i] = XMLHandler.getTagValue((Node)fieldNode, (String)"variable");
                this.fieldType[i] = ValueMeta.getType((String)XMLHandler.getTagValue((Node)fieldNode, (String)"type"));
                this.fieldFormat[i] = XMLHandler.getTagValue((Node)fieldNode, (String)"format");
                this.currency[i] = XMLHandler.getTagValue((Node)fieldNode, (String)"currency");
                this.decimal[i] = XMLHandler.getTagValue((Node)fieldNode, (String)"decimal");
                this.group[i] = XMLHandler.getTagValue((Node)fieldNode, (String)"group");
                this.fieldLength[i] = Const.toInt((String)XMLHandler.getTagValue((Node)fieldNode, (String)"length"), (int)-1);
                this.fieldPrecision[i] = Const.toInt((String)XMLHandler.getTagValue((Node)fieldNode, (String)"precision"), (int)-1);
                this.trimType[i] = ValueMeta.getTrimTypeByCode((String)XMLHandler.getTagValue((Node)fieldNode, (String)"trim_type"));
                this.defaultValue[i] = XMLHandler.getTagValue((Node)fieldNode, (String)"default_value");
                if (this.fieldType[i] != 0) continue;
                this.fieldType[i] = 2;
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"GetSessionVariable.RuntimeError.UnableToReadXML", (String[])new String[0]), (Throwable)e);
        }
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            int count = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(count);
            for (int i = 0; i < count; ++i) {
                this.fieldName[i] = rep.getStepAttributeString(id_step, i, "field_name");
                this.variableName[i] = rep.getStepAttributeString(id_step, i, "field_variable");
                this.fieldType[i] = ValueMeta.getType((String)rep.getStepAttributeString(id_step, i, "field_type"));
                this.fieldFormat[i] = rep.getStepAttributeString(id_step, i, "field_format");
                this.currency[i] = rep.getStepAttributeString(id_step, i, "field_currency");
                this.decimal[i] = rep.getStepAttributeString(id_step, i, "field_decimal");
                this.group[i] = rep.getStepAttributeString(id_step, i, "field_group");
                this.fieldLength[i] = (int)rep.getStepAttributeInteger(id_step, i, "field_length");
                this.fieldPrecision[i] = (int)rep.getStepAttributeInteger(id_step, i, "field_precision");
                this.trimType[i] = ValueMeta.getTrimTypeByCode((String)rep.getStepAttributeString(id_step, i, "field_trim_type"));
                this.defaultValue[i] = rep.getStepAttributeString(id_step, i, "field_default_value");
                if (this.fieldType[i] != 0) continue;
                this.fieldType[i] = 2;
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"GetSessionVariable.RuntimeError.UnableToReadRepository", (String[])new String[0]), (Throwable)e);
        }
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            for (int i = 0; i < this.fieldName.length; ++i) {
                if (this.fieldName[i] == null || this.fieldName[i].length() == 0) continue;
                rep.saveStepAttribute(id_transformation, id_step, i, "field_name", this.fieldName[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_variable", this.variableName[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_type", ValueMeta.getTypeDesc((int)this.fieldType[i]));
                rep.saveStepAttribute(id_transformation, id_step, i, "field_format", this.fieldFormat[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_currency", this.currency[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_decimal", this.decimal[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_group", this.group[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_length", (long)this.fieldLength[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_precision", (long)this.fieldPrecision[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_trim_type", ValueMeta.getTrimTypeCode((int)this.trimType[i]));
                rep.saveStepAttribute(id_transformation, id_step, i, "field_default_value", this.defaultValue[i]);
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"GetSessionVariable.RuntimeError.UnableToSaveRepository", (String[])new String[]{"" + id_step}), (Throwable)e);
        }
    }

    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        int nrRemarks = remarks.size();
        for (int i = 0; i < this.fieldName.length; ++i) {
            if (!Const.isEmpty((String)this.variableName[i])) continue;
            remarks.add((CheckResultInterface)new CheckResult(4, BaseMessages.getString(PKG, (String)"GetSessionVariable.CheckResult.VariableNotSpecified", (String[])new String[]{this.fieldName[i]}), (CheckResultSourceInterface)stepMeta));
        }
        if (remarks.size() == nrRemarks) {
            remarks.add((CheckResultInterface)new CheckResult(1, BaseMessages.getString(PKG, (String)"GetSessionVariable.CheckResult.AllVariablesSpecified", (String[])new String[0]), (CheckResultSourceInterface)stepMeta));
        }
    }
}

