/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.baserver.utils;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.pentaho.di.baserver.utils.BAServerCommonDialog;
import org.pentaho.di.baserver.utils.GetSessionVariableMeta;
import org.pentaho.di.baserver.utils.widgets.TableViewBuilder;
import org.pentaho.di.core.Const;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.util.SwtSvgImageUtil;

public class GetSessionVariableDialog
extends BAServerCommonDialog<GetSessionVariableMeta> {
    private TableView wFields;

    public GetSessionVariableDialog(Shell parent, Object in, TransMeta transMeta, String name) {
        super(parent, (GetSessionVariableMeta)((Object)in), transMeta, name);
    }

    @Override
    protected String getTitleKey() {
        return "GetSessionVariableDialog.DialogTitle";
    }

    @Override
    protected void buildContent(Composite parent) {
        ColumnInfo fieldColumn = new ColumnInfo(BaseMessages.getString((Class)PKG, (String)"GetSessionVariableDialog.Column.FieldName", (String[])new String[0]), 1, false);
        ColumnInfo variableColumn = new ColumnInfo(BaseMessages.getString((Class)PKG, (String)"GetSessionVariableDialog.Column.VariableName", (String[])new String[0]), 1, false);
        variableColumn.setUsingVariables(true);
        ColumnInfo defaultValueColumn = new ColumnInfo(BaseMessages.getString((Class)PKG, (String)"GetSessionVariableDialog.Column.DefaultValue", (String[])new String[0]), 1, false);
        defaultValueColumn.setUsingVariables(true);
        defaultValueColumn.setToolTip(BaseMessages.getString((Class)PKG, (String)"GetSessionVariableDialog.Column.DefaultValue.Tooltip", (String[])new String[0]));
        this.wFields = (TableView)new TableViewBuilder(this.props, parent, variables).addColumnInfo(fieldColumn).addColumnInfo(variableColumn).addColumnInfo(defaultValueColumn).setTopPlacement(0).setBottomPlacement(100).setLeftPlacement(0).setRightPlacement(100).build();
        this.wFields.addModifyListener(this.changeListener);
    }

    @Override
    protected Image getImage() {
        return SwtSvgImageUtil.getImage((Display)this.shell.getDisplay(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)"icons/getsessionvariable.svg", (int)32, (int)32);
    }

    @Override
    protected void loadData(GetSessionVariableMeta meta) {
        super.loadData(meta);
        int metaFieldsLength = meta.getFieldName().length;
        this.wFields.table.removeAll();
        this.wFields.table.setItemCount(metaFieldsLength == 0 ? 1 : metaFieldsLength);
        for (int i = 0; i < metaFieldsLength; ++i) {
            TableItem item = this.wFields.table.getItem(i);
            int index = 0;
            item.setText(++index, Const.NVL((String)meta.getFieldName()[i], (String)""));
            item.setText(++index, Const.NVL((String)meta.getVariableName()[i], (String)""));
            item.setText(++index, Const.NVL((String)meta.getDefaultValue()[i], (String)""));
        }
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
    }

    @Override
    protected void saveData(GetSessionVariableMeta meta) {
        super.saveData(meta);
        int count = this.wFields.nrNonEmpty();
        meta.allocate(count);
        for (int i = 0; i < count; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            int index = 0;
            meta.getFieldName()[i] = item.getText(++index);
            meta.getVariableName()[i] = item.getText(++index);
            meta.getDefaultValue()[i] = item.getText(++index);
        }
    }

    @Override
    protected int getMinimumHeight() {
        return 391;
    }

    @Override
    protected int getMinimumWidth() {
        return 505;
    }
}

