/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.step.mqtt;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.ui.core.FormDataBuilder;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.widget.AuthComposite;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;

class MqttDialogSecurityLayout {
    private static final Class<?> PKG = MqttDialogSecurityLayout.class;
    private final PropsUI props;
    private final CTabFolder wTabFolder;
    private final ModifyListener lsMod;
    private final TransMeta transMeta;
    private final Map<String, String> sslConfig;
    private final boolean sslEnabled;
    private AuthComposite authComposite;
    private TableView sslTable;
    private Button wUseSSL;

    MqttDialogSecurityLayout(PropsUI props, CTabFolder wTabFolder, ModifyListener lsMod, TransMeta transMeta, Map<String, String> sslConfig, boolean sslEnabled) {
        Preconditions.checkNotNull((Object)props);
        Preconditions.checkNotNull((Object)wTabFolder);
        Preconditions.checkNotNull((Object)lsMod);
        Preconditions.checkNotNull((Object)transMeta);
        this.props = props;
        this.wTabFolder = wTabFolder;
        this.lsMod = lsMod;
        this.transMeta = transMeta;
        this.sslEnabled = sslEnabled;
        this.sslConfig = Optional.ofNullable(sslConfig).orElse(Collections.emptyMap());
    }

    Map<String, String> sslConfig() {
        return this.tableToMap(this.sslTable);
    }

    boolean useSsl() {
        return this.wUseSSL.getSelection();
    }

    void buildSecurityTab() {
        CTabItem wSecurityTab = new CTabItem(this.wTabFolder, 0, 1);
        wSecurityTab.setText(BaseMessages.getString(PKG, (String)"MQTTDialog.Security.Tab", (String[])new String[0]));
        Composite wSecurityComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wSecurityComp);
        FormLayout securityLayout = new FormLayout();
        securityLayout.marginHeight = 15;
        securityLayout.marginWidth = 15;
        wSecurityComp.setLayout((Layout)securityLayout);
        this.authComposite = new AuthComposite(wSecurityComp, 0, this.props, this.lsMod, this.transMeta, BaseMessages.getString(PKG, (String)"MQTTDialog.Security.Authentication", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MQTTDialog.Security.Username", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MQTTDialog.Security.Password", (String[])new String[0]));
        this.authComposite.setLayoutData((Object)new FormDataBuilder().fullWidth().result());
        this.wUseSSL = new Button(wSecurityComp, 32);
        this.wUseSSL.setText(BaseMessages.getString(PKG, (String)"MQTTDialog.Security.UseSSL", (String[])new String[0]));
        this.props.setLook((Control)this.wUseSSL);
        FormData fdUseSSL = new FormData();
        fdUseSSL.top = new FormAttachment((Control)this.authComposite, 15);
        fdUseSSL.left = new FormAttachment(0, 0);
        this.wUseSSL.setLayoutData((Object)fdUseSSL);
        this.wUseSSL.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean selection = ((Button)selectionEvent.getSource()).getSelection();
                MqttDialogSecurityLayout.this.sslTable.setEnabled(selection);
                ((MqttDialogSecurityLayout)MqttDialogSecurityLayout.this).sslTable.table.setEnabled(selection);
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                this.widgetSelected(selectionEvent);
            }
        });
        Label wlSSLProperties = new Label(wSecurityComp, 16384);
        wlSSLProperties.setText(BaseMessages.getString(PKG, (String)"MQTTDialog.Security.SSLProperties", (String[])new String[0]));
        this.props.setLook((Control)wlSSLProperties);
        FormData fdlSSLProperties = new FormData();
        fdlSSLProperties.top = new FormAttachment((Control)this.wUseSSL, 10);
        fdlSSLProperties.left = new FormAttachment(0, 0);
        wlSSLProperties.setLayoutData((Object)fdlSSLProperties);
        FormData fdSecurityComp = new FormData();
        fdSecurityComp.left = new FormAttachment(0, 0);
        fdSecurityComp.top = new FormAttachment(0, 0);
        fdSecurityComp.right = new FormAttachment(100, 0);
        fdSecurityComp.bottom = new FormAttachment(100, 0);
        wSecurityComp.setLayoutData((Object)fdSecurityComp);
        this.buildSSLTable(wSecurityComp, (Control)wlSSLProperties);
        wSecurityComp.layout();
        wSecurityTab.setControl((Control)wSecurityComp);
    }

    void setUIText() {
        this.wUseSSL.setSelection(this.sslEnabled);
        this.sslTable.setEnabled(this.sslEnabled);
        this.sslTable.table.setEnabled(this.sslEnabled);
        this.sslTable.table.select(0);
        this.sslTable.table.showSelection();
    }

    private void buildSSLTable(Composite parentWidget, Control relativePosition) {
        ColumnInfo[] columns = this.getSSLColumns();
        this.sslTable = new TableView((VariableSpace)this.transMeta, parentWidget, 67586, columns, 0, false, this.lsMod, this.props, false);
        this.sslTable.setSortable(false);
        this.sslTable.getTable().addListener(11, event -> {
            Table table = (Table)event.widget;
            table.getColumn(1).setWidth(200);
            table.getColumn(2).setWidth(200);
        });
        this.populateSSLData();
        FormData fdData = new FormData();
        fdData.left = new FormAttachment(0, 0);
        fdData.top = new FormAttachment(relativePosition, 5);
        fdData.bottom = new FormAttachment(100, 0);
        fdData.width = 430;
        Arrays.stream(this.sslTable.getTable().getColumns()).forEach(column -> {
            if (column.getWidth() > 0) {
                column.setWidth(200);
            }
        });
        this.sslTable.setLayoutData((Object)fdData);
    }

    private ColumnInfo[] getSSLColumns() {
        ColumnInfo optionName = new ColumnInfo(BaseMessages.getString(PKG, (String)"MQTTDialog.Security.SSL.Column.Name", (String[])new String[0]), 1, false, false);
        ColumnInfo value = new ColumnInfo(BaseMessages.getString(PKG, (String)"MQTTDialog.Security.SSL.Column.Value", (String[])new String[0]), 1, false, false, 200);
        value.setUsingVariables(true);
        return new ColumnInfo[]{optionName, value};
    }

    private void populateSSLData() {
        this.sslTable.getTable().removeAll();
        new TableItem(this.sslTable.getTable(), 0);
        Preconditions.checkNotNull((Object)this.sslTable.getItem(0));
        Preconditions.checkState((this.sslTable.getItem(0).length == 2 ? 1 : 0) != 0);
        ArrayList keys = Lists.newArrayList(this.sslConfig.keySet());
        Collections.sort(keys);
        String firstKey = (String)keys.remove(0);
        this.sslTable.getTable().getItem(0).setText(1, firstKey);
        this.sslTable.getTable().getItem(0).setText(2, this.sslConfig.get(firstKey));
        keys.forEach(key -> this.sslTable.add(new String[]{key, this.sslConfig.get(key)}));
    }

    private Map<String, String> tableToMap(TableView table) {
        return IntStream.range(0, table.getItemCount()).mapToObj(arg_0 -> ((TableView)table).getItem(arg_0)).collect(Collectors.toMap(strArray -> strArray[0], strArray -> strArray[1]));
    }

    public void setUsername(String username) {
        this.authComposite.setUsername(username);
    }

    public String getUsername() {
        return this.authComposite.getUsername();
    }

    public void setPassword(String password) {
        this.authComposite.setPassword(password);
    }

    public String getPassword() {
        return this.authComposite.getPassword();
    }
}

