/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.owasp.encoder.Encode;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingObjectType;
import org.pentaho.di.core.logging.SimpleLoggingObject;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobConfiguration;
import org.pentaho.di.www.BaseHttpServlet;
import org.pentaho.di.www.CarteObjectEntry;
import org.pentaho.di.www.CartePluginInterface;
import org.pentaho.di.www.JobMap;
import org.pentaho.di.www.WebResult;
import org.pentaho.di.www.cache.CarteStatusCache;

public class StartJobServlet
extends BaseHttpServlet
implements CartePluginInterface {
    private static Class<?> PKG = StartJobServlet.class;
    private static final long serialVersionUID = -8487225953910464032L;
    public static final String CONTEXT_PATH = "/kettle/startJob";
    @VisibleForTesting
    CarteStatusCache cache = CarteStatusCache.getInstance();

    public StartJobServlet() {
    }

    public StartJobServlet(JobMap jobMap) {
        super(jobMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter out;
        boolean useXML;
        block28: {
            if (this.isJettyMode() && !request.getContextPath().startsWith(CONTEXT_PATH)) {
                return;
            }
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"StartJobServlet.Log.StartJobRequested", (String[])new String[0]));
            }
            String jobName = request.getParameter("name");
            String id = request.getParameter("id");
            useXML = "Y".equalsIgnoreCase(request.getParameter("xml"));
            response.setStatus(200);
            out = response.getWriter();
            String h1End = "</H1>";
            String h1 = "<H1>";
            String hrefEnd = "</a><p>";
            String href = "<a href=\"";
            if (jobName == null && id == null) {
                response.setStatus(400);
                String message = BaseMessages.getString(PKG, (String)"StartJobServlet.Log.JobNameOrIdIsMandatory", (String[])new String[0]);
                if (useXML) {
                    response.setContentType("text/xml");
                    response.setCharacterEncoding("UTF-8");
                    out.print(XMLHandler.getXMLHeader((String)"UTF-8"));
                    out.println(new WebResult("ERROR", message));
                } else {
                    response.setContentType("text/html;charset=UTF-8");
                    out.println("<HTML>");
                    out.println("<HEAD>");
                    out.println("<TITLE>Start job</TITLE>");
                    out.println("<META http-equiv=\"Refresh\" content=\"2;url=" + this.convertContextPath("/kettle/status") + "\">");
                    out.println("<META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
                    out.println("</HEAD>");
                    out.println("<BODY>");
                    out.println(h1 + Encode.forHtml((String)message) + h1End);
                    out.println(href + this.convertContextPath("/kettle/status") + "\">" + BaseMessages.getString(PKG, (String)"TransStatusServlet.BackToStatusPage", (String[])new String[0]) + hrefEnd);
                    out.println("</BODY>");
                    out.println("</HTML>");
                }
                return;
            }
            if (useXML) {
                response.setContentType("text/xml");
                response.setCharacterEncoding("UTF-8");
                out.print(XMLHandler.getXMLHeader((String)"UTF-8"));
            } else {
                response.setContentType("text/html;charset=UTF-8");
                out.println("<HTML>");
                out.println("<HEAD>");
                out.println("<TITLE>Start job</TITLE>");
                out.println("<META http-equiv=\"Refresh\" content=\"2;url=" + this.convertContextPath("/kettle/status") + "?name=" + URLEncoder.encode(jobName, "UTF-8") + "\">");
                out.println("<META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
                out.println("</HEAD>");
                out.println("<BODY>");
            }
            try {
                Job job;
                CarteObjectEntry entry;
                if (Utils.isEmpty((CharSequence)id)) {
                    entry = this.getJobMap().getFirstCarteObjectEntry(jobName);
                    if (entry == null) {
                        job = null;
                    } else {
                        id = entry.getId();
                        job = this.getJobMap().getJob(entry);
                    }
                } else {
                    entry = new CarteObjectEntry(jobName, id);
                    job = this.getJobMap().getJob(entry);
                    if (job != null && job.getJobMeta() != null) {
                        jobName = job.getJobMeta().getName();
                    }
                }
                if (job != null) {
                    if (job.isInitialized() && !job.isActive()) {
                        if (job.getRep() != null && !job.getRep().isConnected()) {
                            if (job.getRep().getUserInfo() != null) {
                                job.getRep().connect(job.getRep().getUserInfo().getLogin(), job.getRep().getUserInfo().getPassword());
                            } else {
                                job.getRep().connect(null, null);
                            }
                        }
                        this.cache.remove(job.getLogChannelId());
                        StartJobServlet startJobServlet = this;
                        synchronized (startJobServlet) {
                            JobConfiguration jobConfiguration = this.getJobMap().getConfiguration(jobName);
                            String carteObjectId = UUID.randomUUID().toString();
                            SimpleLoggingObject servletLoggingObject = new SimpleLoggingObject(CONTEXT_PATH, LoggingObjectType.CARTE, null);
                            servletLoggingObject.setContainerObjectId(carteObjectId);
                            Job newJob = new Job(job.getRep(), job.getJobMeta(), (LoggingObjectInterface)servletLoggingObject);
                            newJob.setLogLevel(job.getLogLevel());
                            KettleLogStore.discardLines((String)job.getLogChannelId(), (boolean)true);
                            this.getJobMap().replaceJob(entry, newJob, jobConfiguration);
                            job = newJob;
                        }
                    }
                    this.runJob(job);
                    String message = BaseMessages.getString(PKG, (String)"StartJobServlet.Log.JobStarted", (String[])new String[]{jobName});
                    if (useXML) {
                        out.println(new WebResult("OK", message, id).getXML());
                    } else {
                        out.println(h1 + Encode.forHtml((String)message) + h1End);
                        out.println(href + this.convertContextPath("/kettle/jobStatus") + "?name=" + URLEncoder.encode(jobName, "UTF-8") + "&id=" + URLEncoder.encode(id, "UTF-8") + "\">" + BaseMessages.getString(PKG, (String)"JobStatusServlet.BackToJobStatusPage", (String[])new String[0]) + hrefEnd);
                    }
                    break block28;
                }
                String message = BaseMessages.getString(PKG, (String)"StartJobServlet.Log.SpecifiedJobNotFound", (String[])new String[]{jobName});
                response.setStatus(404);
                if (useXML) {
                    out.println(new WebResult("ERROR", message));
                } else {
                    out.println(h1 + Encode.forHtml((String)message) + h1End);
                    out.println(href + this.convertContextPath("/kettle/status") + "\">" + BaseMessages.getString(PKG, (String)"TransStatusServlet.BackToStatusPage", (String[])new String[0]) + hrefEnd);
                }
            }
            catch (Exception ex) {
                response.setStatus(500);
                if (useXML) {
                    out.println(new WebResult("ERROR", BaseMessages.getString(PKG, (String)"StartJobServlet.Error.UnexpectedError", (String[])new String[]{Const.CR + Const.getStackTracker((Throwable)ex)})));
                }
                out.println("<p>");
                out.println("<pre>");
                out.println(Encode.forHtml((String)Const.getStackTracker((Throwable)ex)));
                out.println("</pre>");
            }
        }
        if (!useXML) {
            out.println("<p>");
            out.println("</BODY>");
            out.println("</HTML>");
        }
    }

    public String toString() {
        return "Start job";
    }

    @Override
    public String getService() {
        return "/kettle/startJob (" + this.toString() + ")";
    }

    protected void runJob(Job job) throws KettleException {
        job.start();
    }

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }
}

