/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.owasp.encoder.Encode;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransConfiguration;
import org.pentaho.di.trans.TransExecutionConfiguration;
import org.pentaho.di.www.BaseHttpServlet;
import org.pentaho.di.www.CarteObjectEntry;
import org.pentaho.di.www.CartePluginInterface;
import org.pentaho.di.www.TransformationMap;
import org.pentaho.di.www.WebResult;
import org.pentaho.di.www.cache.CarteStatusCache;

public class PrepareExecutionTransServlet
extends BaseHttpServlet
implements CartePluginInterface {
    private static Class<?> PKG = PrepareExecutionTransServlet.class;
    private static final long serialVersionUID = 3634806745372015720L;
    public static final String CONTEXT_PATH = "/kettle/prepareExec";
    private CarteStatusCache cache = CarteStatusCache.getInstance();

    public PrepareExecutionTransServlet() {
    }

    public PrepareExecutionTransServlet(TransformationMap transformationMap) {
        super(transformationMap);
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter out;
        boolean useXML;
        block19: {
            if (this.isJettyMode() && !request.getContextPath().startsWith(CONTEXT_PATH)) {
                return;
            }
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"PrepareExecutionTransServlet.TransPrepareExecutionRequested", (String[])new String[0]));
            }
            String transName = request.getParameter("name");
            String id = request.getParameter("id");
            useXML = "Y".equalsIgnoreCase(request.getParameter("xml"));
            response.setStatus(200);
            out = response.getWriter();
            if (useXML) {
                response.setContentType("text/xml");
                out.print(XMLHandler.getXMLHeader((String)"UTF-8"));
            } else {
                response.setCharacterEncoding("UTF-8");
                response.setContentType("text/html;charset=UTF-8");
                out.println("<HTML>");
                out.println("<HEAD>");
                out.println("<TITLE>" + BaseMessages.getString(PKG, (String)"PrepareExecutionTransServlet.TransPrepareExecution", (String[])new String[0]) + "</TITLE>");
                out.println("<META http-equiv=\"Refresh\" content=\"2;url=" + this.convertContextPath("/kettle/transStatus") + "?name=" + URLEncoder.encode(transName, "UTF-8") + "\">");
                out.println("<META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
                out.println("</HEAD>");
                out.println("<BODY>");
            }
            try {
                Trans trans;
                CarteObjectEntry entry;
                if (Utils.isEmpty((CharSequence)id)) {
                    entry = this.getTransformationMap().getFirstCarteObjectEntry(transName);
                    if (entry == null) {
                        trans = null;
                    } else {
                        id = entry.getId();
                        trans = this.getTransformationMap().getTransformation(entry);
                    }
                } else {
                    entry = new CarteObjectEntry(transName, id);
                    trans = this.getTransformationMap().getTransformation(entry);
                }
                TransConfiguration transConfiguration = this.getTransformationMap().getConfiguration(entry);
                if (trans != null && transConfiguration != null) {
                    TransExecutionConfiguration executionConfiguration = transConfiguration.getTransExecutionConfiguration();
                    trans.setArguments(executionConfiguration.getArgumentStrings());
                    trans.setReplayDate(executionConfiguration.getReplayDate());
                    trans.setSafeModeEnabled(executionConfiguration.isSafeModeEnabled());
                    trans.setGatheringMetrics(executionConfiguration.isGatheringMetrics());
                    trans.injectVariables(executionConfiguration.getVariables());
                    trans.setPreviousResult(executionConfiguration.getPreviousResult());
                    trans.setExecutingClustered(executionConfiguration.isExecutingClustered());
                    try {
                        trans.prepareExecution(null);
                        this.cache.remove(trans.getLogChannelId());
                        if (useXML) {
                            out.println(WebResult.OK.getXML());
                            break block19;
                        }
                        out.println("<H1>" + Encode.forHtml((String)BaseMessages.getString(PKG, (String)"PrepareExecutionTransServlet.TransPrepared", (String[])new String[]{transName})) + "</H1>");
                        out.println("<a href=\"" + this.convertContextPath("/kettle/transStatus") + "?name=" + URLEncoder.encode(transName, "UTF-8") + "&id=" + URLEncoder.encode(id, "UTF-8") + "\">" + BaseMessages.getString(PKG, (String)"TransStatusServlet.BackToTransStatusPage", (String[])new String[0]) + "</a><p>");
                    }
                    catch (Exception e) {
                        String logText = KettleLogStore.getAppender().getBuffer(trans.getLogChannel().getLogChannelId(), true).toString();
                        if (useXML) {
                            out.println(new WebResult("ERROR", BaseMessages.getString(PKG, (String)"PrepareExecutionTransServlet.Error.TransInitFailed", (String[])new String[]{Const.CR + logText + Const.CR + Const.getStackTracker((Throwable)e)})));
                            break block19;
                        }
                        out.println("<H1>" + Encode.forHtml((String)BaseMessages.getString(PKG, (String)"PrepareExecutionTransServlet.Log.TransNotInit", (String[])new String[]{transName})) + "</H1>");
                        out.println("<pre>");
                        out.println(Encode.forHtml((String)logText));
                        out.println(Encode.forHtml((String)Const.getStackTracker((Throwable)e)));
                        out.println("</pre>");
                        out.println("<a href=\"" + this.convertContextPath("/kettle/transStatus") + "?name=" + URLEncoder.encode(transName, "UTF-8") + "&id=" + id + "\">" + BaseMessages.getString(PKG, (String)"TransStatusServlet.BackToTransStatusPage", (String[])new String[0]) + "</a><p>");
                        response.setStatus(400);
                    }
                    break block19;
                }
                if (useXML) {
                    out.println(new WebResult("ERROR", BaseMessages.getString(PKG, (String)"TransStatusServlet.Log.CoundNotFindSpecTrans", (String[])new String[]{transName})));
                } else {
                    out.println("<H1>" + Encode.forHtml((String)BaseMessages.getString(PKG, (String)"TransStatusServlet.Log.CoundNotFindTrans", (String[])new String[]{transName})) + "</H1>");
                    out.println("<a href=\"" + this.convertContextPath("/kettle/status") + "\">" + BaseMessages.getString(PKG, (String)"TransStatusServlet.BackToStatusPage", (String[])new String[0]) + "</a><p>");
                    response.setStatus(400);
                }
            }
            catch (Exception ex) {
                if (useXML) {
                    out.println(new WebResult("ERROR", BaseMessages.getString(PKG, (String)"PrepareExecutionTransServlet.Error.UnexpectedError", (String[])new String[]{Const.CR + Const.getStackTracker((Throwable)ex)})));
                }
                out.println("<p>");
                out.println("<pre>");
                out.println(Encode.forHtml((String)Const.getStackTracker((Throwable)ex)));
                out.println("</pre>");
                response.setStatus(400);
            }
        }
        if (!useXML) {
            out.println("<p>");
            out.println("</BODY>");
            out.println("</HTML>");
        }
    }

    public String toString() {
        return "Start transformation";
    }

    @Override
    public String getService() {
        return "/kettle/prepareExec (" + this.toString() + ")";
    }

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }
}

