/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.streaming.common;

import io.reactivex.Flowable;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.SubtransExecutor;
import org.pentaho.di.trans.streaming.api.StreamWindow;
import org.pentaho.di.trans.streaming.common.BaseStreamStep;

public class FixedTimeStreamWindow<I extends List>
implements StreamWindow<I, Result> {
    private static final Class<?> PKG = BaseStreamStep.class;
    private final RowMetaInterface rowMeta;
    private final long millis;
    private final int batchSize;
    private SubtransExecutor subtransExecutor;
    private int parallelism;
    private final Consumer<Map.Entry<List<I>, Result>> postProcessor;
    private int sharedStreamingBatchPoolSize = 0;
    private static ThreadPoolExecutor sharedStreamingBatchPool;
    private final int rxBatchCount;

    public FixedTimeStreamWindow(SubtransExecutor subtransExecutor, RowMetaInterface rowMeta, long millis, int batchSize, int parallelism) {
        this(subtransExecutor, rowMeta, millis, batchSize, parallelism, p -> {});
    }

    public FixedTimeStreamWindow(SubtransExecutor subtransExecutor, RowMetaInterface rowMeta, long millis, int batchSize, int parallelism, Consumer<Map.Entry<List<I>, Result>> postProcessor) {
        this.subtransExecutor = subtransExecutor;
        this.rowMeta = rowMeta;
        this.millis = millis;
        this.batchSize = batchSize;
        this.parallelism = parallelism;
        this.postProcessor = postProcessor;
        this.rxBatchCount = millis == 0L && batchSize > 0 && batchSize < subtransExecutor.getPrefetchCount() ? subtransExecutor.getPrefetchCount() / batchSize : this.subtransExecutor.getPrefetchCount();
        try {
            this.sharedStreamingBatchPoolSize = Integer.parseInt(System.getProperties().getProperty("SHARED_STREAMING_BATCH_POOL_SIZE", "0"));
            if (this.sharedStreamingBatchPoolSize > 0) {
                if (sharedStreamingBatchPool == null) {
                    sharedStreamingBatchPool = (ThreadPoolExecutor)Executors.newFixedThreadPool(this.sharedStreamingBatchPoolSize);
                } else if (sharedStreamingBatchPool.getCorePoolSize() != this.sharedStreamingBatchPoolSize) {
                    sharedStreamingBatchPool.setMaximumPoolSize(this.sharedStreamingBatchPoolSize);
                    sharedStreamingBatchPool.setCorePoolSize(this.sharedStreamingBatchPoolSize);
                }
            }
        }
        catch (NumberFormatException e) {
            this.sharedStreamingBatchPoolSize = 0;
        }
    }

    @Override
    public Iterable<Result> buffer(Flowable<I> flowable) {
        Flowable buffer = this.millis > 0L ? (this.batchSize > 0 ? flowable.buffer(this.millis, TimeUnit.MILLISECONDS, Schedulers.io(), this.batchSize, ArrayList::new, true) : flowable.buffer(this.millis, TimeUnit.MILLISECONDS)) : flowable.buffer(this.batchSize);
        return buffer.parallel(this.parallelism, this.rxBatchCount).runOn(this.sharedStreamingBatchPoolSize > 0 ? Schedulers.from((Executor)sharedStreamingBatchPool) : Schedulers.io(), this.rxBatchCount).filter(list -> !list.isEmpty()).map(this::sendBufferToSubtrans).filter(Optional::isPresent).map(Optional::get).sequential().doOnNext(this::failOnError).doOnNext(this.postProcessor).map(Map.Entry::getValue).blockingIterable();
    }

    private void failOnError(Map.Entry<List<I>, Result> pair) throws KettleException {
        if (pair.getValue().getNrErrors() > 0L) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"FixedTimeStreamWindow.SubtransFailed", (String[])new String[0]));
        }
    }

    private Optional<Map.Entry<List<I>, Result>> sendBufferToSubtrans(List<I> input) throws KettleException {
        List<RowMetaAndData> rows = input.stream().map(row -> row.toArray(new Object[0])).map(objects -> new RowMetaAndData(this.rowMeta, objects)).collect(Collectors.toList());
        Optional<Result> optionalRes = this.subtransExecutor.execute(rows);
        return optionalRes.map(result -> new AbstractMap.SimpleImmutableEntry<List, Result>(input, (Result)result));
    }
}

